<?php
// AShop
// Copyright 2002-2018 - All Rights Reserved Worldwide
// http://www.ashopsoftware.com
// This software is licensed per individual site.
// By installing or using this software, you agree to the licensing terms,
// which are located at http://www.ashopsoftware.com/license.htm
// Unauthorized use or distribution of this software 
// is a violation U.S. and international copyright laws.

unset($shop);
include "../admin/checklicense.inc.php";

// Deactivate shopping mall, if requested...
if (!$enablemall) {
	header("Location: $ashopurl");
	exit;
}

// Validate input variables...
if (!empty($email) && !ashop_is_email(strtolower($email))) $email = "";
if (!empty($url) && substr($url,0,7) != "http://" && substr($url,0,8) != "https://") $url = "http://".$url;
if (!empty($url) && !ashop_is_url($url)) $url = "";
$shopuser = ashop_mailsafe($shopuser);
$shopuser = ashop_cleanfield($shopuser);
if (strlen($shopuser) < 2) $shopuser = "";
$shopname = ashop_mailsafe($shopname);
$shopname = ashop_cleanfield($shopname);
if (strlen($shopname) < 2) $shopname = "";
$businesstype = ashop_mailsafe($businesstype);
$businesstype = ashop_cleanfield($businesstype);
if (strlen($businesstype) < 2) $businesstype = "";
$firstname = ashop_mailsafe($firstname);
$firstname = ashop_cleanfield($firstname);
if (strlen($firstname) < 2) $firstname = "";
$lastname = ashop_mailsafe($lastname);
$lastname = ashop_cleanfield($lastname);
if (strlen($lastname) < 2) $lastname = "";
$email = ashop_mailsafe($email);
$email = ashop_cleanfield($email);
if (strlen($email) < 2) $email = "";
$address = ashop_mailsafe($address);
$address = ashop_cleanfield($address);
if (strlen($address) < 2) $address = "";
$state = ashop_mailsafe($state);
$state = ashop_cleanfield($state);
if (strlen($state) < 2) $state = "";
$province = ashop_mailsafe($province);
$province = ashop_cleanfield($province);
if (strlen($province) < 2) $province = "";
if (empty($state) && !empty($province)) $state = $province;
$zip = ashop_mailsafe($zip);
$zip = ashop_cleanfield($zip);
if (strlen($zip) < 2) $zip = "";
$city = ashop_mailsafe($city);
$city = ashop_cleanfield($city);
if (strlen($city) < 2) $city = "";
$country = ashop_mailsafe($country);
$country = ashop_cleanfield($country);
if (strlen($country) < 2) $country = "";
$phone = ashop_mailsafe($phone);
$phone = ashop_cleanfield($phone);
if (strlen($phone) < 2) $phone = "";

// Check for GD...
$checkgd = TRUE;
if (empty($recaptchakey)) include "../includes/captcha.inc.php";

// If GD is available generate random code for security check...
if (function_exists('imagecreatefromjpeg') && function_exists('imagecreatefromgif') && function_exists('imagecreatetruecolor') && $gdversion == 2) {
	$activatesecuritycheck = TRUE;
	// Generate new random code...
	mt_srand ((double)microtime()*1000000);
	$maxrandom = 1000000;
	$random = mt_rand(0, $maxrandom);
} else $activatesecuritycheck = FALSE;

// Apply selected theme...
$buttonpath = "";
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none" && file_exists("$ashoppath/themes/$ashoptheme/theme.cfg.php")) include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemebuttons == "true") $buttonpath = "themes/$ashoptheme/";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";
if ($lang && is_array($themelanguages)) {
	if (!in_array("$lang",$themelanguages)) unset($lang);
}

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/dm_signupform.inc.php";

include "../admin/ashopconstants.inc.php";

// Show header using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/membersignup-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/membersignup.html");

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

if (is_array($memberpayoutoptions)) {
	echo "
<script language=\"JavaScript\">
<!--
	function paymentTemplate(signupform) {
		if (signupform.paymentmethod.value=='0') signupform.paymentdetails.value='';";
foreach($memberpayoutoptions as $payoutnumber=>$payouttext) echo "
		else if (signupform.paymentmethod.value=='$payoutnumber') signupform.paymentdetails.value='$payouttext'";

echo "	}
-->
</script>";
}
echo "
<script language=\"JavaScript\" src=\"../includes/switchstates.js.php\" type=\"text/javascript\"></script>
<div class=\"span5\">

      <p><strong>".APPLY." $ashopname</strong></p>";
	  if (empty($cpanelapiuser) || empty($cpanelapipass)) echo "<p>".ALREADYSIGNEDUP." <a href=\"../admin/login.php\">".LOGINHERE."</a></p>";
if (!empty($shoppingmallinfo)) echo "
      <p>$shoppingmallinfo</p>";
echo "
</div>
<div class=\"span7\">\n<h4 class=\"title\"><span class=\"text\"><strong>REGISTER</strong> FORM</span></h4>
            <form action=\"signup.php\" method=post name=\"signupform\">
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".USERNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"shopuser\" value=\"$shopuser\" class=\"input-xlarge\"> ".MAXCHARS."
                  </div>
              </div>";
if ($membershops) {
	echo "<div class=\"control-group\"> 
                  <label class=\"control-label\">".NAMEOFSHOP.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"shopname\" value=\"$shopname\" class=\"input-xlarge\">"; if (!empty($cpanelapiuser) && !empty($cpanelapipass) && !empty($cpaneldomain)) echo " .$cpaneldomain"; echo "
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".CATEGORIES.":</label>
                  <div class=\"controls\"> 
                    <select name=\"shopcategories[]\" size=\"5\" multiple class=\"input-xlarge\">";

   $categories = @mysqli_query($db, "SELECT * FROM shopcategory ORDER BY name");
   while ($row = @mysqli_fetch_array($categories)) {
	   echo "<option value=\"{$row["categoryid"]}\"";
	   if (!empty($shopcategories) && in_array($row["categoryid"],$shopcategories)) echo " selected";
	   echo ">{$row["name"]}";
   }

   echo "</select><br>".CTRLCLICK."
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".SHOPDESCRIPTION.":</label>
                  <div class=\"controls\"> 
                    <textarea name=\"description\" cols=\"30\" rows=\"4\" class=\"input-xlarge\">$description</textarea>
                  </div>
              </div>";
} else echo "<input type=\"hidden\" name=\"shopname\" value=\"$ashopname\">";
echo "<div class=\"control-group\"> 
                  <label class=\"control-label\">".BUSINESSTYPE.":</label>
                  <div class=\"controls\"> 
                    <select name=\"businesstype\" class=\"input-xlarge\">
					<option value=\"none\""; if ($businesstype == "none") echo " selected"; echo ">".SELECTONE."</option>
					<option value=\"soleproprietor\""; if ($businesstype == "soleproprietor") echo " selected"; echo ">".SOLEPROPRIETOR."</option>
					<option value=\"corporation\""; if ($businesstype == "corporation") echo " selected"; echo ">".CORPORATION."</option>
					<option value=\"nonprofit\""; if ($businesstype == "nonprofit") echo " selected"; echo ">".NONPROFIT."</option>
					</select>
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".FIRSTNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"firstname\" value=\"$firstname\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".LASTNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"lastname\" value=\"$lastname\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".EMAIL.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"email\" value=\"$email\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".ADDRESS.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"address\" value=\"$address\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".CITY.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"city\" value=\"$city\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".ZIP.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"zip\" value=\"$zip\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".COUNTRY.":</label>
                  <div class=\"controls\"> 
                    <select name=\"country\" onChange=\"switchStates(document.getElementById('state'),document.signupform.province,document.signupform.country.value);\" onClick=\"if (typeof(countryinterval) != 'undefined') window.clearInterval(countryinterval);\"><option  value=none>".CHOOSECOUNTRY;
foreach ($countries as $shortcountry => $longcountry) {
	if (strlen($longcountry) > 30) $longcountry = substr($longcountry,0,27)."...";
	echo "<option value=\"$shortcountry\">$longcountry\n";
}
echo "</select>
                  </div>
              </div>
              <div class=\"control-group\" id=\"stateselector\" style=\"display:none\"> 
                  <label class=\"control-label\">".STATE.":</label>
                  <div class=\"controls\"> 
                    <select name=\"state\" id=\"state\" class=\"input-xlarge\"><option value=none>".CHOOSESTATE."</select>
                  </div>
              </div>
              <div class=\"control-group\" id=\"regionrow\" style=\"display:none\"> 
                  <label class=\"control-label\">".PROVINCE.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"province\" value=\"$province\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".PHONE.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"phone\" value=\"$phone\" class=\"input-xlarge\">
                  </div>
              </div>";
				if (empty($cpanelapiuser) || empty($cpanelapipass)) echo "
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".URL.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"url\" value=\"$url\" class=\"input-xlarge\">
                  </div>
              </div>";
                if (is_array($memberpayoutnames) && is_array($memberpayoutoptions) && !$memberpayoptions && (!$cpanelapiuser || !$cpanelapipass || !$cpanelapiurl)) {
					echo "
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".PAYMENTDETAILS.":</label>
                  <div class=\"controls\"> 
                    <select name=\"paymentmethod\" onChange=\"paymentTemplate(signupform)\" class=\"input-xlarge\"><option value=\"0\">".CHOOSEMETHOD;
					foreach ($memberpayoutnames as $payoutnumber=>$payoutname) echo "<option value=\"$payoutnumber\">$payoutname";
					echo "</select>
                  </div>
              </div>
              <div class=\"control-group\"> 
				  <div class=\"controls\"><textarea name=\"paymentdetails\" cols=\"30\" rows=\"5\" class=\"input-xlarge\">$paymentdetails</textarea>
                  </div>
              </div>";
				}
				if ($activatesecuritycheck) {
					echo "<div class=\"control-group\"> 
                  <label class=\"control-label\">".SECURITYCODE.":</label>
                  <div class=\"controls\"> 
                    <img src=\"signup.php?action=generatecode&random=$random\" style=\"border: 1px solid #000;\" alt=\"Security Code\" title=\"Security Code\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".TYPESECURITYCODE.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"securitycheck\" class=\"input-medium\"><input type=\"hidden\" name=\"random\" value=\"$random\">
                  </div>
              </div>";
			    } else if (!empty($recaptchakey)) {
                    echo "
              <div class=\"g-recaptcha\" data-sitekey=\"$recaptchakey\"></div>";
                }
			  echo "
                <p><button class=\"btn btn-inverse\">".SUBMIT."</button></p>
            </form>
      </div>";

echo "<script language=\"JavaScript\" type=\"text/javascript\">
/* <![CDATA[ */
	var currentcntry = document.signupform.country.value;
	function makechange() {
		if (document.signupform.country.value != window.currentcntry) {
			switchStates(document.getElementById('state'),document.signupform.province,document.signupform.country.value);
			window.currentcntry = document.signupform.country.value;
		}
	}
	var countryinterval = window.setInterval(\"makechange()\",1000);
/* ]]> */
</script>";

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/membersignup-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/membersignup.html");
?>