<?php
if (!isset($databaseuser)) {
    $standalone = TRUE;
    include "../admin/config.inc.php";
} else $standalone = FALSE;

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

@mysqli_query($db, "CREATE TABLE emerchant_comments (
   id int(11) NOT NULL auto_increment,
   customerid int(11) DEFAULT '0' NOT NULL,
   date varchar(20) NOT NULL,
   subject varchar(255) NOT NULL,
   reference varchar(255) NOT NULL,
   comment text NOT NULL,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_vendorcomments (
   id int(11) NOT NULL auto_increment,
   vendorid int(11) DEFAULT '0' NOT NULL,
   vendcontactid int(11),
   date varchar(20) NOT NULL,
   subject varchar(255) NOT NULL,
   reference varchar(255) NOT NULL,
   comment text NOT NULL,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_inbox (
   id int(11) NOT NULL auto_increment,
   uid int(11),
   received varchar(30) NOT NULL,
   name varchar(100),
   email varchar(100) NOT NULL,
   returnpath varchar(100),
   subject varchar(255) NOT NULL,
   attachments int,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_inbox2 (
   id int(11) NOT NULL auto_increment,
   uid int(11),
   received varchar(30) NOT NULL,
   name varchar(100),
   email varchar(100) NOT NULL,
   returnpath varchar(100),
   subject varchar(255) NOT NULL,
   attachments int,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_spam (
   id int(11) NOT NULL auto_increment,
   uid int(11),
   source int,
   received varchar(30) NOT NULL,
   name varchar(100),
   email varchar(100) NOT NULL,
   returnpath varchar(100),
   subject varchar(255) NOT NULL,
   attachments int,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_messages (
   id int(11) NOT NULL auto_increment,
   uid int(11),
   customerid int(11) DEFAULT '0' NOT NULL,
   user varchar(30) DEFAULT '0' NOT NULL,
   replyto int(11),
   date varchar(30) NOT NULL,
   subject varchar(255) NOT NULL,
   attachments int,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_searchresult (
   searchid int(11) NOT NULL,
   messageid int(11) NOT NULL
)");

@mysqli_query($db, "CREATE TABLE emerchant_searches (
   id int(11) NOT NULL auto_increment,
   searchstring varchar(255) NOT NULL,
   searchtype varchar(10) NOT NULL,
   datecriteria varchar(15) NOT NULL,
   user varchar(30) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_domains (
   id int(11) NOT NULL auto_increment,
   domain varchar(255) NOT NULL,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_vendormessages (
   id int(11) NOT NULL auto_increment,
   uid int(11),
   vendorid int(11) DEFAULT '0' NOT NULL,
   vendcontactid int(11) DEFAULT '0' NOT NULL,
   user varchar(30) DEFAULT '0' NOT NULL,
   replyto int(11),
   date varchar(30) NOT NULL,
   subject varchar(255) NOT NULL,
   attachments int,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_quotes (
   id int(11) NOT NULL auto_increment,
   customerid int(11) DEFAULT '0' NOT NULL,
   user varchar(30),
   date varchar(30) NOT NULL,
   products varchar(255) NOT NULL,
   productprices varchar(255) NOT NULL,
   comments varchar(255),
   commentprices varchar(255),
   itemorder varchar(255) NOT NULL,
   commenttaxable varchar(255),
   shipping varchar(255),
   discount varchar(15),
   qqzip varchar(10),
   qqstate varchar(20),
   partyid int,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_tempinvoices (
   orderid int(11) NOT NULL,
   billnumber int(11),
   duedate varchar(30),
   products varchar(255) NOT NULL,
   productprices varchar(255) NOT NULL,
   comments varchar(255),
   commentprices varchar(255),
   itemorder varchar(255) NOT NULL,
   commenttaxable varchar(255),
   price float(10,2),
   shipping varchar(255)
)");

@mysqli_query($db, "CREATE TABLE emerchant_bills (
   orderid int(11) NOT NULL,
   billnumber int(11),
   reminderdate varchar(30),
   remindermessage text,
   remindersent int,
   pastduedate varchar(30),
   pastduemessage text,
   pastduesent int,
   sendbilldays int,
   recurring varchar(12),
   recurringtimes int,
   startdate varchar(30),
   enddate varchar(30),
   billcomment text
)");

@mysqli_query($db, "CREATE TABLE emerchant_billtemplates (
   billtemplateid int(11) NOT NULL auto_increment,
   name varchar(100),
   duedays int(11),
   reminderdays int(11),
   remindermessage text,
   pastduedays int(11),
   pastduemessage text,
   recurring varchar(12),
   recurringtimes int,
   sendbilldays int,
   templatetype varchar(50),
   PRIMARY KEY (billtemplateid)
)");

@mysqli_query($db, "CREATE TABLE emerchant_notes (
   id int(11) NOT NULL auto_increment,
   note varchar(255) NOT NULL,
   reusable int(11),
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_vendornotes (
   id int(11) NOT NULL auto_increment,
   note varchar(255) NOT NULL,
   reusable int(11),
   PRIMARY KEY (id)
)");

@mysqli_query($db, "CREATE TABLE emerchant_reminders (
   id int(11) NOT NULL auto_increment,
   username varchar(30),
   duedate date DEFAULT '0000-00-00' NOT NULL,
   subject varchar(255) NOT NULL,
   reference varchar(255) NOT NULL,
   reminder text NOT NULL,
   PRIMARY KEY (id)
)");

@mysqli_query($db, "INSERT INTO emerchant_reminders VALUES ( '1', '2008-06-30', 'Example of a Reminder', 'John Doe', 'This is an example of an eMerchant reminder.')");

@mysqli_query($db, "CREATE TABLE emerchant_user (
   username varchar(30) NOT NULL,
   password varchar(64) NOT NULL,
   sessionid varchar(50),
   ip varchar(15),
   activity varchar(30),
   mailcheck varchar(10),
   loginlock varchar(30),
   maillock varchar(7),
   PRIMARY KEY (username),
   UNIQUE username (username)
)");

@mysqli_query($db, "CREATE TABLE emerchant_configuration (
	confid int NOT NULL,
	confname varchar(30),
	confvalue text,
	PRIMARY KEY (confid)
)");

@mysqli_query($db, "CREATE TABLE emerchant_autobillreport (
   id int(11) NOT NULL auto_increment,
   orderid int(11),
   previousorderid int(11),
   customerid int(11),
   event varchar(30),
   date varchar(30),
   PRIMARY KEY (id)
)");

@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('1', 'pophost', 'mail.yourdomain.com')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('2', 'popuser', 'user')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('3', 'poppass', 'password')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('4', 'popport', '110')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('5', 'announcement', 'This message can be changed from the AShop admin panel')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('6', 'pophost2', 'mail.yourdomain.com')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('7', 'popuser2', 'user')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('8', 'poppass2', 'password')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('9', 'popport2', '110')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('10', 'customeremail', 'you@yourdomain.com')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('11', 'vendoremail', 'you@yourdomain.com')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('12', 'spamprotection', '0')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('14', 'defaultreminderdays', '3')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('15', 'defaultpastduedays', '5')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('16', 'defaultsendbilldays', '0')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('17', 'mailservertype', 'pop3')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('18', 'defaultduedays', '30')");
@mysqli_query($db, "INSERT INTO emerchant_configuration (confid, confname, confvalue) VALUES ('19', 'mailcheckonlogin', '1')");

// Initiate password hashing...
if (!class_exists("PasswordHash")) include "$ashoppath/includes/PasswordHash.php";
$passhasher = new PasswordHash(8, FALSE);
$passhash = $passhasher->HashPassword("emerchantadmin");
@mysqli_query($db, "INSERT INTO emerchant_user VALUES ( 'admin', '$passhash', '', '', '', '', '', '')");

@mysqli_query($db, "CREATE TABLE emerchant_links (
   id int(11) NOT NULL auto_increment,
   name varchar(50),
   url varchar(255),
   PRIMARY KEY (id)
)");

@mysqli_query($db, "INSERT INTO emerchant_links (name, url) VALUES ('Warranty, Return Policies', 'policies.html')");

@mysqli_query($db, "CREATE TABLE emerchant_vendor (
    name varchar(50),
	email varchar(50) not null,
	address varchar(50),
	zip varchar(10),
	city varchar(30),
	state varchar(30),
	country varchar(30),
	phone varchar(20),
	vendorid int4 not null auto_increment,
	PRIMARY KEY (vendorid)
)");

@mysqli_query($db, "CREATE TABLE emerchant_vendcontact (
    firstname varchar(50),
	lastname varchar(50),
	title varchar(50),
	email varchar(50) not null,
	phone varchar(20),
	vendorid int4 not null,
	vendcontactid int4 not null auto_increment,
	PRIMARY KEY (vendcontactid)
)");

@mysqli_query($db, "CREATE TABLE emerchant_purchaseorder (
	purchaseorderid int4 not null auto_increment,
	reference varchar(40),
	user varchar(30),
	vendorid int,
	orderid int,
	customerid int,
	date varchar(30),
	sent varchar(30),
	billdate varchar(30),
	closed varchar(30),
    products varchar(255) NOT NULL,
	productprices varchar(255) NOT NULL,
	comments varchar(255),
	commentprices varchar(255),
	itemorder varchar(255) NOT NULL,
	cost varchar(15),
	shipping varchar(255),
	discount varchar(15) default '0.00',
	tax varchar(15) default '0.00',
	billtotal varchar(15),
	shipdate varchar(30),
	paiddate VARCHAR(30),
	PRIMARY KEY (purchaseorderid)
)");

// Mark all current orders as processed...
unset($ordertablefields);
$result = @mysqli_query($db, "SELECT * FROM orders LIMIT 1");
while ($property = @mysqli_fetch_field($result)) {
    $ordertablefields[] = $property->name;
}
if (!in_array("shipped",$ordertablefields)) {
	@mysqli_query($db, "ALTER TABLE orders ADD shipped varchar(30)");
	$date = date("Y-m-d H:i:s", time()+$timezoneoffset);
	@mysqli_query($db, "UPDATE orders SET shipped='$date' WHERE paid!='' AND paid IS NOT NULL");
}

if ($standalone) {
    @mysqli_close($db);
    header("Location: login.php");
}
?>