<?php
// AShop
// Copyright 2018 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";
include "../admin/ashopconstants.inc.php";

// Check for GD...
$checkgd = TRUE;
if (empty($recaptchakey)) include "../includes/captcha.inc.php";

// If GD is available generate random code for security check...
if (function_exists('imagecreatefromjpeg') && function_exists('imagecreatefromgif') && function_exists('imagecreatetruecolor') && $gdversion == 2) {
	$activatesecuritycheck = TRUE;
	// Generate new random code...
	mt_srand ((double)microtime()*1000000);
	$maxrandom = 1000000;
	$random = mt_rand(0, $maxrandom);
} else $activatesecuritycheck = FALSE;

// Apply selected theme...
$buttonpath = "";
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none" && file_exists("$ashoppath/themes/$ashoptheme/theme.cfg.php")) include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemebuttons == "true") $buttonpath = "themes/$ashoptheme/";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";
if ($lang && is_array($themelanguages)) {
	if (!in_array("$lang",$themelanguages)) unset($lang);
}

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_signupform.inc.php";

// Make sure html code is being parsed...
if (function_exists("html_entity_decode")) {
	$affiliateinfo = html_entity_decode($affiliateinfo);
	$affiliateinfo = str_replace("&#039;","'",$affiliateinfo);
}

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");

echo "
<script language=\"JavaScript\" src=\"../includes/switchstates.js.php\" type=\"text/javascript\"></script>
<div class=\"span5\">
  <p><strong>".SIGNUPHERE." $ashopname ".AFFILIATEPROGRAM."</strong></p>
  <p>".ALREADYSIGNEDUP." <a href=\"login.php\">".LOGINHERE."</a></p>
  <p>$affiliateinfo</p>
  <p>".AFFILIATEMESSAGE."</p>
</div>
<div class=\"span7\">\n<h4 class=\"title\"><span class=\"text\"><strong>".REGISTER."</strong> FORM</span></h4>
	<form action=\"signup.php\" method=\"post\" name=\"signupform\">
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".USERNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"affuser\" class=\"input-xlarge\"> ".MAXCHARS."
                  </div>
              </div>
			  <div class=\"control-group\"> 
                  <label class=\"control-label\">".BUSINESS.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"business\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".FIRSTNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"firstname\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".LASTNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"lastname\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".EMAIL.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"email\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".ADDRESS.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"address\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".CITY.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"city\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".ZIP.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"zip\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".COUNTRY.":</label>
                  <div class=\"controls\"> 
                    <select name=\"country\" onchange=\"switchStates(document.getElementById('state'),document.signupform.province,document.signupform.country.value);\" onClick=\"if (typeof(countryinterval) != 'undefined') window.clearInterval(countryinterval);\" class=\"input-xlarge\"><option  value=\"none\">choose country</option>";
					foreach ($countries as $shortcountry => $longcountry) {
						if (strlen($longcountry) > 30) $longcountry = substr($longcountry,0,27)."...";
						echo "<option value=\"$shortcountry\">$longcountry</option>\n";
					}
					echo "</select>
                  </div>
              </div>
              <div class=\"control-group\" id=\"stateselector\" style=\"display:none\"> 
                  <label class=\"control-label\">".STATE.":</label>
                  <div class=\"controls\"> 
                    <select name=\"state\" id=\"state\" class=\"input-xlarge\"><option value=\"none\">".CHOOSESTATE."</option></select>
                  </div>
              </div>
              <div class=\"control-group\" id=\"regionrow\" style=\"display:none\"> 
                  <label class=\"control-label\">".PROVINCE.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"province\" class=\"input-xlarge\">
                  </div>
              </div>
			  <div class=\"control-group\"> 
                  <label class=\"control-label\">".PHONE.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"phone\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".URL.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"url\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".PAYPAL.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"paypalid\" class=\"input-xlarge\">
                  </div>
              </div>";
				if (!$requirepaypalid) echo "<p>".OPTIONAL."</p>";
				if ($activatesecuritycheck) {
					echo "
			  <div class=\"control-group\"> 
                  <label class=\"control-label\">".SECURITYCODE.":</label>
                  <div class=\"controls\"> 
                    <img src=\"../admin/afsignuppic.php?action=generatecode&amp;random=$random\" style=\"border: 1px solid #000;\" alt=\"Security Code\" title=\"Security Code\">
				  </div>
              </div>
			  <div class=\"control-group\"> 
                  <label class=\"control-label\">".TYPESECURITYCODE.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"securitycheck\" class=\"input-medium\">
					<input type=\"hidden\" name=\"random\" value=\"$random\" />
				  </div>
              </div>";
			    } else if (!empty($recaptchakey)) {
                    echo "
              <div class=\"g-recaptcha\" data-sitekey=\"$recaptchakey\"></div>";
                }
			    echo "\n<p><button class=\"btn btn-inverse\">".SUBMIT."</button></p>
            </form>
			</div>";

echo "<script language=\"JavaScript\" type=\"text/javascript\">
/* <![CDATA[ */
	var currentcntry = document.signupform.country.value;
	function makechange() {
		if (document.signupform.country.value != window.currentcntry) {
			switchStates(document.getElementById('state'),document.signupform.province,document.signupform.country.value);
			window.currentcntry = document.signupform.country.value;
		}
	}
	var countryinterval = window.setInterval(\"makechange()\",1000);
/* ]]> */
</script>";

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
?>