<?php
// AShop
// Copyright 2016 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";
include "checklogin.inc.php";

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_affiliate.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get affiliate information from database...
$sql="SELECT * FROM affiliate WHERE sessionid='$affiliatesesid'";
$result = @mysqli_query($db, "$sql");

// Store affiliate information in variables...
$firstname = @mysqli_result($result, 0, "firstname");
$lastname = @mysqli_result($result, 0, "lastname");
$affiliateid = @mysqli_result($result, 0, "affiliateid");
$correctpasswd = @mysqli_result($result, 0, "password");
$referralcode = @mysqli_result($result, 0, "referralcode");
$username = @mysqli_result($result, 0, "user");

// Get number of unread PMs...
$sql="SELECT * FROM affiliatepm WHERE toaffiliateid='$affiliateid' AND (hasbeenread='' OR hasbeenread='0' OR hasbeenread IS NULL)";
$unreadresult = @mysqli_query($db, "$sql");
$unreadcount = @mysqli_num_rows($unreadresult);

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");

echo "<div class=\"span3 sidebar\">
<ul class=\"nav nav-sidebar\">
<li><a href=\"affiliate.php\">".STATISTICS."</a></li>
<li><a href=\"changeprofile.php\">".VIEWPROFILE."</a></li>
<li><a href=\"changepassword.php\">".CHANGEPASS."</a></li>";
if (file_exists("$ashoppath/customerparties.php") && $enablepartyplanner == "1") echo "<li><a href=\"parties.php\">".PARTIES."</a></li>";
echo "<li class=\"active\"><a href=\"linkcodes.php\">".LINKCODES."</a></li>
<li><a href=\"orderhistory.php\">".ORDERHISTORY."</a></li>
<li><a href=\"downline.php\">".DOWNLINE."</a></li>";
if ($activateleads) echo "<li><a href=\"leads.php\">".LEADS."</a></li>";
echo "<li><a href=\"inbox.php\">".INBOX;
if ($unreadcount) echo " ($unreadcount)";
echo "</a></li>
<li><a href=\"login.php?logout\">".LOGOUT."</a></li>
</ul></div>";
$affiliatelink = "$ashopurl/affiliate.php?id=$affiliateid";
$affiliatelinklength = strlen($affiliatelink);
echo "<div class=\"span9\">\n<h4>".LINKCODES."</h4>\n
	<div class=\"control-group\"> 
                  <label class=\"control-label\">".YOURLINK.":</label>
                  <div class=\"controls\"><input id=\"affiliatelink\" type=\"text\" class=\"input-xxlarge\" value=\"$ashopurl/affiliate.php?id=$affiliateid\" onclick=\"document.getElementById('affiliatelink').select();\"></div>
              </div>";
echo "
	<div class=\"control-group\"> 
                  <label class=\"control-label\">".MANUALCODE.":</label>
                  <div class=\"controls\"><input id=\"affiliatereferrallink\" type=\"text\" class=\"input-medium\" value=\"$referralcode\" onclick=\"document.getElementById('affiliatereferrallink').select();\"></div>
              </div>";

// Show recruitment link if needed...
if ($secondtieractivated) {
	$sql="SELECT * FROM linkcodes WHERE linkid = 1";
	$result = @mysqli_query($db, "$sql");
	if (@mysqli_num_rows($result)) {
		$thislinktext = @mysqli_result($result, 0, "linktext");
		$newlinktext = str_replace("%affiliatelink%","$ashopurl/affiliate.php?id=$affiliateid&redirect=$ashopurl/affiliate/signupform.php",$thislinktext);
		$newlinktext2 = str_replace("&gt;",">",$newlinktext);
		$newlinktext2 = str_replace("&lt;","<",$newlinktext2);
		$thisfilename = @mysqli_result($result, 0, "filename");
		$thisalt = @mysqli_result($result, $i, "alt");
		echo "<p>".COPYLINK."</p><p><table class=\"ashopaffiliatecodebox\"><tr><td align=\"center\" colspan=\"2\">";
		if ($thisfilename) echo "<img src=\"../banners/$thisfilename\" alt=\"$thisalt\" border=\"0\"><br>";
		echo "<span class=\"ashopaffiliatetext2\">$newlinktext2</span></td></tr><tr><td align=\"right\"><span class=\"ashopaffiliatetext1\">".HTMLCODE."</span></td><td><textarea name=\"linktext\" readonly cols=\"50\" rows=\"5\" align=\"top\">";
		if ($thisfilename) echo "&lt;a href=\"$ashopurl/affiliate.php?id=$affiliateid&redirect=$ashopurl/affiliate/signupform.php\"&gt;&lt;img src=\"$ashopurl/banners/$thisfilename\" alt=\"$thisalt\" border=\"0\"&gt;&lt;/a&gt;&lt;br&gt;";
		echo "$newlinktext</textarea></td></tr></table></p>";
	}
}

echo "<p>".COPYPASTE."</span></p>
		<div class=\"accordion\" id=\"accordion2\">";

// Set default link code category...
if (empty($linkcat) || !is_numeric($linkcat)) {
	$result = @mysqli_query($db, "SELECT * FROM linkcategories ORDER BY linkcategoryname ASC LIMIT 1");
	$linkcat = @mysqli_result($result,0,"linkcategoryid");
	$showdefault = TRUE;
} else $showdefault = FALSE;

// Get link code categories...
$result = @mysqli_query($db, "SELECT * FROM linkcategories ORDER BY linkcategoryname ASC");
while($row = @mysqli_fetch_array($result)) {
	$linkcategoryid = $row["linkcategoryid"];
	$linkcategoryname = $row["linkcategoryname"];
	echo "
	<div class=\"accordion-group\">
		<div class=\"accordion-heading\">
			<a class=\"accordion-toggle\" data-toggle=\"collapse\" data-parent=\"#accordion2\" href=\"#collapse$linkcategoryid\">$linkcategoryname</a>
		</div>
		<div id=\"collapse$linkcategoryid\" class=\"accordion-body";
	//if ($linkcat == $linkcategoryid) echo " in";
	echo " collapse\">
		<div class=\"accordion-inner\">
			<div class=\"row-fluid\">
				<div class=\"span6\">";

	// Get link code information from database...
	$sql="SELECT * FROM linkcodes WHERE linkid > 1 AND linkcategoryid='$linkcategoryid'";
	$subresult = @mysqli_query($db, "$sql");
	for ($i = 0; $i < @mysqli_num_rows($subresult); $i++) { 
		$thisredirect = @mysqli_result($subresult, $i, "redirect");
		$thislinktext = @mysqli_result($subresult, $i, "linktext");
		$thisredirect = str_replace("%affiliateuser%",$username,$thisredirect);
		$thisfilename = @mysqli_result($subresult, $i, "filename");
		$thislinkid = @mysqli_result($subresult, $i, "linkid");
		$thisalt = @mysqli_result($subresult, $i, "alt");
		$isreplicatedsite = FALSE;
		if (!empty($thisredirect) && empty($thislinktext) && empty($thisfilename)) $isreplicatedsite = TRUE;
		else {
			$thisredirect = str_replace($ashopurl,"",$thisredirect);
			$thisredirect = str_replace($ashopsurl,"",$thisredirect);
			if(substr($thisredirect,0,1) == "/") $thisredirect = substr($thisredirect,1);
		}
		if ($thisredirect) {
			$newlinktext = str_replace("%affiliatelink%","$ashopurl/affiliate.php?id=$affiliateid&redirect=$thisredirect",$thislinktext);
			$newlinktext = str_replace("%affiliatecloaklink%","&lt;a href=\"$ashopurl\" onClick=\"window.open('$ashopurl/affiliate.php?id=$affiliateid&redirect=$thisredirect', 'PGM', 'scrollbars=yes, toolbar=yes, status=yes, menubar=yes location=yes resizable=yes'); return false;\"&gt;",$newlinktext);
		} else {
			$newlinktext = str_replace("%affiliatelink%","$ashopurl/affiliate.php?id=$affiliateid",$thislinktext);
			$newlinktext = str_replace("%affiliatecloaklink%","&lt;a href=\"$ashopurl\" onClick=\"window.open('$ashopurl/affiliate.php?id=$affiliateid', 'PGM', 'scrollbars=yes, toolbar=yes, status=yes, menubar=yes location=yes resizable=yes'); return false;\"&gt;",$newlinktext);
		}
		$newlinktext2 = str_replace("&gt;",">",$newlinktext);
		$newlinktext2 = str_replace("&lt;","<",$newlinktext2);
		if ($thisfilename) echo "<p><img src=\"../banners/$thisfilename\" alt=\"$thisalt\" border=\"0\"><p>";
		if ($isreplicatedsite) echo "<p>".URL." <textarea name=\"linktext\" readonly cols=\"50\" rows=\"2\" align=\"top\">$thisredirect</textarea></p>";
		else {
			echo "<ul><li>$newlinktext2</li></ul>\n<div class=\"control-group\"> 
                  <label class=\"control-label\">".HTMLCODE.":</label>
                  <div class=\"controls\"> 
                    <textarea name=\"linktext\" class=\"input-xxlarge\">";
			if ($thisfilename) {
				echo "&lt;a href=\"$ashopurl/affiliate.php?id=$affiliateid";
				if ($thisredirect) echo "&redirect=$thisredirect";
				echo "\"&gt;&lt;img src=\"$ashopurl/banners/$thisfilename\" alt=\"$thisalt\" border=\"0\"&gt;&lt;/a&gt;&lt;br&gt;";
			}
			echo "$newlinktext</textarea></div>
              </div>";
		}
	}

	echo "</div>\n</div>\n</div>\n</div>\n</div>\n";
}
echo "</div>";

// Close database...

@mysqli_close($db);

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
?>