<?php
// AShop
// Copyright 2018 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";
include "checklogin.inc.php";
include "../admin/ashopconstants.inc.php";

if (!$activateleads) {
	header("Location: affiliate.php");
	exit;
}

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_leads.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get affiliate information from database...
$sql="SELECT * FROM affiliate WHERE sessionid='$affiliatesesid'";
$result = @mysqli_query($db, "$sql");

// Store affiliate information in variables...
$afffirstname = @mysqli_result($result, 0, "firstname");
$afflastname = @mysqli_result($result, 0, "lastname");
$affiliateid = @mysqli_result($result, 0, "affiliateid");

// Download leads as a CSV...
if (!empty($download) || !empty($view)) {
$leadsinterests = @mysqli_real_escape_string($db, $leadsinterests);
if ($leadscountry == "none") $leadscountry = "";
$leadscountry = @mysqli_real_escape_string($db, $leadscountry);
if ($leadsstate == "none") $leadsstate = "";
$leadsstate = @mysqli_real_escape_string($db, $leadsstate);
foreach ($countries as $shortcountry => $longcountry) {
	if ($leadscountry == $shortcountry || $leadscountry == $longcountry) {
		$leadsshortcountry = $shortcountry;
		$leadslongcountry = $longcountry;
	}
}
foreach ($uscanstates as $shortstate => $longstate) {
	if ($leadsstate == $shortcountry || $leadsstate == $longcountry) {
		$leadsshortstate = $shortcountry;
		$leadslongstate = $longcountry;
	}
}
$leadsinterests = strtoupper($leadsinterests);
if (!empty($leadsinterests)) {
	$sql="SELECT DISTINCT customer.customerid FROM customer, orders WHERE customer.affiliateid='$affiliateid' AND customer.customerid=orders.customerid AND UPPER(orders.description) LIKE '%$leadsinterests%'";
	if (!empty($leadscountry)) {
		$sql.=" AND (customer.country='$leadscountry'";
		if (!empty($leadsshortcountry)) $sql .= " OR customer.country='$leadsshortcountry'";
		if (!empty($leadslongcountry)) $sql .= " OR customer.country='$leadslongcountry'";
		$sql.= ")";
	}
	if (!empty($leadsstate)) {
		$sql.=" AND (customer.state='$leadsstate'";
		if (!empty($leadsshortstate)) $sql .= " OR customer.state='$leadsshortstate'";
		if (!empty($leadslongstate)) $sql .= " OR customer.state='$leadslongstate'";
		$sql.= ")";
	}
	$sql.=" ORDER BY customer.lastname";
} else {
	$sql="SELECT DISTINCT customer.customerid FROM customer WHERE affiliateid='$affiliateid' ";
	if (!empty($leadscountry)) {
		$sql.=" AND (customer.country='$leadscountry'";
		if (!empty($leadsshortcountry)) $sql .= " OR customer.country='$leadsshortcountry'";
		if (!empty($leadslongcountry)) $sql .= " OR customer.country='$leadslongcountry'";
		$sql.= ")";
	}
	if (!empty($leadsstate)) {
		$sql.=" AND (customer.state='$leadsstate'";
		if (!empty($leadsshortstate)) $sql .= " OR customer.state='$leadsshortstate'";
		if (!empty($leadslongstate)) $sql .= " OR customer.state='$leadslongstate'";
		$sql.= ")";
	}
	$sql.=" ORDER BY lastname";
}
$result = @mysqli_query($db, "$sql");
$leadslist = "";
if (@mysqli_num_rows($result) != 0) {
	if (!empty($download)) {
		header ("Content-Type: application/octet-stream");
		header ("Content-Disposition: attachment; filename=leads.csv");
		echo NAME.";".EMAIL.";".PHONE.";".ORDERS."\n";
	} else $leadslist = "<table class=\"table table-striped\"><thead><tr><th>".NAME."</th><th>".EMAIL."</th><th>".PHONE."</th><th>".ORDERS."</th></tr></thead><tbody>";
	for ($i = 0; $i < @mysqli_num_rows($result);$i++) {
		$customerid = @mysqli_result($result, $i, "customerid");
		$customerresult = @mysqli_query($db, "SELECT * FROM customer WHERE customerid='$customerid'");
		$firstname = @mysqli_result($customerresult, 0, "firstname");
		$lastname = @mysqli_result($customerresult, 0, "lastname");
		if (!empty($firstname) && !empty($lastname)) $fullname = "$firstname $lastname";
		else if (!empty($firstname)) $fullname = $firstname;
		else if (!empty($lastname)) $fullname = $lastname;
		else $fullname = "Unknown";
		$email = @mysqli_result($customerresult, 0, "email");
		$phone = @mysqli_result($customerresult, 0, "phone");
		$orderresult = @mysqli_query($db, "SELECT orderid FROM orders WHERE customerid='$customerid' AND paid!='' AND paid IS NOT NULL");
		$ordercount = @mysqli_num_rows($orderresult);
		if (!empty($download)) echo "$fullname;$email;$phone;$ordercount\n";
		else $leadslist .= "<tr><td>$fullname</td><td><a href=\"mailto:$email\">$email</a></td><td>$phone</td><td>$ordercount</td></tr>";
	}
	if (!empty($download)) exit;
	else $leadslist .= "</tbody></table>";
} else $msg = "noleads";
}

// Get number of unread PMs...
$sql="SELECT * FROM affiliatepm WHERE toaffiliateid='$affiliateid' AND (hasbeenread='' OR hasbeenread='0' OR hasbeenread IS NULL)";
$unreadresult = @mysqli_query($db, "$sql");
$unreadcount = @mysqli_num_rows($unreadresult);

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");

echo "
<script language=\"JavaScript\" src=\"../includes/switchstates.js.php\" type=\"text/javascript\"></script>
<div class=\"span3 sidebar\">
<ul class=\"nav nav-sidebar\">
<li><a href=\"affiliate.php\">".STATISTICS."</a></li>
<li><a href=\"changeprofile.php\">".VIEWPROFILE."</a></li>
<li><a href=\"changepassword.php\">".CHANGEPASS."</a></li>";
if (file_exists("$ashoppath/customerparties.php") && $enablepartyplanner == "1") echo "<li><a href=\"parties.php\">".PARTIES."</a></li>";
echo "<li><a href=\"linkcodes.php\">".LINKCODES."</a></li>
<li><a href=\"orderhistory.php\">".ORDERHISTORY."</a></li>
<li><a href=\"downline.php\">".DOWNLINE."</a></li>";
if ($activateleads) echo "<li class=\"active\"><a href=\"#\">".LEADS."</a></li>";
echo "<li><a href=\"inbox.php\">".INBOX;
if ($unreadcount) echo " ($unreadcount)";
echo "</a></li>
<li><a href=\"login.php?logout\">".LOGOUT."</a></li>
</ul></div>
<div class=\"span9\"><h4>".YOURLEADS."</h4>";

	if ($msg == "noleads") echo "<p>".NOLEADSFOUND."</p>";

// Check if this affiliate has any leads...
$sql="SELECT customerid FROM customer WHERE affiliateid='$affiliateid' ORDER BY lastname";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result) != 0) {
	echo "
	<form action=\"leads.php\" method=\"post\" name=\"signupform\">
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".COUNTRY.":</label>
                  <div class=\"controls\"> 
                    <select name=\"leadscountry\" onChange=\"switchStates(document.getElementById('state'),document.signupform.leadsprovince,document.signupform.leadscountry.value);\" class=\"input-xlarge\"><option  value=\"\">".CHOOSECOUNTRY;
foreach ($countries as $shortcountry => $longcountry) {
	if (strlen($longcountry) > 30) $longcountry = substr($longcountry,0,27)."...";
	echo "<option value=\"$shortcountry\"";
	if ($leadscountry == $shortcountry) echo " selected";
	echo ">$longcountry\n";
}
echo "</select>
					</div>
              </div>
	<div class=\"control-group\" id=\"stateselector\" style=\"display:none\">
                  <label class=\"control-label\">".STATE.":</label>
                  <div class=\"controls\"> 
                    <select name=\"leadsstate\" id=\"state\" class=\"input-xlarge\"><option value=\"\">choose...</select>
                  </div>
              </div>
	<div class=\"control-group\" id=\"regionrow\" style=\"display:none\">
                  <label class=\"control-label\">".PROVINCE.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"leadsprovince\" class=\"input-xlarge\">
                  </div>
              </div>";
	if (!empty($leadscountry)) {
		echo "<script language=\"JavaScript\" type=\"text/javascript\">
		switchStates(document.signupform.leadsstate,document.signupform.leadsprovince,document.signupform.leadscountry.value);";
		if (!empty($leadsstate)) echo "document.signupform.leadsstate.value = '$leadsstate';";
		else if (!empty($leadsprovince)) echo "document.signupform.leadsprovince.value = '$leadsprovince';";
		echo "</script>";
	}
	echo "
	<div class=\"control-group\"> 
                  <label class=\"control-label\">".INTERESTS.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"leadsinterests\" value=\"$leadsinterests\" class=\"input-xlarge\">
                  </div>
              </div
	<p><button class=\"btn btn-inverse\" name=\"download\" value=\"".DOWNLOAD."\">".DOWNLOAD."</button> <button class=\"btn btn-inverse\" name=\"view\" value=\"".VIEW."\">".VIEW."</button></p>
	</form>";
} else echo "
<p>".NOLEADS."</p>";

if ($leadslist) echo $leadslist;

echo "</div>\n";

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");

// Close database...
@mysqli_close($db);
?>