<?php
// AShop
// Copyright 2016 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";
include "checklogin.inc.php";
include "../admin/ashopconstants.inc.php";

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_inbox.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get affiliate information from database...
$sql="SELECT * FROM affiliate WHERE sessionid='$affiliatesesid'";
$result = @mysqli_query($db, "$sql");

// Get the correct password for this affiliate...
$correctpasswd = @mysqli_result($result, 0, "password");

// Store affiliate information in variables...
$firstname = @mysqli_result($result, 0, "firstname");
$lastname = @mysqli_result($result, 0, "lastname");
$affiliateid = @mysqli_result($result, 0, "affiliateid");
$referredby = @mysqli_result($result, 0, "referedby");

// Validate the read parameter...
if (!empty($read) && is_numeric($read)) {
	$readresult = @mysqli_query($db, "SELECT * FROM affiliatepm WHERE affiliatepmid='$read' AND toaffiliateid='$affiliateid'");
	if (!@mysqli_num_rows($readresult)) $read = 0;
	else @mysqli_query($db, "UPDATE affiliatepm SET hasbeenread='1' WHERE affiliatepmid='$read'");
}

// Delete a PM...
if (!empty($deletepm) && is_numeric($deletepm)) @mysqli_query($db, "DELETE FROM affiliatepm WHERE affiliatepmid='$deletepm' AND toaffiliateid='$affiliateid'");

// Get number of unread PMs...
$sql="SELECT * FROM affiliatepm WHERE toaffiliateid='$affiliateid' AND (hasbeenread='' OR hasbeenread='0' OR hasbeenread IS NULL) ORDER BY sentdate DESC";
$unreadresult = @mysqli_query($db, "$sql");
$unreadcount = @mysqli_num_rows($unreadresult);

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");

echo "<div class=\"span3 sidebar\">
<ul class=\"nav nav-sidebar\">
<li><a href=\"affiliate.php\">".STATISTICS."</a></li>
<li><a href=\"changeprofile.php\">".VIEWPROFILE."</a></li>
<li><a href=\"changepassword.php\">".CHANGEPASS."</a></li>";
if (file_exists("$ashoppath/customerparties.php") && $enablepartyplanner == "1") echo "<li><a href=\"parties.php\">".PARTIES."</a></li>";
echo "<li><a href=\"linkcodes.php\">".LINKCODES."</a></li>
<li><a href=\"orderhistory.php\">".ORDERHISTORY."</a></li>
<li><a href=\"downline.php\">".DOWNLINE."</a></li>";
if ($activateleads) echo "<li><a href=\"leads.php\">".LEADS."</a></li>";
echo "<li class=\"active\"><a href=\"#\">".INBOX;
if ($unreadcount) echo " ($unreadcount)";
echo "</a></li>
<li><a href=\"login.php?logout\">".LOGOUT."</a></li>
</ul></div>
<div class=\"span9\">\n";

if (!empty($read) && $read > 0) {
	$received = @mysqli_result($readresult, 0, "sentdate");
	$received = substr($received,0,-3);
	$senderid = @mysqli_result($readresult, 0, "fromaffiliateid");
	if ($senderid == -1) $sender = SHOPADMIN;
	else {
		$senderresult = @mysqli_query($db, "SELECT firstname, lastname, referedby FROM affiliate WHERE affiliateid='$senderid'");
		$senderfirstname = @mysqli_result($senderresult,0,"firstname");
		$senderlastname = @mysqli_result($senderresult,0,"lastname");
		$senderreferredby = @mysqli_result($senderresult,0,"referedby");
		if (!empty($senderfirstname) && !empty($senderlastname)) $sender = $senderfirstname." ".$senderlastname;
		else if (!empty($senderfirstname)) $sender = $senderfirstname;
		else $sender = $senderlastname;
		if ($senderid == $referredby) $sender .= " ".SPONSOR;
		else if ($senderreferredby == $affiliateid) $sender .= " [".DOWNLINE."]";
		else $sender .= " ".UPLINE;
	}
	$subject = @mysqli_result($readresult, $i, "subject");
	$message = @mysqli_result($readresult, $i, "message");
	echo "
				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".RECEIVED.":</label>
                  <div class=\"controls\"> 
                    $received
					</div>
              </div>
				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".FROM.":</label>
                  <div class=\"controls\"> 
                    $sender
					</div>
              </div>
				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".SUBJECT.":</label>
                  <div class=\"controls\"> 
                    $subject
					</div>
              </div>
				  <p>$message</p>
				  <form action=\"inbox.php\" method=\"post\">
				  <p><button class=\"btn btn-inverse\">Delete\"></button></p>
				  <input type=\"hidden\" name=\"deletepm\" value=\"$read\">
				  </form><hr>";

} else {
	$nomessages = TRUE;

	// Get message list from database...
	if (@mysqli_num_rows($unreadresult) != 0) {
		$nomessages = FALSE;
		echo "<h4>".UNREAD."</h4>";
		for ($i = 0; $i < @mysqli_num_rows($unreadresult);$i++) {
			$received = @mysqli_result($unreadresult, $i, "sentdate");
			$received = substr($received,0,-3);
			$pmid = @mysqli_result($unreadresult, $i, "affiliatepmid");
			$senderid = @mysqli_result($unreadresult, $i, "fromaffiliateid");
			if ($senderid == -1) $sender = SHOPADMIN;
			else {
				$senderresult = @mysqli_query($db, "SELECT firstname, lastname, referedby FROM affiliate WHERE affiliateid='$senderid'");
				$senderfirstname = @mysqli_result($senderresult,0,"firstname");
				$senderlastname = @mysqli_result($senderresult,0,"lastname");
				$senderreferredby = @mysqli_result($senderresult,0,"referedby");
				if (!empty($senderfirstname) && !empty($senderlastname)) $sender = $senderfirstname." ".$senderlastname;
				else if (!empty($senderfirstname)) $sender = $senderfirstname;
				else $sender = $senderlastname;
				if ($senderid == $referredby) $sender .= " ".SPONSOR;
				else if ($senderreferredby == $affiliateid) $sender .= " [".DOWNLINE."]";
				else $sender .= " ".UPLINE;
			}
			$subject = @mysqli_result($unreadresult, $i, "subject");
			echo "				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".RECEIVED.":</label>
                  <div class=\"controls\"> 
                    $received
					</div>
				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".FROM.":</label>
                  <div class=\"controls\"> 
                    $sender
					</div>
				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".SUBJECT.":</label>
                  <div class=\"controls\"> 
                    <a href=\"inbox.php?read=$pmid\">$subject</a>
					</div>
              </div><hr>";
		}
	}
	
	// Get message list from database...
	$sql="SELECT * FROM affiliatepm WHERE toaffiliateid='$affiliateid' AND hasbeenread='1' ORDER BY sentdate DESC";
	$result = @mysqli_query($db, "$sql");
	$unreadcount = @mysqli_num_rows($result);
	if (@mysqli_num_rows($result) != 0) {
		$nomessages = FALSE;
		echo "<h4>".MESSAGES."</h4>";
		for ($i = 0; $i < @mysqli_num_rows($result);$i++) {
			$received = @mysqli_result($result, $i, "sentdate");
			$received = substr($received,0,-3);
			$pmid = @mysqli_result($result, $i, "affiliatepmid");
			$senderid = @mysqli_result($result, $i, "fromaffiliateid");
			if ($senderid == -1) $sender = SHOPADMIN;
			else {
				$senderresult = @mysqli_query($db, "SELECT firstname, lastname, referedby FROM affiliate WHERE affiliateid='$senderid'");
				$senderfirstname = @mysqli_result($senderresult,0,"firstname");
				$senderlastname = @mysqli_result($senderresult,0,"lastname");
				$senderreferredby = @mysqli_result($senderresult,0,"referedby");
				if (!empty($senderfirstname) && !empty($senderlastname)) $sender = $senderfirstname." ".$senderlastname;
				else if (!empty($senderfirstname)) $sender = $senderfirstname;
				else $sender = $senderlastname;
				if ($senderid == $referredby) $sender .= " ".SPONSOR;
				else if ($senderreferredby == $affiliateid) $sender .= " [".DOWNLINE."]";
				else $sender .= " ".UPLINE;
			}
			$subject = @mysqli_result($result, $i, "subject");
			echo "				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".RECEIVED.":</label>
                  <div class=\"controls\"> 
                    $received
					</div>
				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".FROM.":</label>
                  <div class=\"controls\"> 
                    $sender
					</div>
				  <div class=\"control-group\"> 
                  <label class=\"control-label\">".SUBJECT.":</label>
                  <div class=\"controls\"> 
                    <a href=\"inbox.php?read=$pmid\">$subject</a>
					</div>
              </div><hr>";
		}
	}

	if ($nomessages) echo "<p>".NOMESSAGES."</p>";
}
echo "</div>\n";

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");

// Close database...
@mysqli_close($db);
?>