<?php
// AShop
// Copyright 2018 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";
include "checklogin.inc.php";

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_changeprofile.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get affiliate information from database...
$sql="SELECT * FROM affiliate WHERE sessionid='$affiliatesesid'";
$result = @mysqli_query($db, "$sql");

// Get the correct password for this affiliate...
$correctpasswd = @mysqli_result($result, 0, "password");

// Set current date and time...
$date = date("Y-m-d H:i:s", time()+$timezoneoffset);

// Update profile...
if($Submit) {
	$sql = "UPDATE affiliate SET business='$business', firstname='$firstname', lastname='$lastname', email='$email', address='$address', state='$state', zip='$zip', city='$city', url='$url', phone='$phone', country='$country', paypalid='$paypalid', updated='$date' WHERE sessionid='$affiliatesesid'";
	@mysqli_query($db, "$sql");
}

// Store affiliate information in variables...
$business = @mysqli_result($result, 0, "business");
$firstname = @mysqli_result($result, 0, "firstname");
$lastname = @mysqli_result($result, 0, "lastname");
$email = @mysqli_result($result, 0, "email");
$address = @mysqli_result($result, 0, "address");
$state = @mysqli_result($result, 0, "state");
$zip = @mysqli_result($result, 0, "zip");
$city = @mysqli_result($result, 0, "city");
$url = @mysqli_result($result, 0, "url");
$phone = @mysqli_result($result, 0, "phone");
$country = @mysqli_result($result, 0, "country");
$paypalid = @mysqli_result($result, 0, "paypalid");
$affiliateid = @mysqli_result($result, 0, "affiliateid");

// Get custom fields...
$customfields = "";
$customfieldsresult = @mysqli_query($db, "SELECT * FROM affiliatetags ORDER BY fieldname ASC");
if (@mysqli_num_rows($customfieldsresult)) {
	while ($customfieldrow = @mysqli_fetch_array($customfieldsresult)) {
		$tagid = $customfieldrow["affiliatetagid"];
		$fieldname = $customfieldrow["fieldname"];
		$htmlfieldname = str_replace(" ","__",$fieldname);
		$rows = $customfieldrow["rows"];
		$affinfo = "";
		if($Submit) {
			$affinfo = $_POST["$htmlfieldname"];
			$customfieldinforesult = @mysqli_query($db, "SELECT * FROM affiliatetaginfo WHERE affiliateid='$affiliateid' AND affiliatetagid='$tagid'");
			if (@mysqli_num_rows($customfieldinforesult)) @mysqli_query($db, "UPDATE affiliatetaginfo SET value='$affinfo' WHERE affiliateid='$affiliateid' AND affiliatetagid='$tagid'");
			else @mysqli_query($db, "INSERT INTO affiliatetaginfo (affiliateid,affiliatetagid,value) VALUES ('$affiliateid','$tagid','$affinfo')");
		} else {
			$customfieldinforesult = @mysqli_query($db, "SELECT * FROM affiliatetaginfo WHERE affiliateid='$affiliateid' AND affiliatetagid='$tagid'");
			if (@mysqli_num_rows($customfieldinforesult)) $affinfo = @mysqli_result($customfieldinforesult,0,"value");
		}
		if ($rows == "1") $customfields .= "<div class=\"control-group\">\n<label class=\"control-label\">$fieldname:</label>\n<div class=\"controls\"><input type=\"text\" name=\"$htmlfieldname\" value=\"$affinfo\" class=\"input-xlarge\"></div>\n</div>\n";
		else $customfields .= "<div class=\"control-group\">\n<label class=\"control-label\">$fieldname:</label>\n<div class=\"controls\"><textarea name=\"$htmlfieldname\" cols=\"30\" rows=\"$rows\">$affinfo</textarea></div>\n</div>\n";
	}
}

if ($Submit) {
	header("Location: affiliate.php");
	exit;
}

// Get number of unread PMs...
$sql="SELECT * FROM affiliatepm WHERE toaffiliateid='$affiliateid' AND (hasbeenread='' OR hasbeenread='0' OR hasbeenread IS NULL)";
$unreadresult = @mysqli_query($db, "$sql");
$unreadcount = @mysqli_num_rows($unreadresult);

// Close database...
@mysqli_close($db);

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");

echo "<div class=\"span3 sidebar\">
<ul class=\"nav nav-sidebar\">
<li><a href=\"affiliate.php\">".STATISTICS."</a></li>
<li class=\"active\"><a href=\"#\">".VIEWPROFILE."</a></li>
<li><a href=\"changepassword.php\">".CHANGEPASS."</a></li>";
if (file_exists("$ashoppath/customerparties.php") && $enablepartyplanner == "1") echo "<li><a href=\"parties.php\">".PARTIES."</a></li>";
echo "<li><a href=\"linkcodes.php\">".LINKCODES."</a></li>
<li><a href=\"orderhistory.php\">".ORDERHISTORY."</a></li>
<li><a href=\"downline.php\">".DOWNLINE."</a></li>";
if ($activateleads) echo "<li><a href=\"leads.php\">".LEADS."</a></li>";
echo "<li><a href=\"inbox.php\">".INBOX;
if ($unreadcount) echo " ($unreadcount)";
echo "</a></li>
<li><a href=\"login.php?logout\">".LOGOUT."</a></li>
</ul></div>

<div class=\"span9\">
<h4>".CHANGEBELOW."</h4>
            <form action=\"changeprofile.php\" method=\"post\" name=\"orderform\">
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".BUSINESS.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"business\" value=\"$business\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".FIRSTNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"firstname\" value=\"$firstname\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".LASTNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"lastname\" value=\"$lastname\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".EMAIL.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"email\" value=\"$email\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".ADDRESS.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"address\" value=\"$address\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".CITY.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"city\" value=\"$city\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".STATE.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"state\" value=\"$state\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".ZIP.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"zip\" value=\"$zip\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".COUNTRY.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"country\" value=\"$country\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".PHONE.":</label>
                  <div class=\"controls\"> 
                    <input type=text name=\"phone\" value=\"$phone\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".URL.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"url\" value=\"$url\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".PAYPAL.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"paypalid\" value=\"$paypalid\" class=\"input-xlarge\"><br>".OPTIONAL."
                  </div>
              </div>";
if ($customfields) echo $customfields;
echo "<p><button class=\"btn btn-inverse\" name=\"Submit\" value=\"".UPDATE."\">".UPDATE."</button></p>\n</form>
</div>";

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
?>