<?php
// AShop
// Copyright 2017 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/editproduct.inc.php";
include "keycodes.inc.php";

// Validate variables...
if (!is_numeric($resultpage)) unset($resultpage);
if (!is_numeric($kadmindisplayitems)) unset($kadmindisplayitems);
else {
	$c_kadmindisplayitems = $kadmindisplayitems;
	if (!$p3psent) header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"');
	$p3psent = TRUE;
	setcookie("c_kadmindisplayitems","$kadmindisplayitems");
}
if (!is_numeric($c_kadmindisplayitems)) unset($c_kadmindisplayitems);

// Get information about the product from the database...
if ($clear) $productid = $clear;
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");
$sql="SELECT * FROM product WHERE productid = $productid";
$result = @mysqli_query($db, $sql);
$productname = @mysqli_result($result, 0, "name");

// Handle removal of all key codes...
if ($clear) {
	if ($yes) {
       $sql="DELETE FROM unlockkeys WHERE productid='$clear'";
       $result = @mysqli_query($db, $sql);
	   header("Location: editcatalogue.php?cat=$cat&resultpage=$resultpage&msg=keycodescleared");
	   exit;
    }
	else if ($no) header("Location: listkeycodes.php?cat=$cat&productid=$clear&resultpage=$resultpage");
	else echo "$header
    <section class=\"content-header\"><h1>".REMOVEALLKEYCODES.": $productname</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"listkeycodes.php\" method=\"post\">
                <div class=\"box-body\">
                    <div class=\"alert alert-danger\">
                        <h4><i class=\"icon fa fa-ban\"></i> ".AREYOUSURECLEARALL."</h4>
                    </div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"no\" value=\"".NO."\">".NO."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"yes\" value=\"".YES."\">".YES."</button>
				</div>
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
                <input type=\"hidden\" name=\"clear\" value=\"$clear\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"keyid\" value=\"$keyid\">
                <input type=\"hidden\" name=\"remove\" value=\"true\">
             </form></div></div></div></section>$footer";
	exit;
}

// Handle removal of a single key code...
if ($remove && $keyid) {
	if ($yes) {
       $sql="DELETE FROM unlockkeys WHERE keyid=$keyid";
       $result = @mysqli_query($db, $sql);
	   header("Location: listkeycodes.php?cat=$cat&productid=$productid&msg=deleted&resultpage=$resultpage");
	   exit;
    }
	else if ($no) header("Location: listkeycodes.php?cat=$cat&productid=$productid&resultpage=$resultpage");
	else echo "$header
    <section class=\"content-header\"><h1>".REMOVEAKEYCODE.": $productname</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"listkeycodes.php\" method=\"post\">
                <div class=\"box-body\">
                    <div class=\"alert alert-danger\">
                        <h4><i class=\"icon fa fa-ban\"></i> ".AREYOUSUREDELETEKEYCODE."</h4>
                    </div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"no\" value=\"".NO."\">".NO."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"yes\" value=\"".YES."\">".YES."</button>
				</div>
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
                <input type=\"hidden\" name=\"productid\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"keyid\" value=\"$keyid\">
                <input type=\"hidden\" name=\"remove\" value=\"true\">
             </form></div></div></div></section>$footer";
	exit;
} 

// Show list of key codes...
if ($productid) {
	echo "$header
    <section class=\"content-header\"><h1>".UNLOCKKEYCODESFOR."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
        <div class=\"col-md-12\">
          <div class=\"box\">
            <div class=\"box-header with-border\">
                <h3 class=\"box-title\"><a href=\"editcatalogue.php?pid=$productid&cat=$cat\">$productname</a></h3>
            </div>
            <div class=\"box-body\">";
	if ($msg == "deleted") echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".KEYCODESDELETED."
              </div>";
	echo "
              <table class=\"table table-bordered\">
                <thead><tr>
                    <th>".KEYCODE."</th><th>".ASSIGNEDTO."</th><th>&nbsp;</th></tr>
                </thead>
                <tbody>";

	  $sql="SELECT * FROM unlockkeys WHERE productid='$productid' ORDER BY keyid";
	  $result = @mysqli_query($db, $sql);

	  $numberofrows = intval(@mysqli_num_rows($result));
	  if (!$kadmindisplayitems) {
		  if ($c_kadmindisplayitems) $kadmindisplayitems = $c_kadmindisplayitems;
		  else $kadmindisplayitems = 10;
	  }
	  $numberofpages = ceil($numberofrows/$kadmindisplayitems);
	  if ($resultpage > 1) $startrow = (intval($resultpage)-1) * $kadmindisplayitems;
	  else {
		  $resultpage = 1;
		  $startrow = 0;
	  }
	  $startpage = $resultpage - 9;
	  if ($numberofpages - $resultpage < 10) {
		  $pagesleft = $numberofpages - $resultpage;
		  $startpage = $startpage - (10 - $pagesleft);
	  }
	  if ($startpage < 1) $startpage = 1;
	  $stoprow = $startrow + $kadmindisplayitems;
	  @mysqli_data_seek($result, $startrow);
	  $thisrow = $startrow;
	  while (($row = @mysqli_fetch_array($result)) && ($thisrow < $stoprow)) {
		  $thiskeyid = $row["keyid"];
		  $thiskeytext = trim($row["keytext"]);
		  if (!empty($keycodeencryptionkey)) {
			  $thiskeytext = ashop_decrypt($thiskeytext, $keycodeencryptionkey);
			  $thiskeytext = trim($thiskeytext);
			  $thiskeytextlength = strlen($thiskeytext);
			  $showchars = floor($thiskeytextlength/8);
			  $hidechars = $thiskeytextlength-$showchars-$showchars;
			  $hidedots = "";
			  for ($dots = 0; $dots < $hidechars; $dots++) $hidedots .= "-";
			  $thiskeytext = substr($thiskeytext,0,$showchars).$hidedots.substr($thiskeytext,-$showchars);
		  }
		  $thisorderid = $row["orderid"];
		  $thisrow++;
		  if (substr($thisorderid, 0, 2) == "ws") {
			  $wholesaleorder = TRUE;
			  $thisorderid = substr($thisorderid, 2);
		  } else $wholesaleorder = FALSE;
		  echo "<tr><td>$thiskeytext</td>";
		  if ($thisorderid) {
			  if (!$wholesaleorder) $sql2="SELECT customer.* FROM customer, orders WHERE orders.orderid=$thisorderid AND orders.customerid = customer.customerid";
			  else $sql2="SELECT customer.* FROM customer, orders WHERE orders.orderid=$thisorderid AND orders.customerid = customer.customerid";
			  $result2 = @mysqli_query($db, $sql2);
			  $firstname = @mysqli_result($result2, 0, "firstname");
			  $lastname = @mysqli_result($result2, 0, "lastname");
			  $email = @mysqli_result($result2, 0, "email");
			  if (!$wholesaleorder) $customerid = @mysqli_result($result2, 0, "customerid");
			  else $customerid = @mysqli_result($result2, 0, "userid");
			  echo "<td><a href=\"editcustomer.php?customerid=$customerid\">$firstname $lastname</a> (".ORDERID.": <a href=\"getreceipt.php?orderid=$thisorderid\">$thisorderid</a>)</td><td align=\"center\"><a href=\"editcustomer.php?customerid=$customerid\"><img src=\"images/icon_profile.gif\" alt=\"".PROFILEFOR." $customerid\" title=\"".PROFILEFOR." $customerid\" border=\"0\"></a>&nbsp;";
			  if (!$wholesaleorder) echo "<a href=\"salesreport.php?customerid=$customerid&generate=true\">";
			  else echo "<a href=\"salesreport.php?customerid=$customerid&generate=true&reporttype=wholesale\">";
			  echo "<img src=\"images/icon_history.gif\" alt=\"".SALESHISTORYFOR." $customerid\" title=\"".SALESHISTORYFOR." $customerid\" border=\"0\"></a>&nbsp;<a href=\"listkeycodes.php?remove=true&keyid=$thiskeyid&productid=$productid&cat=$cat&resultpage=$resultpage\"><img src=\"images/icon_trash.gif\" border=\"0\"></a></td>";
		  } else echo "<td>".UNASSIGNED."</td><td align=\"center\"><img src=\"images/invisible.gif\" width=\"15\">&nbsp;<img src=\"images/invisible.gif\" width=\"15\">&nbsp;<a href=\"listkeycodes.php?remove=true&keyid=$thiskeyid&productid=$productid&cat=$cat&resultpage=$resultpage\"><img src=\"images/icon_trash.gif\" border=\"0\"></a></td>";
		  echo "</tr>";
	  }
  
	  echo "</tbody></table>";
	  if ($numberofrows > 5) {
		  echo "
        <div class=\"row\">
        <div class=\"col-md-4\"></div>
        <div class=\"col-md-4 text-center\">
        <nav aria-label=\"".PAGE."\">
            <ul class=\"pagination text-center\">";
		  if ($numberofpages > 1) {
			  if ($resultpage > 1) {
				  if ($resultpage > 10) echo "<li class=\"page-item\"><a class=\"page-link\" href=\"listkeycodes.php?resultpage=1&kadmindisplayitems=$kadmindisplayitems&productid=$productid&cat=$cat\">".FIRSTPAGE."</a></li>";
				  $previouspage = $resultpage-1;
				  echo "<li class=\"page-item\"><a class=\"page-link\" href=\"listkeycodes.php?resultpage=$previouspage&kadmindisplayitems=$kadmindisplayitems&productid=$productid&cat=$cat\">".PREVIOUS."</a></li>";
			  }
			  $page = 1;
			  for ($i = $startpage; $i <= $numberofpages; $i++) {
				  if ($page > 20) break;
				  if ($i != $resultpage) echo "<li class=\"page-item\"><a class=\"page-link\" href=\"listkeycodes.php?resultpage=$i&kadmindisplayitems=$kadmindisplayitems&productid=$productid&cat=$cat\">";
				  else echo "<li class=\"page-item active\"><span class=\"page-link\">";
				  echo "$i";
				  if ($i != $resultpage) echo "</a>";
				  else echo "</span>";
				  echo "</li>";
				  $page++;
			  }
			  if ($resultpage < $numberofpages) {
				  $nextpage = $resultpage+1;
				  echo "<li class=\"page-item\"><a class=\"page-link\" href=\"listkeycodes.php?resultpage=$nextpage&kadmindisplayitems=$kadmindisplayitems&productid=$productid&cat=$cat\">".NEXTPAGE."</a></li>";
			  }
			  if ($resultpage < ($numberofpages - 10)) echo "<li class=\"page-item\"><a class=\"page-link\" href=\"listkeycodes.php?resultpage=$numberofpages&kadmindisplayitems=$kadmindisplayitems&productid=$productid&cat=$cat\">".LASTPAGE."</a></li>";
		  }
		  echo "</ul>
    </nav></div>
    </div>
        <div class=\"row\">
        <div class=\"col-md-4\"></div>
        <div class=\"col-md-4\">
    <div class=\"form-group\"><label for=\"kadmindisplayitems\" class=\"col-sm-2 control-label\">".DISPLAY.":</label><div class=\"col-sm-10\"><select name=\"kadmindisplayitems\" id=\"kadmindisplayitems\" class=\"form-control\" onChange=\"document.location.href='listkeycodes.php?resultpage=$resultpage&productid=$productid&cat=$cat&kadmindisplayitems='+getElementById('kadmindisplayitems').value;\"><option value=\"$numberofrows\">".SELECT."</option>
		<option value=\"5\"";
		if ($c_kadmindisplayitems == "5") echo " selected";
		echo ">5</option><option value=\"10\"";
		if ($c_kadmindisplayitems == "10") echo " selected";
		echo ">10</option><option value=\"20\"";
		if ($c_kadmindisplayitems == "20") echo " selected";
		echo ">20</option><option value=\"40\"";
		if ($c_kadmindisplayitems == "40") echo " selected";
		echo ">40</option><option value=\"$numberofrows\"";
		if ($c_kadmindisplayitems == "$numberofrows") echo " selected";
		echo ">".ALL."</option></select><p class=\"help-block\">".CODES."</p></div></div></div></div>";
	  }
	  
	  echo "</div></div>
		<div class=\"box box-primary\">
            <form method=\"post\" action=\"listkeycodes.php\">
				<div class=\"box-footer text-center\">
					<button type=\"submit\" class=\"btn btn-primary\" value=\"".CLEARALLCODES."\">".CLEARALLCODES."</button>
				</div>
                <input type=\"hidden\" name=\"clear\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
            </form>
        </div>
      </div></div></section>
      $footer";
  }
   else header ("Location: editcatalogue.php?cat=$cat&resultpage=$resultpage");
?>