<?php
// AShop
// Copyright 2017 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";
include "ashopconstants.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/editproduct.inc.php";
// Get context help for this page...
$contexthelppage = "editproduct";
include "help.inc.php";

// Get information about the product from the database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");
$sql="SELECT * FROM product WHERE productid = $productid";
$result = @mysqli_query($db, $sql);
$productname = @mysqli_result($result, 0, "name");
$productcopyof = @mysqli_result($result, 0, "copyof");
$productname = str_replace("\"", "&quot;", $productname);

if (!$edited) {
	$subscriptiondir = @mysqli_result($result, 0, "subscriptiondir");
	$protectedurl = @mysqli_result($result, 0, "protectedurl");
	$length = @mysqli_result($result, 0, "length");
} else {
	// Check if the submitted directory is writeable and add protection...
	$subscriptiondir = str_replace(".","",$subscriptiondir);
	if (!empty($subscriptiondir)) {
		if (!empty($probotpath) && file_exists("$probotpath/data/groups/$subscriptiondir/pass.txt")) $editerror = "";
		else if (!is_writeable("$ashoppath/$subscriptiondir")) {
			$editerror = "notwriteable";
			$edited = "";
		} else {
			if (!file_exists("$ashoppath/$subscriptiondir/.htaccess") && !file_exists("$ashoppath/$subscriptiondir/.htpasswd")) {
				$editerror = "";
				$fp = @fopen ("$ashoppath/$subscriptiondir/.htaccess", "w");
				if ($fp) {
					fwrite($fp, "AuthUserFile $ashoppath/$subscriptiondir/.htpasswd\n");
					fwrite($fp, "AuthName \"Member's Area\"\n");
					fwrite($fp, "AuthType Basic\n");
					fwrite($fp, "\n");
					fwrite($fp, "require valid-user\n");
					fwrite($fp, "ErrorDocument 401 \"Authorisation Required\"");
					fclose ($fp);
					$fp = @fopen ("$ashoppath/$subscriptiondir/.htpasswd", "w");
					fclose ($fp);
					@chmod("$ashoppath/$subscriptiondir/.htpasswd", 0777);
				} else $editerror = "nohtaccess";
			}
			if (!file_exists("$ashoppath/$subscriptiondir/track.php")) {
				$fp = @fopen ("$ashoppath/$subscriptiondir/track.php", "w");
				if ($fp) {
					fwrite($fp, "<?php\n");
					fwrite($fp, "\$ashoppath = \"$ashoppath\";\n");
					fwrite($fp, "include \"\$ashoppath/admin/tracksubscr.php\";\n");
					fwrite($fp, "?>");
					fclose ($fp);
					@chmod("$ashoppath/$subscriptiondir/track.php", 0755);
				}
			}
		}
	}
}

// Handle editing of the product...
if ($edit && $productid) {

  // Make sure special characters are handled properly...
  $name = str_replace("\"", "&quot;", $name);

  // Show edit form...
  if (!$edited) {

	  echo "$header
    <section class=\"content-header\"><h1>".EDITMEMBERSHIP."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
	        <form action=\"editsubscr.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"productform\">
			    <div class=\"box-header with-border\">
				    <h3 class=\"box-title\"><a href=\"editcatalogue.php?pid=$productid&cat=$cat\">$productname</a></h3>
                </div>";
	  if ($editerror) {
		  echo "
              <div class=\"alert alert-danger alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ERROR." ";
		  if ($editerror=="notwriteable") echo PROTECTEDDIRNOTWRITEABLE;
		  else if ($editerror=="nohtaccess") echo COULDNOTCREATEHTFILES;
          echo "</div>";
	  }
	  echo "
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => PROTECTEDDIRECTORY, "name" => "subscriptiondir", "value" => $subscriptiondir, "helpnumber" => "11a", "helptext" => $tip11a, "helplink" => $help11a))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PROTECTEDURL, "name" => "protectedurl", "value" => $protectedurl, "helpnumber" => "11b", "helptext" => $tip11b, "helplink" => $help11b))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SUBSCRIPTIONLENGTH, "name" => "length", "value" => $length, "helpnumber" => "12a", "helptext" => $tip12a, "helplink" => $help12a, "suffix" => DAYS, "explanation" => ZEROUNLIMITED))."</div>
                </div>
				<div class=\"box-footer\">
					<button type=\"button\" class=\"btn btn-default\" onClick=\"document.location.href='editcatalogue.php?cat=$cat&pid=$pid&resultpage=$resultpage&search=$search'\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" value=\"".SUBMIT."\">".SUBMIT."</button>
				</div>
                <input type=\"hidden\" name=\"edit\" value=\"True\">
                <input type=\"hidden\" name=\"edited\" value=\"True\">
                <input type=\"hidden\" name=\"productid\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
                <input type=\"hidden\" name=\"copyof\" value=\"$productcopyof\">
            </form>
		</div>
		</div>
		</div>
        </section>
      $footer";
  }
  else {
	if (!$subscriptiondir) $sql = "UPDATE product SET prodtype='', subscriptiondir='', protectedurl='', length='$length'";
	else {
		$sql = "UPDATE product SET prodtype='subscription', ";
		if ($length) $sql .= "length='$length', ";
		else $sql .= "length='', ";
		if ($protectedurl) $sql .= "protectedurl='$protectedurl', ";
		else $sql .= "protectedurl='', ";
		$sql .= "subscriptiondir='$subscriptiondir'";
	}
	if ($copyof) $sql.=" WHERE productid='$productid' OR copyof='$productid' OR productid='$copyof' OR copyof='$copyof'";
	else $sql.=" WHERE productid='$productid' OR copyof='$productid'";
    $result = @mysqli_query($db, $sql);

    if ($error) header ("Location: editcatalogue.php?cat=$cat&error=$error");
    else header("Location: editcatalogue.php?cat=$cat");
  }
}
?>