<?php
// AShop
// Copyright 2018 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "checklicense.inc.php";
include "checklogin.inc.php";

if ($cancel) {
	header("Location: settings.php?cancel=true");
	exit;
}

if ($userid != "1") {
	header("Location: editmember.php");
	exit;
}
include "template.inc.php";
include "ashopconstants.inc.php";
// Get language module...
include "language/$adminlang/configure.inc.php";

// Initiate password hasher for changing the admin panel password...
include "$ashoppath/includes/PasswordHash.php";
$passhasher = new PasswordHash(8, FALSE);

// Handle uploaded logo file...
$imgfile = str_replace("\t","\\t",$imgfile);
if (is_uploaded_file($imgfile)) {
	$fileinfo = pathinfo("$imgfile_name");
	$extension = strtolower($fileinfo["extension"]);
	if ($extension == "png" && is_writeable("$ashoppath/images")) {
		move_uploaded_file($imgfile, "$ashoppath/images/logo.png");
		@chmod("$ashoppath/images/logo.png", 0777);
	}
}

// Handle uploaded banner file 1...
$bannerone = str_replace("\t","\\t",$bannerone);
if (is_uploaded_file($bannerone)) {
	$fileinfo = pathinfo("$bannerone_name");
	$extension = strtolower($fileinfo["extension"]);
	if ($extension == "jpg" && is_writeable("$ashoppath/images/slides")) {
		move_uploaded_file($bannerone, "$ashoppath/images/slides/banner-1.jpg");
		@chmod("$ashoppath/images/slides/banner-1.jpg", 0777);
	}
}

// Handle uploaded banner file 2...
$bannertwo = str_replace("\t","\\t",$bannertwo);
if (is_uploaded_file($bannertwo)) {
	$fileinfo = pathinfo("$bannertwo_name");
	$extension = strtolower($fileinfo["extension"]);
	if ($extension == "jpg" && is_writeable("$ashoppath/images/slides")) {
		move_uploaded_file($bannertwo, "$ashoppath/images/slides/banner-2.jpg");
		@chmod("$ashoppath/images/slides/banner-2.jpg", 0777);
	}
}

// Handle uploaded banner file 1...
$bannerthree = str_replace("\t","\\t",$bannerthree);
if (is_uploaded_file($bannerthree)) {
	$fileinfo = pathinfo("$bannerthree_name");
	$extension = strtolower($fileinfo["extension"]);
	if ($extension == "jpg" && is_writeable("$ashoppath/images/slides")) {
		move_uploaded_file($bannerthree, "$ashoppath/images/slides/banner-3.jpg");
		@chmod("$ashoppath/images/slides/banner-3.jpg", 0777);
	}
}

// Open database connection...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Handle multiple origin countries...
if (substr($shipfromcountry,0,1) == "-") $shipfromcountry = substr_replace($shipfromcountry, "", 0,1);
$shipfromcountries = explode("-", $shipfromcountry);
$countrynumber = 1;
if ($shipfromcountries) foreach ($shipfromcountries as $thisshipfromcountry) {
	eval ("\$updatethiscountry = \$nshipfromcountry$countrynumber;");
	if ($countrynumber == 1) {
		if ($updatethiscountry && $updatethiscountry != "none") $nshipfromcountry = $updatethiscountry;
		else if ($updatethiscountry != "none") $nshipfromcountry = $thisshipfromcountry;
	} else {
		if ($updatethiscountry && $updatethiscountry != "none") $nshipfromcountry .= "-$updatethiscountry";
		else if ($updatethiscountry != "none") $nshipfromcountry .= "-$thisshipfromcountry";
	}
	$countrynumber++;
}
eval ("\$addedcountry = \$nshipfromcountry$countrynumber;");
if ($addedcountry) $nshipfromcountry .= "-$addedcountry";
if (substr($nshipfromcountry,0,1) == "-") $nshipfromcountry = substr_replace($nshipfromcountry, "", 0,1);

// Keep changes when adding new origin country...
if ($addcountry) {
	$shippingtax = $nshippingtax;
	$requestvat = $nrequestvat;
	$requestabn = $nrequestabn;
	$taxstate = $ntaxstate;
	$taxpercentage = $ntaxpercentage;
	$shipfromcountries = explode ("-", $nshipfromcountry);
	$handlinglocal = $nhandlinglocal;
	$handlingint = $nhandlingint;
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshipfromcountry' WHERE prefname='shipfromcountry'");
}

// Handle weight shipping levels...
$weightshippinglevelstring = "";
$nweightshipping = "";
if (!empty($weightshippinglevel0)) {
	foreach ($_POST as $key=>$value) {
		if (strstr($key,"weightshippinglevel")) {
			$thislevel = str_replace("weightshippinglevel","",$key);
			$thisweightshippinglevel = $value;
			$weightshippingcostvariablename = "weightshippingcost$thislevel";
			$thisweightshippingcost = $$weightshippingcostvariablename;
			if (is_numeric($thisweightshippingcost) && is_numeric($thisweightshippinglevel)) {
				$thisweightshippinglevel = number_format($thisweightshippinglevel,2,'.','');
				$thisweightshippingcost = number_format($thisweightshippingcost,2,'.','');
				if (!empty($nweightshipping)) $nweightshipping .= "|";
				$nweightshipping .= "$thisweightshippinglevel:$thisweightshippingcost";
			}
		}
	}
} else {
	$weightshippinglevels = explode("|",$weightshipping);
	$previousweightshippinglevel = "0.00";
	foreach ($weightshippinglevels as $weightshippingnumber=>$thisweightshipping) {
		if (!empty($thisweightshipping) && strstr($thisweightshipping,":")) {
			$thisweightshippingarray = explode(":",$thisweightshipping);
			$thisweightshippinglevel = $thisweightshippingarray[0];
			$thisweightshippingcost = $thisweightshippingarray[1];
			$weightshippinglevelstring .= "
            <div class=\"form-group\">".admin_inputfield(array("label" => WEIGHTFROM." $previousweightshippinglevel ".POUNDSUPTO, "name" => "weightshippinglevel{$weightshippingnumber}", "value" => $thisweightshippinglevel, "suffix" => POUND, "small" => TRUE)).admin_inputfield(array("name" => "weightshippingcost{$weightshippingnumber}", "value" => $thisweightshippingcost, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE))."</div>";
			$previousweightshippinglevel = $thisweightshippinglevel;
		}
	}
	if (!empty($weightshipping)) $weightshippingnumber++;
	$weightshippinglevelstring .= "
            <div class=\"form-group\">".admin_inputfield(array("label" => WEIGHTFROM." $previousweightshippinglevel ".POUNDSUPTO, "name" => "weightshippinglevel{$weightshippingnumber}", "value" => $thisweightshippinglevel, "suffix" => POUND, "small" => TRUE)).admin_inputfield(array("name" => "weightshippingcost{$weightshippingnumber}", "value" => $thisweightshippingcost, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE))."</div>";
}

// Handle price shipping levels...
$priceshippinglevelstring = "";
$npriceshipping = "";
if (!empty($priceshippinglevel0)) {
	foreach ($_POST as $key=>$value) {
		if (strstr($key,"priceshippinglevel")) {
			$thislevel = str_replace("priceshippinglevel","",$key);
			$thispriceshippinglevel = $value;
			$priceshippingcostvariablename = "priceshippingcost$thislevel";
			$thispriceshippingcost = $$priceshippingcostvariablename;
			if (is_numeric($thispriceshippingcost) && is_numeric($thispriceshippinglevel)) {
				$thispriceshippinglevel = number_format($thispriceshippinglevel,2,'.','');
				$thispriceshippingcost = number_format($thispriceshippingcost,2,'.','');
				if (!empty($npriceshipping)) $npriceshipping .= "|";
				$npriceshipping .= "$thispriceshippinglevel:$thispriceshippingcost";
			}
		}
	}
} else {
	$priceshippinglevels = explode("|",$priceshipping);
	$previouspriceshippinglevel = "0.00";
	foreach ($priceshippinglevels as $priceshippingnumber=>$thispriceshipping) {
		if (!empty($thispriceshipping) && strstr($thispriceshipping,":")) {
			$thispriceshippingarray = explode(":",$thispriceshipping);
			$thispriceshippinglevel = $thispriceshippingarray[0];
			$thispriceshippingcost = $thispriceshippingarray[1];
			$priceshippinglevelstring .= "
            <div class=\"form-group\">".admin_inputfield(array("label" => PRICEFROM." ".$currencysymbols[$ashopcurrency]["pre"]."$previouspriceshippinglevel".$currencysymbols[$ashopcurrency]["post"]." ".UPTO, "name" => "priceshippinglevel{$priceshippingnumber}", "value" => $thispriceshippinglevel, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE)).admin_inputfield(array("name" => "priceshippingcost{$priceshippingnumber}", "value" => $thispriceshippingcost, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE))."</div>";
			$previouspriceshippinglevel = $thispriceshippinglevel;
		}
	}
	if (!empty($priceshipping)) $priceshippingnumber++;
	$priceshippinglevelstring .= "
            <div class=\"form-group\">".admin_inputfield(array("label" => PRICEFROM." ".$currencysymbols[$ashopcurrency]["pre"]."$previouspriceshippinglevel".$currencysymbols[$ashopcurrency]["post"]." ".UPTO, "name" => "priceshippinglevel{$priceshippingnumber}", "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE)).admin_inputfield(array("name" => "priceshippingcost{$priceshippingnumber}", "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE))."</div>";
}

// Handle Canada sales tax table...
if ($salestaxtype == "cancstpst") {
	$cantaxtable = "
	<table class=\"table table-bordered\"><tr><th></th><th>".GSTHST."</th><th>".PST."</th><th>".PSTCOMP."</th></tr>
	";
	if (!empty($hstpercentage) && strstr($hstpercentage,"|")) {
		$cantaxarray = explode("|",$hstpercentage);
		if (is_array($cantaxarray)) foreach ($cantaxarray as $cantaxarraypart) {
			$thisprovincearray = explode(":",$cantaxarraypart);
			$thisprovince = $thisprovincearray[0];
			foreach ($canprovinces as $longprovince => $shortprovince) if ($thisprovince == $shortprovince) $thisprovincename = $longprovince;
			$thisprovincepstcomp = $thisprovincearray[3];
			$cantaxtable .= "<tr><td>$thisprovincename</td><td>".admin_inputfield(array("name" => "gst{$thisprovince}", "value" => $thisprovincearray[1], "suffix" => "%"))."</td>
            <td>".admin_inputfield(array("name" => "pst{$thisprovince}", "value" => $thisprovincearray[2], "suffix" => "%"))."</td>
            <td>".admin_checkbox(array("name" => "pstcom{$thisprovince}", "checked" => $thisprovincepstcomp == "1"?TRUE:FALSE))."</td></tr>
			";
		}
	}
    $cantaxtable .= "</table>";
}

// Convert mass maill throttle to seconds...
$massmailthrottle = $massmailthrottle/1000000;

// Change administrators password...
$passworderrorstring = "";
if ($changeconfig && $oldpassword && $newpassword1 && $newpassword2) {
	$sql = "SELECT password FROM user WHERE username = 'ashopadmin'";
	$result = @mysqli_query($db, $sql);
	$correctoldpassword = @mysqli_result($result,0,"password");
	$passcheck = $passhasher->CheckPassword($oldpassword, $correctoldpassword);
	if (!$passcheck) $passworderrorstring = "?passworderror=old";
	if ($newpassword1 != $newpassword2) $passworderrorstring = "?passworderror=new";
	if (!$passworderrorstring) {
		$passhash = $passhasher->HashPassword($newpassword1);
		$sql = "UPDATE user SET password='$passhash' WHERE username='ashopadmin'";
		$result = @mysqli_query($db, $sql);
		$headers = "From: ".un_html($ashopname)."<$ashopemail>\nX-Sender: <$ashopemail>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$ashopemail>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";
		@ashop_mail("$ashopemail",un_html($ashopname)." - ".ADMINPASSWORDCHANGED,THEADMINPASSWORDAT." $ashopurl ".HASBEENCHANGED.": {$_SERVER["REMOTE_ADDR"]}!","$headers");
	}
}

if (strpos($header, "body") != 0) {
	$newheader = substr($header,1,strpos($header, "body")+3);
	$newheader .= " onUnload=\"closemessage()\" ".substr($header,strpos($header, "body")+4,strlen($header));
} else {
	$newheader = substr($header,1,strpos($header, "BODY")+3);
	$newheader .= " onUnload=\"closemessage()\" ".substr($header,strpos($header, "BODY")+4,strlen($header));
}

if (!$changeconfig || $addcountry) {
        if ($param == "layout") echo "$newheader<script language=\"JavaScript\">
		function uploadmessage() 
		{
		  if (document.configurationform.imgfile.value != '' || document.configurationform.mobimgfile.value != '') w = window.open('uploadmessage.html','_blank','toolbar=no,location=no,width=350,height=150');
	    }
        function closemessage()
        {
       	  if (typeof w != 'undefined') w.close();
        }
        </script>";
		else echo "$header";
		echo "
<section class=\"content-header\"><h1>";
		switch ($param) {
			case "shop":
				echo SHOPPARAMETERS;
			    break;
			case "layout":
				echo LAYOUT;
				break;
			case "affiliate":
				echo AFFILIATEPROGRAM;
			    break;
			case "shipping":
				echo SHIPPING;
			    break;
			case "mall":
				echo SHOPPINGMALL;
			    break;
			case "taxes":
				echo TAXES;
			    break;
		}
		echo "</h1></section><section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">";
}

if ($param == "shop") {
	if (!$changeconfig) {
		// Get list of languages...
		$langlist = "";
		$findfile = opendir("$ashoppath/language");
		while ($foundfile = readdir($findfile)) {
			if(is_dir("$ashoppath/language/$foundfile") && strlen($foundfile) == 2 && $foundfile != ".." && file_exists("$ashoppath/language/$foundfile/lang.cfg.php")) {
				$fp = fopen ("$ashoppath/language/$foundfile/lang.cfg.php","r");
				while (!feof ($fp)) {
					$fileline = fgets($fp, 4096);
					if (strstr($fileline,"\$langname")) $langnamestring = $fileline;
					if (strstr($fileline,"\$langredirect")) $langredirectstring = $fileline;
				}
				fclose($fp);
				eval ($langnamestring);
				if ($language == $foundfile) eval ($langredirectstring);
				$langlist .= "<option value=\"$foundfile\"";
				if ($defaultlanguage == $foundfile) $langlist .= " selected";
				$langlist .= ">$langname</option>";
			}
		}

		// Get context help for this page...
		$contexthelppage = "shopparameters";
		include "help.inc.php";
		echo "
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".CHANGEPASSWORD." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image1','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image1\" align=\"absmiddle\" onclick=\"return overlib('$tip1');\" onmouseout=\"return nd();\"></a></h3><p>[".LEAVEBLANKTOKEEP."]</p>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"1\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => OLDPASSWORD, "name" => "oldpassword", "password" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => NEWPASSWORD, "name" => "newpassword1", "password" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => CONFIRM, "name" => "newpassword2", "password" => TRUE))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>

		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".CONTACTINFO." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image2','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image2\" align=\"absmiddle\" onclick=\"return overlib('$tip2');\" onmouseout=\"return nd();\"></a></h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"2\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => SHOPNAME, "name" => "nashopname", "value" => $ashopname))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SHOPADDRESS, "name" => "nashopaddress", "value" => $ashopaddress))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SHOPPHONE, "name" => "nashopphone", "value" => $ashopphone))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => EMAIL, "name" => "nashopemail", "value" => $ashopemail))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => GMAPEMBED, "name" => "nmapembed", "value" => htmlentities($mapembed)))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".CATALOGOPTIONS."</h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"3\">
				<div class=\"box-body\">
					<div class=\"form-group\"><label for=\"ndefaultlanguage\">".DEFAULTLANG."</label>
						<select name=\"ndefaultlanguage\" id=\"ndefaultlanguage\" class=\"form-control\">$langlist</select>
					</div>
					<div class=\"form-group\"><label for=\"ndefaultlanguage\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3\" align=\"absmiddle\" onclick=\"return overlib('$tip3a');\" onmouseout=\"return nd();\"></a> ".CURRENCY."</label>
						<select name=\"nashopcurrency\" id=\"nashopcurrency\" class=\"form-control\">
							<option value=\"usd\""; if ($ashopcurrency == "usd") echo " selected"; echo ">".USDOLLARS."</option>
							<option value=\"cad\""; if ($ashopcurrency == "cad") echo " selected"; echo ">".CANDOLLARS."</option>
							<option value=\"aud\""; if ($ashopcurrency == "aud") echo " selected"; echo ">".AUSDOLLARS."</option>
							<option value=\"gbp\""; if ($ashopcurrency == "gbp") echo " selected"; echo ">Pounds Sterling</option>
							<option value=\"eur\""; if ($ashopcurrency == "eur") echo " selected"; echo ">".EURO."</option>
							<option value=\"nok\""; if ($ashopcurrency == "nok") echo " selected"; echo ">".NORKRONOR."</option>
							<option value=\"sek\""; if ($ashopcurrency == "sek") echo " selected"; echo ">".SWEDKRONOR."</option>
							<option value=\"zar\""; if ($ashopcurrency == "zar") echo " selected"; echo ">".SARAND."</option>
							<option value=\"btc\""; if ($ashopcurrency == "btc") echo " selected"; echo ">".BITCOINS."</option>
							<option value=\"jpy\""; if ($ashopcurrency == "jpy") echo " selected"; echo ">".JAPANYEN."</option>
							<option value=\"nzd\""; if ($ashopcurrency == "nzd") echo " selected"; echo ">".NEWZDOLLARS."</option>
							<option value=\"twd\""; if ($ashopcurrency == "twd") echo " selected"; echo ">".TAIWANDOLLARS."</option>
							<option value=\"sgd\""; if ($ashopcurrency == "sgd") echo " selected"; echo ">".SINGADOLLARS."</option>
							<option value=\"mxn\""; if ($ashopcurrency == "mxn") echo " selected"; echo ">Mexican Peso</option>
						</select>
					</div>
					<div class=\"form-group\"><label for=\"nthousandchar\">".THOUSANDSEPARATOR."</label>
						<select name=\"nthousandchar\" id=\"nthousandchar\" class=\"form-control\">
							<option value=\"\""; if ($thousandchar == "") echo " selected"; echo ">".NONE."</option>
							<option value=\",\""; if ($thousandchar == ",") echo " selected"; echo ">".COMMA."</option>
							<option value=\".\""; if ($thousandchar == ".") echo " selected"; echo ">".DOT."</option>
							<option value=\" \""; if ($thousandchar == " ") echo " selected"; echo ">".SPACE."</option>
						</select>
					</div>
					<div class=\"form-group\"><label for=\"ndecimalchar\">".DECIMALSEPARATOR."</label>
						<select name=\"ndecimalchar\" id=\"ndecimalchar\" class=\"form-control\">
							<option value=\",\""; if ($decimalchar == ",") echo " selected"; echo ">".COMMA."</option>
							<option value=\".\""; if ($decimalchar == ".") echo " selected"; echo ">".DOT."</option>
						</select>
					</div>
					<div class=\"form-group\"><label for=\"nshowdecimals\">".NUMBEROFDECIMALS."</label>
						<select name=\"nshowdecimals\" id=\"nshowdecimals\" class=\"form-control\">
							<option value=\"0\""; if ($showdecimals == "0") echo " selected"; echo ">0</option>
							<option value=\"1\""; if ($showdecimals == "1") echo " selected"; echo ">1</option>
							<option value=\"2\""; if ($showdecimals == "2") echo " selected"; echo ">2</option>
							<option value=\"3\""; if ($showdecimals == "3") echo " selected"; echo ">3</option>
							<option value=\"4\""; if ($showdecimals == "4") echo " selected"; echo ">4</option>
						</select>
					</div>
					<div class=\"form-group\"><label for=\"nshoppingcart\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image4','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image4\" align=\"absmiddle\" onclick=\"return overlib('$tip3b');\" onmouseout=\"return nd();\"></a> <a href=\"$help3b\" class=\"helpnav2\" target=\"_blank\">".CATALOGMODE."</a></label>
						<select name=\"nshoppingcart\" id=\"nshoppingcart\" class=\"form-control\">
							<option value=\"0\""; if ($shoppingcart == "0") echo " selected"; echo ">".SINGLEPRODUCTORDER."
							<option value=\"1\""; if ($shoppingcart == "1") echo " selected"; echo ">".SHOPPINGCART."
							<option value=\"2\""; if ($shoppingcart == "2") echo " selected"; echo ">".SINGLEPRODUCTCART."
							<option value=\"3\""; if ($shoppingcart == "3") echo " selected"; echo ">".PRICELIST."
						</select>
					</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => ENABLEWISHLISTS, "name" => "nenablecustomerlogin", "checked" => $enablecustomerlogin == "1"?TRUE:FALSE, "helpnumber" => 5, "helptext" => $tip3c, "helplink" => $help3c))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LINKFROMTHANKYOU, "name" => "norderpagelink", "value" => $orderpagelink, "helpnumber" => 7, "helptext" => $tip3e))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ASHOPAFFILIATEID, "name" => "nashopaffiliateid", "value" => $ashopaffiliateid, "helpnumber" => 24, "helptext" => $tip3f, "helplink" => $help3f, "small" => TRUE))."</div>
					<div class=\"form-group\"><label for=\"nreceiptformat\">".RECEIPTFORMAT."</a></label>
						<select name=\"nreceiptformat\" id=\"nreceiptformat\" class=\"form-control\">
							<option value=\"html\""; if ($receiptformat == "html") echo " selected"; echo ">HTML";
							/* <option value=\"pdf\""; if ($receiptformat == "pdf") echo " selected"; echo ">PDF */
							echo "<option value=\"txt\""; if ($receiptformat == "txt") echo " selected"; echo ">".PLAINTEXT."
						</select>
					</div>
					<div class=\"form-group\">
						<label for=\"ncollectcustomerinfo\">".COLLECT."</a></label>
                        <div class=\"row\">
                            <div class=\"col-xs-6\">
                                <select name=\"ncollectcustomerinfo\" id=\"ncollectcustomerinfo\" class=\"form-control\">
                                    <option value=\"1\""; if ($collectcustomerinfo == "1") echo " selected"; echo ">".FULLCONTACTINFO."
                                    <option value=\"0\""; if (!$collectcustomerinfo) echo " selected"; echo ">".ONLYNAMEEMAIL."
                                </select>
                            </div>
                            <p class=\"help-block\">".FORGIFTS."</p>
						</div>
					</div>
					<div class=\"form-group\">
						<label for=\"nupsellitems\">".UPSELL."</a></label>
                        <div class=\"row\">
                            <div class=\"col-xs-6\">
                                <select name=\"nupsellitems\" id=\"nupsellitems\" class=\"form-control\">
                                    <option value=\"0\""; if ($upsellitems == "0") echo " selected"; echo ">0
                                    <option value=\"1\""; if ($upsellitems == "1") echo " selected"; echo ">1
                                    <option value=\"2\""; if ($upsellitems == "2") echo " selected"; echo ">2
                                </select>
                            </div>
                            <p class=\"help-block\">".ITEMSONCHECKOUT."</p>
						</div>
					</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SHOWEUCOOKIEWARNING, "name" => "neucookiecheck", "checked" => $eucookiecheck == "1"?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => CUSTOMERREGISTRATIONREQUIRED, "name" => "ncustomermustregister", "checked" => $customermustregister == "1"?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => CUSTOMEREMAILCONFIRMATION, "name" => "ncustomerconfirm", "checked" => $customerconfirm == "1"?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SHOWDISCOUNTBOXONCHECKOUT, "name" => "ndiscountoncheckout", "checked" => $discountoncheckout == "1"?TRUE:FALSE, "helpnumber" => 15, "helptext" => $tip11))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => DISCOUNTMESSAGE, "name" => "ndiscountmessage", "value" => $discountmessage, "helpnumber" => 23, "helptext" => $tip12))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LOYALTYREWARD, "name" => "nvirtualcashpercent", "value" => $virtualcashpercent, "helpnumber" => 17, "helptext" => $tip13, "suffix" => "%", "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => NEWSFEED, "name" => "nashopnewsfeed", "value" => $ashopnewsfeed, "helpnumber" => 19, "helptext" => $tip15))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MASSMAILTHROTTLE, "name" => "nmassmailthrottle", "value" => $massmailthrottle, "suffix" => SECONDS, "small" => TRUE))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
			</div>
		</div>
		<div class=\"col-md-6\">
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\"><a href=\"$help4\" class=\"helpnav\" target=\"_blank\">".WHOLESALECATALOG."</a> <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image9','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image9\" align=\"absmiddle\" onclick=\"return overlib('$tip4');\" onmouseout=\"return nd();\"></a></h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"4\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_checkbox(array("label" => CHECKTOENABLEWHOLESALE, "name" => "nwholesalecatalog", "checked" => $wholesalecatalog == "1"?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PRICELEVELS, "name" => "npricelevels", "value" => $pricelevels, "small" => TRUE))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".PRODUCTFILEDOWNLOAD." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image10','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image10\" align=\"absmiddle\" onclick=\"return overlib('$tip5');\" onmouseout=\"return nd();\"></a></h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"5\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => ALLOWDOWNLOADFOR, "name" => "nalloweddownloaddays", "value" => $alloweddownloaddays, "small" => TRUE, "suffix" => DAYS, "explanation" => "[0 = ".UNLIMITED."]"))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ALLOW, "name" => "nalloweddownloads", "value" => $alloweddownloads, "small" => TRUE, "suffix" => DOWNLOADSPERPRODUCT, "explanation" => "[0 = ".UNLIMITED."]"))."</div>

					<div class=\"form-group\">
						<label for=\"ndownloadsavedialogue\">".BROWSERSAVEDIALOGUE."</label>
							<select name=\"ndownloadsavedialogue\" id=\"ndownloadsavedialogue\" class=\"form-control\">
								<option value=\"on\""; if ($downloadsavedialogue == "on") echo " selected"; echo ">".ON."
								<option value=\"off\""; if ($downloadsavedialogue == "off") echo " selected"; echo ">".OFF."
							</select>
					</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\"><a href=\"$help6\" class=\"helpnav\" target=\"_blank\">".EMAILEDKEYCODES."</a></h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"6\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_checkbox(array("label" => RANDOMKEYCODEDELIVERY, "name" => "nrandomkeycodes", "checked" => $randomkeycodes == "1"?TRUE:FALSE, "helpnumber" => 11, "helptext" => $tip6, "explanation" => UNCHECKTOUSEORIGINAL))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".SEOSETTINGS." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image18','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image18\" align=\"absmiddle\" onclick=\"return overlib('$tip14');\" onmouseout=\"return nd();\"></a></h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"7\">
				<div class=\"box-body\">
					<div class=\"form-group\"><label for=\"nseourls\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image16','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image16\" align=\"absmiddle\" onclick=\"return overlib('$tip3i');\" onmouseout=\"return nd();\"></a> ".SEOURLS."</label>
						<select name=\"nseourls\" id=\"nseourls\" class=\"form-control\">
							<option value=\"1\""; if ($seourls == "1") echo " selected"; echo ">on</option>
							<option value=\"0\""; if ($seourls == "0") echo " selected"; echo ">off</option>
						</select>
					</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => METAKEYWORDS, "name" => "nashopmetakeywords", "value" => $ashopmetakeywords))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => METADESCRIPTION, "name" => "nashopmetadescription", "value" => $ashopmetadescription))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".RECAPTCHA."</h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"11\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => RECAPTCHAKEY, "name" => "nrecaptchakey", "value" => $recaptchakey, "explanation" => LEAVEBLANKTODEACTIVATERECAPTCHA, "helpnumber" => 22, "helptext" => $tip3h, "helplink" => $help3h))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => RECAPTCHASECRET, "name" => "nrecaptchasecret", "value" => $recaptchasecret))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".MINFRAUDINTEGRATION."</h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"8\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => MINFRAUDLICENSEKEY, "name" => "nminfraudkey", "value" => $minfraudkey, "explanation" => LEAVEBLANKTODEACTIVATEMINFRAUD, "helpnumber" => 20, "helptext" => $tip18))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MINFRAUDTHRESHOLD, "name" => "nminfraudthreshold", "value" => $minfraudthreshold, "suffix" => "%", "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MINFRAUDGEOIPLICENSEKEY, "name" => "nminfraudgeoipkey", "value" => $minfraudgeoipkey, "explanation" => LEAVEBLANKTODEACTIVATEMINFRAUDGEOIP, "helpnumber" => 21, "helptext" => $tip19))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".TELESIGNINTEGRATION."</h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"shop\">
				<input type=\"hidden\" name=\"section\" value=\"9\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => TELESIGNCUSTOMERID, "name" => "ntelesignid", "value" => $telesignid, "explanation" => LEAVEBLANKTODEACTIVATETELESIGN, "helpnumber" => 22, "helptext" => $tip3h, "helplink" => $help3h))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => AUTHENTICATIONID, "name" => "ntelesignauthid", "value" => $telesignauthid))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
                    <div class=\"row row-spacer\">
                        <div class=\"col-xs-12 text-center\">
                            <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image12','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image12\" align=\"absmiddle\" onclick=\"return overlib('$tip7');\" onmouseout=\"return nd();\"></a> <a href=\"advancedoptions.php\"><button type=\"button\" class=\"btn btn-success\" style=\"margin-right: 5px;\">".ADVANCEDOPTIONS."
                            </button></a>
                        </div>
                    </div>
        ";
		} else {
		$nashopname = htmlentities(stripslashes($nashopname), ENT_QUOTES);
		$nashopphone = htmlentities(stripslashes($nashopphone), ENT_QUOTES);
		$nashopaddress = htmlentities(stripslashes($nashopaddress), ENT_QUOTES);
		if ($nactivateautoresponder == "on") $nactivateautoresponder = "1";
		else $nactivateautoresponder = "0";
		if ($nenablecustomerlogin == "on") $nenablecustomerlogin = "1";
		else $nenablecustomerlogin = "0";
		if ($ncustomerconfirm == "on") $ncustomerconfirm = "1";
		else $ncustomerconfirm = "0";
		if ($ncustomermustregister == "on") $ncustomermustregister = "1";
		else $ncustomermustregister = "0";		
		if ($nwholesalecatalog == "on") $nwholesalecatalog = "1";
		else $nwholesalecatalog = "0";
		if ($npricelevels == "0") $nwholesalecatalog = "0";
		if ($nrandomkeycodes == "on") $nrandomkeycodes = "1";
		else $nrandomkeycodes = "0";
		if ($ndiscountoncheckout == "on") $ndiscountoncheckout = "1";
		else $ndiscountoncheckout = "0";
		if ($neucookiecheck == "on") $neucookiecheck = "1";
		else $neucookiecheck = "0";	
		//if ($nshoppingcart != "1" && $nshoppingcart != "2") $nupsellitems = "0";
		$nmassmailthrottle = $nmassmailthrottle*1000000;
		if ($section == "2") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopname' WHERE prefname='ashopname'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopphone' WHERE prefname='ashopphone'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopemail' WHERE prefname='ashopemail'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopaddress' WHERE prefname='ashopaddress'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmapembed' WHERE prefname='mapembed'");
			if ($ashopemail != $nashopemail) {
				$headers = "From: ".un_html($ashopname)."<$ashopemail>\nX-Sender: <$ashopemail>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$ashopemail>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";
				@ashop_mail("$ashopemail",un_html($ashopname)." - main shopping cart email changed","The main email address of your shopping cart at $ashopurl has been changed. If you have changed it yourself you can discard this message. In other case you may have had an unauthorized login to your administration panel by IP: {$_SERVER["REMOTE_ADDR"]}! The email is now set to: $nashopemail.","$headers");
			}
		}

		if ($section == "3") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopcurrency' WHERE prefname='ashopcurrency'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ndefaultlanguage' WHERE prefname='defaultlanguage'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nthousandchar' WHERE prefname='thousandchar'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshowdecimals' WHERE prefname='showdecimals'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ndecimalchar' WHERE prefname='decimalchar'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshoppingcart' WHERE prefname='shoppingcart'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nenablecustomerlogin' WHERE prefname='enablecustomerlogin'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$norderpagelink' WHERE prefname='orderpagelink'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopaffiliateid' WHERE prefname='ashopaffiliateid'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nreceiptformat' WHERE prefname='receiptformat'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ncollectcustomerinfo' WHERE prefname='collectcustomerinfo'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupsellitems' WHERE prefname='upsellitems'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$neucookiecheck' WHERE prefname='eucookiecheck'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ncustomerconfirm' WHERE prefname='customerconfirm'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ncustomermustregister' WHERE prefname='customermustregister'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ndiscountoncheckout' WHERE prefname='discountoncheckout'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ndiscountmessage' WHERE prefname='discountmessage'");
			if (!empty($nvirtualcashpercent) && is_numeric($nvirtualcashpercent)) @mysqli_query($db, "UPDATE preferences SET prefvalue='$nvirtualcashpercent' WHERE prefname='virtualcashpercent'");
			else @mysqli_query($db, "UPDATE preferences SET prefvalue='' WHERE prefname='virtualcashpercent'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopnewsfeed' WHERE prefname='ashopnewsfeed'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmassmailthrottle' WHERE prefname='massmailthrottle'");

			// Delete payment options that can not be used with the selected currency...
			if ($nashopcurrency != "usd") $pathprefix = $nashopcurrency; else $pathprefix = "";
			$result = @mysqli_query($db, "SELECT * FROM payoptions");
			while ($row = @mysqli_fetch_array($result)) {
				if (!file_exists("$ashoppath/admin/gateways$pathprefix/".$row["gateway"].".gw")) @mysqli_query($db, "DELETE FROM payoptions WHERE payoptionid='".$row["payoptionid"]."'");
			}
		}

		if ($section == "4") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nwholesalecatalog' WHERE prefname='wholesalecatalog'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$npricelevels' WHERE prefname='pricelevels'");
		}

		if ($section == "5") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nalloweddownloaddays' WHERE prefname='alloweddownloaddays'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nalloweddownloads' WHERE prefname='alloweddownloads'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ndownloadsavedialogue' WHERE prefname='downloadsavedialogue'");		
		}

		if ($section == "6") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nrandomkeycodes' WHERE prefname='randomkeycodes'");
		}

		if ($section == "7") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nseourls' WHERE prefname='seourls'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopmetakeywords' WHERE prefname='ashopmetakeywords'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopmetadescription' WHERE prefname='ashopmetadescription'");
		}

		if ($section == "8") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nminfraudkey' WHERE prefname='minfraudkey'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nminfraudgeoipkey' WHERE prefname='minfraudgeoipkey'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nminfraudthreshold' WHERE prefname='minfraudthreshold'");
		}

		if ($section == "9") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ntelesignid' WHERE prefname='telesignid'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$ntelesignauthid' WHERE prefname='telesignauthid'");
		}

		if ($section == "10") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nsaasuwsaccesskey' WHERE prefname='saasuwsaccesskey'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nsaasufileid' WHERE prefname='saasufileid'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nsaasubankaccountid' WHERE prefname='saasubankaccountid'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nsaasutaxcode' WHERE prefname='saasutaxcode'");
		}

		if ($section == "11") {
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nrecaptchakey' WHERE prefname='recaptchakey'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nrecaptchasecret' WHERE prefname='recaptchasecret'");
		}
	}
}

if ($param == "mall") {
	if ($digitalmall != "ON") {
        echo "
            <html>
            <head><title>Redirect</title>
                <meta http-equiv=\"Refresh\" content=\"0; URL=index.php\">
            </head>
            <body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">
            <center><p>&nbsp;</p>
                <p><font face=\"Arial, Helvetica, sans-serif\"><b>If this page does not redirect...</b></font></p>
                <p><b><font face=\"Arial, Helvetica, sans-serif\">click <a href=\"../index.php\">HERE</a></font></b></p>
            </center>
            </body></html>";
		exit;
	}
	// Get subscription fees...
	$hostingresult = @mysqli_query($db, "SELECT * FROM product WHERE prodtype='mallfee'");
	$hostingrow = @mysqli_fetch_array($hostingresult);
	$hostingid = $hostingrow["productid"];
	$feeslabel = $hostingrow["name"];
	if (!$changeconfig) {
		$setupfee = $hostingrow["price"];
		$monthlyfee = $hostingrow["recurringprice"];
		if ((!empty($setupfee) || !empty($monthlyfee)) && empty($feeslabel)) $feeslabel = SHOPPINGMALLFEE;
		// Get context help for this page...
		$contexthelppage = "shopparameters";
		include "help.inc.php";
		echo "
        <div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".SHOPPINGMALL." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image12','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image12\" align=\"absmiddle\" onclick=\"return overlib('$tip9');\" onmouseout=\"return nd();\"></a></h3>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"mall\">
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_checkbox(array("label" => ENABLEMALL, "name" => "nenablemall", "checked" => $enablemall?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => SHOPPINGMALLTEXT, "name" => "nshoppingmallinfo", "value" => $shoppingmallinfo, "helpnumber" => 16, "helptext" => $tip16))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => DEFAULTCOMMISSIONLEVEL, "name" => "nmemberpercent", "value" => $memberpercent, "suffix" => "%", "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => MEMBERCATALOGS, "name" => "nmembershops", "checked" => $membershops?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => MEMBERPAYOPTIONS, "name" => "nmemberpayoptions", "checked" => $memberpayoptions?TRUE:FALSE))."</div>
					<div class=\"form-group\">
						<label for=\"nmemberprodmanage\">".MEMBERPRODUCTMANAGEMENT."</label>
						<select class=\"form-control\" name=\"nmemberprodmanage\" id=\"nmemberprodmanage\"><option value=\"none\""; if (!$memberprodmanage && !$advancedmallmode) echo " selected"; echo ">".DEACTIVATED."</option><option value=\"simple\""; if ($memberprodmanage && !$advancedmallmode) echo " selected"; echo ">".SIMPLEMODE."</option><option value=\"advanced\""; if ($memberprodmanage && $advancedmallmode) echo " selected"; echo ">".ADVANCEDMODE."</option></select>
					</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MEMBERHOSTINGLIMIT, "name" => "nmemberuploadsize", "value" => $memberuploadsize, "suffix" => "MB", "explanation" => "[0 = ".DISABLEHOSTING."]", "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => MEMBERACCOUNTSDEFAULTACTIVE, "name" => "nautoapprovemembers", "checked" => $autoapprovemembers?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => MEMBERPRODUCTSDEFAULTACTIVE, "name" => "nmemberactivate", "checked" => $memberactivate?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => DISPLAYCUSTOMERINFO, "name" => "ndmshowcustomers", "checked" => $dmshowcustomers?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => MEMBERPRODUCTTEMPLATE, "name" => "nmemberproducttemplate", "value" => $memberproducttemplate))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => FEESLABEL, "name" => "nfeeslabel", "value" => $feeslabel, "explanation" => OPTIONAL))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SETUPFEE, "name" => "nsetupfee", "value" => $setupfee, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MONTHLYFEE, "name" => "nmonthlyfee", "value" => $monthlyfee, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
                    <div class=\"row row-spacer\">
                        <div class=\"col-xs-12 text-center\">
                            <a href=\"shopcategories.php\"><button type=\"button\" class=\"btn btn-success\" style=\"margin-right: 5px;\">".EDITSHOPCATEGORIES."
                            </button></a>
                        </div>
                    </div>
		";
		} else {
		if ($nmembershops == "on") $nmembershops = "1";
		else $nmembershops = "0";
		if ($nenablemall == "on") $nenablemall = "1";
		else $nenablemall = "0";
		if ($nmemberpayoptions == "on") $nmemberpayoptions = "1";
		else $nmemberpayoptions = "0";
		if ($nmemberprodmanage == "none") {
			$nmemberprodmanage = "0";
			$nadvancedmallmode = "0";
		} else if ($nmemberprodmanage == "simple") {
			$nmemberprodmanage = "1";
			$nadvancedmallmode = "0";
		} else if ($nmemberprodmanage == "advanced") {
			$nmemberprodmanage = "1";
			$nadvancedmallmode = "1";
		}
		if ($nautoapprovemembers == "on") $nautoapprovemembers = "1";
		else $nautoapprovemembers = "0";
		if ($nmemberactivate == "on") $nmemberactivate = "1";
		else $nmemberactivate = "0";
		if ($ndmshowcustomers == "on") $ndmshowcustomers = "1";
		else $ndmshowcustomers = "0";
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nenablemall' WHERE prefname='enablemall'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmemberproducttemplate' WHERE prefname='memberproducttemplate'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$ndmshowcustomers' WHERE prefname='dmshowcustomers'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmemberpercent' WHERE prefname='memberpercent'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmemberuploadsize' WHERE prefname='memberuploadsize'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmembershops' WHERE prefname='membershops'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmemberprodmanage' WHERE prefname='memberprodmanage'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmemberpayoptions' WHERE prefname='memberpayoptions'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nadvancedmallmode' WHERE prefname='advancedmallmode'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nautoapprovemembers' WHERE prefname='autoapprovemembers'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmemberactivate' WHERE prefname='memberactivate'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshoppingmallinfo' WHERE prefname='shoppingmallinfo'");

		// Add or update hosting fee product...
		if (@mysqli_num_rows($hostingresult)) {
			if (empty($nsetupfee) && empty($nmonthlyfee)) {
				@mysqli_query($db, "DELETE FROM product WHERE prodtype='mallfee'");
				@mysqli_query($db, "DELETE FROM parameters WHERE productid='$hostingid'");
			} else {
				if (empty($nsetupfee)) $nsetupfee = "0.00";
				if (empty($nmonthlyfee)) $nmonthlyfee = "0.00";
				@mysqli_query($db, "UPDATE product SET price='$nsetupfee', recurringprice='$nmonthlyfee', name='$nfeeslabel' WHERE prodtype='mallfee'");
				$idparamresult = @mysqli_query($db, "SELECT parameterid FROM parameters WHERE productid='$hostingid'");
				if (!@mysqli_num_rows($idparamresult)) @mysqli_query($db, "INSERT INTO parameters (productid,caption) VALUES ('$hostingid','ID')");
			}
		} else if (!empty($nsetupfee) || !empty($nmonthlyfee)) {
			if (empty($nsetupfee)) $nsetupfee = "0.00";
			if (empty($nmonthlyfee)) $nmonthlyfee = "0.00";
			@mysqli_query($db, "INSERT INTO product (userid,name,price,recurringprice,prodtype) VALUES ('1','$nfeeslabel','$nsetupfee','$nmonthlyfee','mallfee')");
			$hostingid = @mysqli_insert_id($db);
			@mysqli_query($db, "INSERT INTO parameters (productid,caption) VALUES ('$hostingid','ID')");
		}
	}
}

if ($param == "affiliate") {
	if (!$changeconfig) {
		// Get context help for this page...
		$contexthelppage = "affiliateconfiguration";
		include "help.inc.php";
		echo "
        <div class=\"box box-primary\">
            <form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
                <input type=\"hidden\" name=\"param\" value=\"affiliate\">
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_textbox(array("label" => AFFILIATETEXT, "name" => "naffiliateinfo", "value" => $affiliateinfo, "helpnumber" => 1, "helptext" => $tip1, "helplink" => $help1))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => AFFILIATEEMAIL, "name" => "naffiliaterecipient", "value" => $affiliaterecipient, "helpnumber" => 2, "helptext" => $tip2))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => MULTITIER, "name" => "nsecondtieractivated", "checked" => $secondtieractivated==1?TRUE:FALSE, "helpnumber" => 4, "helptext" => $tip4, "helplink" => $help4))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MAXTIERS, "name" => "nmaxaffiliatetiers", "value" => $maxaffiliatetiers))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => UPGRADEAFFILIATESAFTER, "name" => "nupgradeaffiliate", "value" => $upgradeaffiliate, "suffix" => ORDERS, "explanation" => "[ 0 = ".DISABLE." ]"))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => REFERRALLENGTH, "name" => "nreferrallength", "value" => $referrallength, "suffix" => DAYS, "explanation" => "[ 0 = ".LIFETIME." ]"))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SHARELEADS, "name" => "nactivateleads", "checked" => $activateleads==1?TRUE:FALSE))."</div>
                    <div class=\"box-header with-border\">
                        <h3 class=\"box-title\">".NORMAL."</h3>
                    </div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => DEFAULTAFFILIATECOMMISSION, "name" => "naffiliatepercent", "value" => $affiliatepercent, "suffix" => "%", "helpnumber" => 3, "helptext" => $tip3, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => DEFAULTSECONDTIERCOMMISSION, "name" => "nsecondtierpercent", "value" => $secondtierpercent, "suffix" => "%", "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => DEFAULTWHOLESALECOMMISSION, "name" => "nwholesalepercent", "value" => $wholesalepercent, "suffix" => "%", "small" => TRUE))."</div>
                    <div class=\"box-header with-border\">
                        <h3 class=\"box-title\">".UPGRADED."</h3>
                    </div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => DEFAULTAFFILIATECOMMISSION, "name" => "naffiliatepercent2", "value" => $affiliatepercent2, "suffix" => "%", "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => DEFAULTSECONDTIERCOMMISSION, "name" => "nsecondtierpercent2", "value" => $secondtierpercent2, "suffix" => "%", "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => COMMISSIONONWHOLESALE, "name" => "nwholesaleaffiliate", "checked" => $wholesaleaffiliate==1?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => EMAILCONFIRMATION, "name" => "naffiliateconfirm", "checked" => $affiliateconfirm==1?TRUE:FALSE, "helpnumber" => 7, "helptext" => $tip7))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => REQUIREPAYPALID, "name" => "nrequirepaypalid", "checked" => $requirepaypalid==1?TRUE:FALSE, "helpnumber" => 5, "helptext" => $tip5))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => DEFAULTREDIRECTURL, "name" => "naffiliateredirect", "value" => $affiliateredirect, "helpnumber" => 6, "helptext" => $tip6))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>";
	} else {
		$naffiliateinfo = htmlentities(stripslashes($naffiliateinfo), ENT_QUOTES);
		if ($nsecondtieractivated == "on") $nsecondtieractivated = "1";
		else $nsecondtieractivated = "0";
		if ($nrequirepaypalid == "on") $nrequirepaypalid = "1";
		else $nrequirepaypalid = "0";
		if ($naffiliateconfirm == "on") $naffiliateconfirm = "1";
		else $naffiliateconfirm = "0";
		if ($nactivateleads == "on") $nactivateleads = "1";
		else $nactivateleads = "0";
		if ($nwholesaleaffiliate == "on") $nwholesaleaffiliate = "1";
		else $nwholesaleaffiliate = "0";
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$naffiliateinfo' WHERE prefname='affiliateinfo'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$naffiliaterecipient' WHERE prefname='affiliaterecipient'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$naffiliatepercent' WHERE prefname='affiliatepercent'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$naffiliatepercent2' WHERE prefname='affiliatepercent2'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nsecondtieractivated' WHERE prefname='secondtieractivated'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nsecondtierpercent' WHERE prefname='secondtierpercent'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nsecondtierpercent2' WHERE prefname='secondtierpercent2'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nwholesalepercent' WHERE prefname='wholesalepercent'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nrequirepaypalid' WHERE prefname='requirepaypalid'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$naffiliateredirect' WHERE prefname='affiliateredirect'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$naffiliateconfirm' WHERE prefname='affiliateconfirm'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmaxaffiliatetiers' WHERE prefname='maxaffiliatetiers'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupgradeaffiliate' WHERE prefname='upgradeaffiliate'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nactivateleads' WHERE prefname='activateleads'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nwholesaleaffiliate' WHERE prefname='wholesaleaffiliate'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nreferrallength' WHERE prefname='referrallength'");
	}
}

if ($param == "layout") {
	if (!$changeconfig) {
		// Get context help for this page...
		$contexthelppage = "layout";
		include "help.inc.php"; 
		echo "<script language=\"JavaScript\">
		function colorpicker(formname,fieldname) 
		{
		  w = window.open('colors.php?form='+formname+'&field='+fieldname,'_blank','toolbar=no,location=no,width=450,height=100');
	    }
		function fontselect(formname,fieldname) 
		{
		  w = window.open('fonts.php?form='+formname+'&field='+fieldname,'_blank','toolbar=no,location=no,width=350,height=200');
	    }
		</script>
        <div class=\"box box-primary\">
            <form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
                <input type=\"hidden\" name=\"param\" value=\"layout\">
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".DEFAULTLOGOIMAGE." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image1','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image1\" align=\"absmiddle\" onclick=\"return overlib('$tip1');\" onmouseout=\"return nd();\"></a></h3>
                </div>
                <div class=\"box-body\">
					<div class=\"form-group\">".admin_inputfield(array("label" => UPLOADLOGOIMAGE, "name" => "imgfile", "fileupload" => TRUE))."</div>
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".THEMESELECTION." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image2','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image2\" align=\"absmiddle\" onclick=\"return overlib('$tip2');\" onmouseout=\"return nd();\"></a></h3>
                </div>
                <div class=\"box-body\">
					<div class=\"form-group\">
						<label for=\"nashoptheme\">
                            ".THEME."
                        </label>
                        <select class=\"form-control\" name=\"nashoptheme\">";
                        $findfile = opendir("$ashoppath/themes");
                        $starttime = time();
                        while ($founddir = readdir($findfile)) {
                            if  (time()-$starttime > 180) exit;
                            if (is_dir("$ashoppath/themes/$founddir") && $founddir != "." && $founddir != ".." && $founddir != ".htaccess" && !strstr($founddir, "CVS") && substr($founddir, 0, 1) != "_") {
                                echo "<option value=\"$founddir\"";
                                $fp = fopen ("$ashoppath/themes/$founddir/theme.cfg.php","r");
                                if ($fp) {
                                    while (!feof ($fp)) {
                                        $fileline = fgets($fp, 4096);
                                        if (strstr($fileline,"\$themename")) $themenamestring = $fileline;
                                    }
                                    fclose($fp);
                                    eval ($themenamestring);
                                }
                                if ($ashoptheme == $founddir) echo " selected";
                                echo ">$themename</option>";
                            }
                        }
                        echo "</select>
                    </div>
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".SLOGAN."</h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => TEXT, "name" => "nslogan", "value" => $slogan))."</div>
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".HOMEPAGEBANNERS."</h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => BANNERONE, "name" => "bannerone", "fileupload" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LINKTOURL, "name" => "nhomebannerurl1", "value" => $homebannerurl1))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => BANNERTWO, "name" => "bannertwo", "fileupload" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LINKTOURL, "name" => "nhomebannerurl2", "value" => $homebannerurl2))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => BANNERTHREE, "name" => "bannerthree", "fileupload" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LINKTOURL, "name" => "nhomebannerurl3", "value" => $homebannerurl3))."</div>
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".PRODUCTLAYOUT." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image5','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image5\" align=\"absmiddle\" onclick=\"return overlib('$tip5');\" onmouseout=\"return nd();\"></a></h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => ITEMSPERROW, "name" => "nitemsperrow", "value" => $itemsperrow, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SHOWPRODUCTINFO, "name" => "nshowfileinfo", "checked" => $showfileinfo == "true"?TRUE:FALSE))."</div>
                    <div class=\"form-group\">
						<label for=\"nashopsortorder\">
                            ".PRODUCTSORTORDER."
                        </label>
                        <select class=\"form-control\" name=\"nashopsortorder\"><option value=\"ASC\""; if ($ashopsortorder == "ASC") echo " selected"; echo ">".NEWITEMSLAST."<option value=\"DESC\""; if ($ashopsortorder == "DESC") echo " selected"; echo ">".NEWITEMSFIRST."</select>
                    </div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => HIDEEMPTYCATEGORIES, "name" => "nhideemptycategories", "checked" => $hideemptycategories == "true"?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SHOWPRODUCTCOUNT, "name" => "nenableproductcount", "checked" => $enableproductcount == "1"?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ITEMSPERPAGE, "name" => "ndisplayitems", "value" => $displayitems, "helpnumber" => 8, "helptext" => $tip3g, "small" => TRUE))."</div>
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".OTHERSETTINGS."</h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => NUMBEROFFEATURES, "name" => "nnumberoffeatures", "value" => $numberoffeatures, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SHOWTHUMBNAILSINCART, "name" => "nshowimagesincart", "checked" => $showimagesincart == "true"?TRUE:FALSE, "helpnumber" => 10, "helptext" => $tip10))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => LINKTOLARGEIMAGE, "name" => "nkeeplargeprodimg", "checked" => $keeplargeprodimg == "true"?TRUE:FALSE, "helpnumber" => 9, "helptext" => $tip9))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => INCLUDESUBCATEGORIES, "name" => "nincludesubcategories", "checked" => $includesubcategories == "true"?TRUE:FALSE, "helpnumber" => 11, "helptext" => $tip11))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => DETAILEDCARTLISTONCHECKOUT, "name" => "ncartlistoncheckout", "checked" => $cartlistoncheckout == "1"?TRUE:FALSE))."</div>
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
                    ";
	} else {
		if ($nusecondensedlayout == "on") $nusecondensedlayout = "true";
		else $nusecondensedlayout = "0";
		if ($nshowfileinfo == "on") $nshowfileinfo = "true";
		else $nshowfileinfo = "0";		
		if ($nkeeplargeprodimg == "on") $nkeeplargeprodimg = "true";
		else $nkeeplargeprodimg = "0";
		if ($nshowimagesincart == "on") $nshowimagesincart = "true";
		else $nshowimagesincart = "0";
		if ($nhideemptycategories == "on") $nhideemptycategories = "true";
		else $nhideemptycategories = "0";
		if ($ncartlistoncheckout == "on") $ncartlistoncheckout = "1";
		else $ncartlistoncheckout = "0";
		if ($nenableproductcount == "on") $nenableproductcount = "1";
		else $nenableproductcount = "0";
		if ($nincludesubcategories == "on") $nincludesubcategories = "true";
		else $includesubcategories = "0";
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashoptheme' WHERE prefname='ashoptheme'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopsortorder' WHERE prefname='ashopsortorder'");
        @mysqli_query($db, "UPDATE preferences SET prefvalue='$nitemsperrow' WHERE prefname='itemsperrow'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshowfileinfo' WHERE prefname='showfileinfo'");		
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nnumberoffeatures' WHERE prefname='numberoffeatures'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nkeeplargeprodimg' WHERE prefname='keeplargeprodimg'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshowimagesincart' WHERE prefname='showimagesincart'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nhideemptycategories' WHERE prefname='hideemptycategories'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$ncartlistoncheckout' WHERE prefname='cartlistoncheckout'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nenableproductcount' WHERE prefname='enableproductcount'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nincludesubcategories' WHERE prefname='includesubcategories'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nhomebannerurl1' WHERE prefname='homebannerurl1'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nhomebannerurl2' WHERE prefname='homebannerurl2'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nhomebannerurl3' WHERE prefname='homebannerurl3'");
        @mysqli_query($db, "UPDATE preferences SET prefvalue='$ndisplayitems' WHERE prefname='displayitems'");
        @mysqli_query($db, "UPDATE preferences SET prefvalue='$nslogan' WHERE prefname='slogan'");
	}
}

if ($param == "shipping") {
	if (!$changeconfig || $addcountry) {
		// Get context help for this page...
		$contexthelppage = "shipping";
		include "help.inc.php";
		if ($storeshippingmaxweight) {
			$totalounces = $storeshippingmaxweight*16;
			$storeshippingmaxpounds = floor($storeshippingmaxweight);
			$storeshippingmaxounces = ($totalounces-($storeshippingmaxpounds*16));
			$storeshippingmaxounces = number_format($storeshippingmaxounces,1,'.','');
		} else {
			$storeshippingmaxpounds = 1.00;
			$storeshippingmaxounces = 0.00;
		}
		echo "
        <div class=\"box box-primary\">
            <form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\">
                <input type=\"hidden\" name=\"param\" value=\"shipping\">
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".SHIPPINGCALCULATIONOPTIONS." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image2','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image2\" align=\"absmiddle\" onclick=\"return overlib('$tip2');\" onmouseout=\"return nd();\"></a></h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">
						<label for=\"nashopsortorder\">
                            ".SHIPPINGMETHOD."
                        </label>
                        <select class=\"form-control\" name=\"nshippingmethod\" onChange=\"document.configurationform.submit()\"><option value=\"custom\""; if ($shippingmethod == "custom") echo " selected"; echo ">".CUSTOM."<option value=\"usps\""; if ($shippingmethod == "usps") echo " selected"; echo ">".USPS."<option value=\"ups\""; if ($shippingmethod == "ups") echo " selected"; echo ">".UPS."<option value=\"fedex\""; if ($shippingmethod == "fedex") echo " selected"; echo ">".FEDEX."</select>
                    </div>";
		$countrynumber = 1;
		if ($shipfromcountries) foreach($shipfromcountries as $thisshipfromcountry) {
			echo "<div class=\"form-group\">";
			if ($countrynumber == 1) echo "<label for=\"nashopsortorder\">".LOCALHANDLINGCOUNTRIES."</label>";
			echo "<select class=\"form-control\" name=\"nshipfromcountry$countrynumber\"><option value=none>".CHOOSECOUNTRY."<option  value=none>-- ".REMOVETHISCOUNTRY;
			foreach ($countries as $shortcountry => $longcountry) {
				if (strlen($longcountry) > 30) $longcountry = substr($longcountry,0,27)."...";
				echo "<option  value=$shortcountry";
				if ($shortcountry == $thisshipfromcountry) echo " selected";
				echo ">$longcountry\n";
			}
			$countrynumber++;
			echo "</select></div>";
		}
		if ($addcountry) {
			echo "<div class=\"form-group\"><select class=\"form-control\" name=\"nshipfromcountry$countrynumber\"><option  value=none>".CHOOSECOUNTRY."<option  value=none>-- ".REMOVETHISCOUNTRY;
			foreach ($countries as $shortcountry => $longcountry) {
				if (strlen($longcountry) > 30) $longcountry = substr($longcountry,0,27)."...";
				echo "<option  value=$shortcountry>$longcountry\n";
			}
			echo "</select></div>";
		}

		echo "
                    <div class=\"form-group\"><button type=\"submit\" class=\"btn btn-primary\">".ADDCOUNTRY."</button></div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SHIPONLYLOCALLY, "name" => "nlocalshipping", "checked" => $localshipping?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ADDLOCALHANDLINGCHARGE, "name" => "nhandlinglocal", "value" => $handlinglocal, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ADDINTERNATIONALHANDLINGCHARGE, "name" => "nhandlingint", "value" => $handlingint, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => FREESHIPPINGONORDERSABOVE, "name" => "nfreeshippinglimit", "value" => $freeshippinglimit, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE, "explanation" => "[ 0 = ".DEACTIVATE." ]"))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => FREESHIPPINGONLYLOCALLY, "name" => "nfreeshippingonlylocal", "checked" => $freeshippingonlylocal?TRUE:FALSE))."</div>";

		if ($shippingmethod == "usps") {
			echo "
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".USPSOPTIONS." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image7','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image7\" align=\"absmiddle\" onclick=\"return overlib('$tip10');\" onmouseout=\"return nd();\"></a></h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => USPSUSERID, "name" => "nuspsuserid", "value" => $uspsuserid))."</div>
                    <div class=\"form-group\">
						<label for=\"nuspscustomerselect\">
                            ".CUSTOMERSELECTABLESERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nuspscustomerselect\"><option value=\"no\""; if($shipoptionstype != "usps") echo " selected"; echo ">".NO."</option><option value=\"yes\""; if($shipoptionstype == "usps") echo " selected"; echo ">".YES."</option></select>
                    </div>
                    <div class=\"form-group\">
						<label for=\"nuspsserviceusa\">
                            ".LOCALSERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nuspsserviceusa\"><option value=\"0\""; if(!$upsserviceusa) echo " selected"; echo ">".CHOOSESERVICE."</option>";
			foreach ($uspsservicesusa as $servicecode => $servicename) {
				echo "<option value=\"$servicecode\"";
				if ($servicecode == $uspsserviceusa) echo " selected";
				echo ">$servicename\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nuspsserviceworld\">
                            ".INTERNATIONALSERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nuspsserviceworld\"><option value=\"0\""; if(!$uspsserviceworld) echo " selected"; echo ">".CHOOSESERVICE."</option>";
			foreach ($uspsservicesworld as $servicecode => $servicename) {
				echo "<option value=\"$servicecode\"";
				if ($servicecode == $uspsserviceworld) echo " selected";
				echo ">$servicename\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nuspscontainer\">
                            ".CONTAINER."
                        </label>
                        <select class=\"form-control\" name=\"nuspscontainer\"><option value=none>".CHOOSECONTAINER;
			foreach ($uspscontainers as $containercode => $containername) {
				echo "<option  value=\"$containercode\"";
				if ($containercode == $uspscontainer) echo " selected";
				echo ">$containername\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nuspsmachinable\">
                            ".MACHINABLE."
                        </label>
                        <select class=\"form-control\" name=\"nuspsmachinable\"><option value=\"True\""; if ($uspsmachinable == "True") echo " selected"; echo ">".YES."</option><option value=\"no\""; if ($uspsmachinable == "False") echo " selected"; echo ">".NO."</option></select></div>";
		} else if ($shippingmethod == "ups") {
			echo "
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".UPSOPTIONS." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image7','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image7\" align=\"absmiddle\" onclick=\"return overlib('$tip7');\" onmouseout=\"return nd();\"></a></h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => UPSACCESSKEY, "name" => "nupsaccesskey", "value" => $upsaccesskey))."</div>
                    <div class=\"form-group\">
						<label for=\"nupscountry\">
                            ".ORIGINCOUNTRY."
                        </label>
                        <select class=\"form-control\" name=\"nupscountry\"><option value=\"0\""; if(!$upscountry) echo " selected"; echo ">".CHOOSECOUNTRY."</option><option value=\"US\"";
			if ($upscountry == "US") echo " selected";
			echo ">".UNITEDSTATES."\n<option value=\"CA\"";
			if ($upscountry == "CA") echo " selected";
			echo ">".CANADA."\n</select></div>
                    <div class=\"form-group\">
						<label for=\"nupscustomerselect\">
                            ".CUSTOMERSELECTABLESERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nupscustomerselect\"><option value=\"no\""; if($shipoptionstype != "ups") echo " selected"; echo ">".NO."</option><option value=\"yes\""; if($shipoptionstype == "ups") echo " selected"; echo ">".YES."</option></select></div>
                    <div class=\"form-group\">
						<label for=\"nupsserviceusa\">
                            ".LOCALSERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nupsserviceusa\"><option value=\"0\""; if(!$upsserviceusa) echo " selected"; echo ">".CHOOSESERVICE."</option>";
			if ($upscountry == "US") {
				foreach ($upsservicesusa as $servicecode => $servicename) {
					echo "<option value=\"$servicecode\"";
					if ($servicecode == $upsserviceusa) echo " selected";
					echo ">$servicename\n";
				}
			} else {
				foreach ($upsservicescan as $servicecode => $servicename) {
					echo "<option value=\"$servicecode\"";
					if ($servicecode == $upsserviceusa) echo " selected";
					echo ">$servicename\n";
				}
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nupsservicecanusa\">
                            ".SERVICE." "; if ($upscountry == "US") echo TOCANADA; else echo TOUSA; echo "
                        </label>
                        <select class=\"form-control\" name=\"nupsservicecanusa\"><option value=\"0\""; if(!$upsserviceusa) echo " selected"; echo ">".CHOOSESERVICE."</option>";
			if ($upscountry == "US") {
				foreach ($upsservicestocan as $servicecode => $servicename) {
					echo "<option value=\"$servicecode\"";
					if ($servicecode == $upsservicecanusa) echo " selected";
					echo ">$servicename\n";
				}
			} else {
				foreach ($upsservicestousa as $servicecode => $servicename) {
					echo "<option value=\"$servicecode\"";
					if ($servicecode == $upsservicecanusa) echo " selected";
					echo ">$servicename\n";
				}
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nupsserviceworld\">
                            ".INTERNATIONALSERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nupsserviceworld\"><option value=\"0\""; if(!$upsserviceworld) echo " selected"; echo ">".CHOOSESERVICE."</option>";
			foreach ($upsservicesworld as $servicecode => $servicename) {
				echo "<option value=\"$servicecode\"";
				if ($servicecode == $upsserviceworld) echo " selected";
				echo ">$servicename\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nupsdropofftype\">
                            ".DROPOFFPICKUP."
                        </label>
                        <select class=\"form-control\" name=\"nupsdropofftype\"><option value=none>".CHOOSEDROPOFFPICKUP;
			foreach ($upsdropofftypes as $number => $dropoffname) {
				echo "<option  value=\"$number\"";
				if ($number == $upsdropofftype) echo " selected";
				echo ">$dropoffname\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nupsdailypickup\">
                            ".DAILYPICKUP."
                        </label>
                        <select class=\"form-control\" name=\"nupsdailypickup\"><option value=\"yes\""; if ($upsdailypickup == "yes") echo " selected"; echo ">".YES."</option><option value=\"no\""; if ($upsdailypickup == "no") echo " selected"; echo ">".NO."</option></select></div>
                    <div class=\"form-group\">
						<label for=\"nupspackagetype\">
                            ".PACKAGETYPELOCAL."
                        </label>
                        <select class=\"form-control\" name=\"nupspackagetype\"><option  value=none>".CHOOSEPACKAGETYPE;
			if ($upsserviceusa == "03" || $upsserviceusa == "12") echo "<option  value=\"02\" selected>".PACKAGE."\n";
			else {
				foreach ($upspackagetypes as $packagecode => $packagename) {
					if ($packagecode != "24" && $packagecode != "25") {
						echo "<option  value=\"$packagecode\"";
						if ($packagecode == $upspackagetype) echo " selected";
						echo ">$packagename\n";
					}
				}
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nupspackagetypeworld\">
                            ".PACKAGETYPEINT."
                        </label>
                        <select class=\"form-control\" name=\"nupspackagetypeworld\"><option  value=none>".CHOOSEPACKAGETYPE;
			foreach ($upspackagetypes as $packagecode => $packagename) {
				if (($packagecode != "01" && $packagecode != "24" && $packagecode != "25") || $upsserviceworld == "07") {
					echo "<option  value=\"$packagecode\"";
					if ($packagecode == $upspackagetypeworld) echo " selected";
					echo ">$packagename\n";
				}
			}
			echo "</select></div>";
		} else if ($shippingmethod == "fedex") {
			echo "
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".FEDEXOPTIONS." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image8','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image8\" align=\"absmiddle\" onclick=\"return overlib('$tip8');\" onmouseout=\"return nd();\"></a></h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => FEDEXACCOUNT, "name" => "nfedexaccount", "value" => $fedexaccount))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => FEDEXMETERNUMBER, "name" => "nfedexmeternumber", "value" => $fedexmeternumber))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => FEDEXKEY, "name" => "nfedexkey", "value" => $fedexkey))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => FEDEXPASSWORD, "name" => "nfedexpassword", "value" => $fedexpassword))."</div>
                    <div class=\"form-group\">
						<label for=\"nfedexcustomerselect\">
                            ".CUSTOMERSELECTABLESERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nfedexcustomerselect\"><option value=\"no\""; if($shipoptionstype != "fedex") echo " selected"; echo ">".NO."</option><option value=\"yes\""; if($shipoptionstype == "fedex") echo " selected"; echo ">".YES."</option></select></div>
                    <div class=\"form-group\">
						<label for=\"nfedexserviceusa\">
                            ".USSERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nfedexserviceusa\"><option value=\"0\""; if(!$fedexserviceusa) echo " selected"; echo ">".CHOOSESERVICE."</option>";
			foreach ($fedexservicesusa as $servicecode => $servicename) {
				echo "<option value=\"$servicecode\"";
				if ($servicecode == $fedexserviceusa) echo " selected";
				echo ">$servicename\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nfedexserviceworld\">
                            ".INTERNATIONALSERVICE."
                        </label>
                        <select class=\"form-control\" name=\"nfedexserviceworld\"><option value=\"0\""; if(!$fedexserviceworld) echo " selected"; echo ">".CHOOSESERVICE."</option>";
			foreach ($fedexservicesworld as $servicecode => $servicename) {
				echo "<option value=\"$servicecode\"";
				if ($servicecode == $fedexserviceworld) echo " selected";
				echo ">$servicename\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nfedexpackagetype\">
                            ".PACKAGETYPEUS."
                        </label>
                        <select class=\"form-control\" name=\"nfedexpackagetype\"><option  value=none>".CHOOSEPACKAGETYPE;
			foreach ($fedexpackagetypes as $packagecode => $packagename) {
				if ($packagecode != "15" && $packagecode != "25") {
					echo "<option  value=\"$packagecode\"";
					if ($packagecode == $fedexpackagetype) echo " selected";
					echo ">$packagename\n";
				}
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nfedexpackagetypeworld\">
                            ".PACKAGETYPEINT."
                        </label>
                        <select class=\"form-control\" name=\"nfedexpackagetypeworld\"><option  value=none>".CHOOSEPACKAGETYPE;
			foreach ($fedexpackagetypes as $packagecode => $packagename) {
				echo "<option  value=\"$packagecode\"";
				if ($packagecode == $fedexpackagetypeworld) echo " selected";
				echo ">$packagename\n";
			}
			echo "</select></div>";
		}

        echo "
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".STOREWIDESHIPPING." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image6','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image6\" align=\"absmiddle\" onclick=\"return overlib('$tip6');\" onmouseout=\"return nd();\"></a></h3>
                </div>
                <div class=\"box-body\">";

		if ($shippingmethod == "custom") {
			echo "<div class=\"form-group\">
                    <label for=\"nashopsortorder\">".SHIPPINGCALCULATIONMETHOD."</label>
                    <select class=\"form-control\" name=\"nstoreshippingmethod\" onChange=\"document.configurationform.submit()\">
                        <option value=\"none\"";
			if ($storeshippingmethod == "none") echo " selected";
			echo ">".THEWORDNONE."</option>
			<option value=\"perpound\"";		
			if ($storeshippingmethod == "perpound") echo " selected";
			echo ">".PERPOUND."</option>
			<option value=\"byweight\"";		
			if ($storeshippingmethod == "byweight") echo " selected";
			echo ">".BYWEIGHTRANGE."</option>
			<option value=\"byprice\"";
			if ($storeshippingmethod == "byprice") echo " selected";
			echo ">".BYPRICE."</option>
			</select></div>";
		}
		if ($shippingmethod != "custom") {
			echo "
                    <div class=\"form-group\">
						<label for=\"nstoreshippingfromstate\">
                            ".ORIGINSTATE."
                        </label>
                        <select class=\"form-control\" name=\"nstoreshippingfromstate\"><option value=none>".CHOOSESTATE;
			 $storeshippingstates = $uscanstates;
			if (in_array("AU", $shipfromcountries) && !in_array("CA", $shipfromcountries) && !in_array("US", $shipfromcountries)) $storeshippingstates = $australianstates;
			else if (in_array("CA", $shipfromcountries) && !in_array("US", $shipfromcountries) && !in_array("AU", $shipfromcountries)) $storeshippingstates = $canprovinces;
			else if (in_array("US", $shipfromcountries) && !in_array("CA", $shipfromcountries) && !in_array("AU", $shipfromcountries)) $storeshippingstates = $americanstates;
			else $storeshippingstates = $uscanstates;
			foreach ($storeshippingstates as $longstate => $shortstate) {
				echo "<option  value=$shortstate";
				if ($shortstate == $storeshippingfromstate) echo " selected";
				echo ">$longstate\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ORIGINZIP, "name" => "nstoreshippingfromzip", "value" => $storeshippingfromzip, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MAXWEIGHTPERPACKAGE, "name" => "nstoreshippingmaxpounds", "value" => $storeshippingmaxpounds, "suffix" => POUND, "small" => TRUE))." ".admin_inputfield(array("name" => "nstoreshippingmaxounces", "value" => $storeshippingmaxounces, "suffix" => OUNCE, "small" => TRUE))."</div>";
		} else if ($storeshippingmethod == "perpound") {
			echo "
            <div class=\"form-group\">".admin_inputfield(array("label" => BASECHARGE, "name" => "nstoreshippingbasecharge", "value" => $storeshippingbasecharge, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE))."</div>
            <div class=\"form-group\">".admin_inputfield(array("label" => RATEPERPOUND, "name" => "nstoreshippingperpound", "value" => $storeshippingperpound, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"], "small" => TRUE))."</div>";			
		} else if ($storeshippingmethod == "byweight") echo $weightshippinglevelstring;
		else if ($storeshippingmethod == "byprice") echo $priceshippinglevelstring;
        echo "
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
                    <div class=\"row row-spacer\">
                        <div class=\"col-xs-6 text-center\">
                            <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3\" align=\"absmiddle\" onclick=\"return overlib('$tip3');\" onmouseout=\"return nd();\"></a> <a href=\"editzones.php\"><button type=\"button\" class=\"btn btn-success\" style=\"margin-right: 5px;\">".ZIPZONETABLES."
                            </button></a>
                        </div>";
		if ($shippingmethod == "custom") echo "
                        <div class=\"col-xs-6 text-center\">
                            <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image4','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image4\" align=\"absmiddle\" onclick=\"return overlib('$tip4');\" onmouseout=\"return nd();\"></a> <a href=\"editshipoptions.php\"><button type=\"button\" class=\"btn btn-success\" style=\"margin-right: 5px;\">".CUSTOMSHIPPINGOPTIONS."
                            </button></a>
                        </div>
                    </div>
                    <div class=\"row\">
                        <div class=\"col-xs-6 text-center\">
                            <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image5','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image5\" align=\"absmiddle\" onclick=\"return overlib('$tip5');\" onmouseout=\"return nd();\"></a> <a href=\"editshipdiscounts.php\"><button type=\"button\" class=\"btn btn-success\" style=\"margin-right: 5px;\">".SHIPPINGDISCOUNTS."
                            </button></a>
                        </div>
                    </div>";
		else echo "
                        <div class=\"col-xs-6 text-center\">
                            <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image5','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image5\" align=\"absmiddle\" onclick=\"return overlib('$tip5');\" onmouseout=\"return nd();\"></a> <a href=\"editshipdiscounts.php\"><button type=\"button\" class=\"btn btn-success\" style=\"margin-right: 5px;\">".SHIPPINGDISCOUNTS."
                            </button></a>
                        </div>
                    </div>";
	} else {
		if ($nlocalshipping == "on") $nlocalshipping = "1";
		else $nlocalshipping = "0";
		if ($nshippingmethod == "fedex" && $nfedexcustomerselect == "yes") $nshipoptionstype = "fedex";
		else if ($nshippingmethod == "ups" && $nupscustomerselect == "yes") $nshipoptionstype = "ups";
		else if ($nshippingmethod == "usps" && $nuspscustomerselect == "yes") $nshipoptionstype = "usps";
		else $nshipoptionstype = "custom";
		if ($nfreeshippingonlylocal == "on") $nfreeshippingonlylocal = "1";
		else $nfreeshippingonlylocal = "0";
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshippingmethod' WHERE prefname='shippingmethod'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshipfromcountry' WHERE prefname='shipfromcountry'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nlocalshipping' WHERE prefname='localshipping'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nhandlinglocal' WHERE prefname='handlinglocal'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nhandlingint' WHERE prefname='handlingint'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfreeshippinglimit' WHERE prefname='freeshippinglimit'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfreeshippingonlylocal' WHERE prefname='freeshippingonlylocal'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshipoptionstype' WHERE prefname='shipoptionstype'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nstoreshippingmethod' WHERE prefname='storeshippingmethod'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$npriceshipping' WHERE prefname='priceshipping'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nweightshipping' WHERE prefname='weightshipping'");
		if (isset($nstoreshippingmaxpounds) || isset($nstoreshippingmaxounces)) {
			$totalounces = ($nstoreshippingmaxpounds*16)+$nstoreshippingmaxounces;
			$nstoreshippingmaxweight = $totalounces/16;
			@mysqli_query($db, "UPDATE preferences SET prefvalue='".number_format($nstoreshippingmaxweight,2,'.','')."' WHERE prefname='storeshippingmaxweight'");
		}
		if (isset($nstoreshippingfromzip)) @mysqli_query($db, "UPDATE preferences SET prefvalue='$nstoreshippingfromzip' WHERE prefname='storeshippingfromzip'");
		if (isset($nstoreshippingfromstate)) @mysqli_query($db, "UPDATE preferences SET prefvalue='$nstoreshippingfromstate' WHERE prefname='storeshippingfromstate'");
		if (isset($nstoreshippingbasecharge)) @mysqli_query($db, "UPDATE preferences SET prefvalue='$nstoreshippingbasecharge' WHERE prefname='storeshippingbasecharge'");
		if (isset($nstoreshippingperpound)) @mysqli_query($db, "UPDATE preferences SET prefvalue='$nstoreshippingperpound' WHERE prefname='storeshippingperpound'");
		if ($nshippingmethod != $shippingmethod) {
			if ($nshippingmethod == "custom") @mysqli_query($db, "UPDATE preferences SET prefvalue='none' WHERE prefname='storeshippingmethod'");
			else if ($nshippingmethod == "usps") @mysqli_query($db, "UPDATE preferences SET prefvalue='usps' WHERE prefname='storeshippingmethod'");
			else if ($nshippingmethod == "fedex") @mysqli_query($db, "UPDATE preferences SET prefvalue='fedex' WHERE prefname='storeshippingmethod'");
			else if ($nshippingmethod == "ups") @mysqli_query($db, "UPDATE preferences SET prefvalue='ups' WHERE prefname='storeshippingmethod'");
			header("Location: configure.php?param=shipping");
			exit;
		}
		if ($nstoreshippingmethod != $storeshippingmethod && $nshippingmethod == "custom") {
			header("Location: configure.php?param=shipping");
			exit;
		}
		if ($shippingmethod == "usps") {
			if ($shipoptionstype == "custom" || $nshipoptionstype == "custom") $sql = "SELECT productid FROM product WHERE shipping = 'ups' OR shipping = 'fedex'";
			else $sql = "SELECT productid FROM product WHERE shipping IS NOT NULL AND shipping != '' AND shipping != 'usps' AND shipping !='storewide'";
			$shippingresult = @mysqli_query($db, $sql);
			while ($shippingrow = @mysqli_fetch_array($shippingresult)) @mysqli_query($db, "UPDATE product SET shipping='usps' WHERE productid='{$shippingrow["productid"]}'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='usps' WHERE prefname='storeshippingmethod'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nuspsuserid' WHERE prefname='uspsuserid'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nuspsserviceusa' WHERE prefname='uspsserviceusa'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nuspsserviceworld' WHERE prefname='uspsserviceworld'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nuspsmachinable' WHERE prefname='uspsmachinable'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nuspssize' WHERE prefname='uspssize'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nuspscontainer' WHERE prefname='uspscontainer'");
		} else if ($shippingmethod == "fedex") {
			if ($shipoptionstype == "custom" || $nshipoptionstype == "custom") $sql = "SELECT productid FROM product WHERE shipping = 'ups' OR shipping = 'usps'";
			else $sql = "SELECT productid FROM product WHERE shipping IS NOT NULL AND shipping != '' AND shipping != 'fedex' AND shipping !='storewide'";
			$shippingresult = @mysqli_query($db, $sql);
			while ($shippingrow = @mysqli_fetch_array($shippingresult)) @mysqli_query($db, "UPDATE product SET shipping='fedex' WHERE productid='{$shippingrow["productid"]}'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='fedex' WHERE prefname='storeshippingmethod'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexaccount' WHERE prefname='fedexaccount'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexmeternumber' WHERE prefname='fedexmeternumber'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexkey' WHERE prefname='fedexkey'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexpassword' WHERE prefname='fedexpassword'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexserviceusa' WHERE prefname='fedexserviceusa'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexserviceworld' WHERE prefname='fedexserviceworld'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexpackagetype' WHERE prefname='fedexpackagetype'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexcarrier' WHERE prefname='fedexcarrier'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfedexpackagetypeworld' WHERE prefname='fedexpackagetypeworld'");
		} else if ($shippingmethod == "ups") {
			if ($shipoptionstype == "custom" || $nshipoptionstype == "custom") $sql = "SELECT productid FROM product WHERE shipping = 'fedex' OR shipping = 'usps'";
			else $sql = "SELECT productid FROM product WHERE shipping IS NOT NULL AND shipping != '' AND shipping != 'ups' AND shipping !='storewide'";
			$shippingresult = @mysqli_query($db, $sql);
			$shippingresult = @mysqli_query($db, $sql);
			while ($shippingrow = @mysqli_fetch_array($shippingresult)) @mysqli_query($db, "UPDATE product SET shipping='ups' WHERE productid='{$shippingrow["productid"]}'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='ups' WHERE prefname='storeshippingmethod'");
			if ($nupsdailypickup == "no") {
				if ($nupsdropofftype == "1") $nupspickuptype = "03";
				if ($nupsdropofftype == "2") $nupspickuptype = "11";
				if ($nupsdropofftype == "3") $nupspickuptype = "06";
				if ($nupsdropofftype == "4") $nupspickuptype = "19";
			} else {
				if ($nupsdropofftype == "1") $nupspickuptype = "03";
				if ($nupsdropofftype == "2") $nupspickuptype = "01";
				if ($nupsdropofftype == "3") { $nupsdailypickup = "no"; $nupspickuptype = "06"; }
				if ($nupsdropofftype == "4") $nupspickuptype = "01";
			}

			if ($nupsserviceusa == "03" || $nupsserviceusa == "12") $nupspackagetype = "02";
			if ($nupsserviceworld == "08" && ($nupspackagetypeworld == "01" || $nupspackagetypeworld == "24" || $nupspackagetypeworld == "25")) $nupspackagetypeworld = "02";
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupsaccesskey' WHERE prefname='upsaccesskey'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupsserviceusa' WHERE prefname='upsserviceusa'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupsservicecanusa' WHERE prefname='upsservicecanusa'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupsserviceworld' WHERE prefname='upsserviceworld'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupspackagetype' WHERE prefname='upspackagetype'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupspickuptype' WHERE prefname='upspickuptype'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupspackagetypeworld' WHERE prefname='upspackagetypeworld'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupscountry' WHERE prefname='upscountry'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupsdropofftype' WHERE prefname='upsdropofftype'");
			@mysqli_query($db, "UPDATE preferences SET prefvalue='$nupsdailypickup' WHERE prefname='upsdailypickup'");
		} else @mysqli_query($db, "UPDATE product SET shipping='' WHERE shipping='ups' OR shipping='fedex'");
	}
}

if ($param == "taxes") {
	if (!$changeconfig || $addcountry) {
		// Get context help for this page...
		$contexthelppage = "shipping";
		include "help.inc.php"; 
		echo "
        <div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\">".SALESTAXOPTIONS." <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image1','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image1\" align=\"absmiddle\" onclick=\"return overlib('$tip1');\" onmouseout=\"return nd();\"></a></h3>
			</div>
			<form role=\"form\" action=\"configure.php?changeconfig=1\" method=\"post\" name=\"configurationform\" enctype=\"multipart/form-data\">
				<input type=\"hidden\" name=\"param\" value=\"taxes\"><input type=\"hidden\" name=\"updatetaxes\" value=\"\">
				<div class=\"box-body\">
                    <div class=\"form-group\">
						<label for=\"nstoreshippingfromstate\">
                            ".SALESTAXTYPE."
                        </label>
                        <select class=\"form-control\" name=\"nsalestaxtype\" onChange=\"configurationform.updatetaxes.value=1; configurationform.submit();\"><option value=\"ussalestax\"";
		if($salestaxtype == "ussalestax") echo " selected";
		echo ">".USSALESTAX."</option><option value=\"cancstpst\"";
		if($salestaxtype == "cancstpst") echo " selected";
		echo ">".CANGSTPSTHST."</option><option value=\"euvat\"";
		if($salestaxtype == "euvat") echo " selected";
		echo ">".EUROPEANVAT."</option><option value=\"australiagst\"";
		if($salestaxtype == "australiagst") echo " selected";
		echo ">".AUSTRALIANGST."</option><option value=\"safricanvat\"";
		if($salestaxtype == "safricanvat") echo " selected";
		echo ">".SAFRICANVAT."</option></select></div>";
		if ($salestaxtype != "cancstpst") {
			echo "
                    <div class=\"form-group\">
						<label for=\"nstoreshippingfromstate\">
                            ".STATETOCHARGETAXTO."
                        </label>
                        <select class=\"form-control\" name=\"ntaxstate\"><option value=\"0\""; if(!$taxstate) echo " selected"; echo ">".THEWORDNONE."</option>";
			if ($salestaxtype == "ussalestax") $states = $americanstates;
			else if ($salestaxtype == "euvat") unset($states);
			else if ($salestaxtype == "australiagst") $states = $australianstates;
			foreach ($states as $longstate => $shortstate) {
				echo "<option value=\"$shortstate\"";
				if ($shortstate == $taxstate) echo " selected";
				echo ">$longstate\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">
						<label for=\"nstoreshippingfromstate\">
                            ".EUVATORIGINCOUNTRY."
                        </label>
                        <select class=\"form-control\" name=\"nvatorigincountry\"><option  value=none>".CHOOSECOUNTRY;
			foreach ($ecmembers as $shortcountry) {
				echo "<option  value=$shortcountry";
				if ($shortcountry == $vatorigincountry) echo " selected";
				echo ">".$countries["$shortcountry"]."\n";
			}
			echo "</select></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SALESTAXPERCENTAGE1, "name" => "ntaxpercentage", "value" => $taxpercentage, "small" => TRUE, "suffix" => "%"))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SALESTAXPERCENTAGE2, "name" => "ntaxpercentage2", "value" => $taxpercentage2, "small" => TRUE, "suffix" => "%"))."</div>";
		} else echo $cantaxtable;
		if ($salestaxtype == "euvat") {
			echo "
                    <div class=\"form-group\">
                        <div class=\"checkbox\">
                            <label for=\"$name\">
                                <input type=\"checkbox\" name=\"nrequestvat\" id=\"nrequestvat\""; if ($requestvat) echo " checked"; echo " onChange=\"if(document.configurationform.nrequestvat.checked == true) document.configurationform.nrequestabn.checked = false;\">
                                ".REQUESTVATNUMBER."
                            </label>
                        </div>
                    </div>";
		}
		if ($salestaxtype == "australiagst") {
			echo "
                    <div class=\"form-group\">
                        <div class=\"checkbox\">
                            <label for=\"$name\">
                                <input type=\"checkbox\" name=\"nrequestabn\" id=\"nrequestabn\""; if ($requestabn) echo " checked"; echo " onChange=\"if(document.configurationform.nrequestabn.checked == true) document.configurationform.nrequestvat.checked = false;\">
                                ".REQUESTABNNUMBER."
                            </label>
                        </div>
                    </div>";
		}
		echo "
                    <div class=\"form-group\">".admin_checkbox(array("label" => SALESTAXONSHIPPING, "name" => "nshippingtax", "checked" => $shippingtax?TRUE:FALSE))."</div>";
		if ($salestaxtype != "cancstpst") {
			echo "
                    <div class=\"form-group\">
						<label for=\"nstoreshippingfromstate\">
                            ".INCLUDETAXINDISPLAYEDPRICE."
                        </label>
                        <select class=\"form-control\" name=\"ndisplaywithtax\"><option value=\"0\"";
			if ($displaywithtax == 0) echo " selected";
			echo ">".NO."</option><option value=\"1\"";
			if ($displaywithtax == 1) echo " selected";
			echo ">".ADDTOPRICE."</option><option value=\"2\"";
			if ($displaywithtax == 2) echo " selected";
			echo ">".INCLUDEDINLISTPRICE."</option></select>
			</div>
                    <div class=\"form-group\">
						<label for=\"nstoreshippingfromstate\">
                            ".INCLUDETAXINWHOLESALEPRICE."
                        </label>
                        <select class=\"form-control\" name=\"ndisplaywswithtax\"><option value=\"0\"";
			if ($displaywswithtax == 0) echo " selected";
			echo ">".NO."</option><option value=\"1\"";
			if ($displaywswithtax) echo " selected";
			echo ">".ADDTOPRICE."</option><option value=\"2\"";
			if ($displaywswithtax == 2) echo " selected";
			echo ">".INCLUDEDINLISTPRICE."</option></select>
			</div>";
		}
		echo "
				</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"cancel\" value=\"true\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
			</form>
		</div>
                    <div class=\"row\">
                        <div class=\"col-xs-12 text-center\">
                            <a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3\" align=\"absmiddle\" onclick=\"return overlib('$tip9');\" onmouseout=\"return nd();\"></a> <a href=\"editlocaltax.php\"><button type=\"button\" class=\"btn btn-success\" style=\"margin-right: 5px;\">".EDITLOCALTAXRATES."
                            </button></a>
                        </div>
                    </div>
        ";
	} else {
		if ($nshippingtax == "on") $nshippingtax = "1";
		else $nshippingtax = "0";
		if ($nrequestvat == "on") $nrequestvat = "1";
		else $nrequestvat = "0";
		if ($nrequestabn == "on") {
			$nrequestabn = "1";
			$nrequestvat = "0";
		} else $nrequestabn = "0";
		// Calculate Canada tax table...
		$nhstpercentage = "";
		foreach ($canprovinces as $longprovince => $shortprovince) {
			$thisgst = $_POST["gst$shortprovince"];
			$thispst = $_POST["pst$shortprovince"];
			$thispstcom = $_POST["pstcom$shortprovince"];
			if ($thispstcom == "on") $thispstcom = "1";
			else $thispstcom = "0";
			$nhstpercentage .= "$shortprovince:$thisgst:$thispst:$thispstcom|";
		}
		$nhstpercentage = substr($nhstpercentage,0,-1);
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nsalestaxtype' WHERE prefname='salestaxtype'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$ntaxstate' WHERE prefname='taxstate'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$ntaxpercentage' WHERE prefname='taxpercentage'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$ntaxpercentage2' WHERE prefname='taxpercentage2'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$npstpercentage' WHERE prefname='pstpercentage'");
		if (!empty($nhstpercentage)) @mysqli_query($db, "UPDATE preferences SET prefvalue='$nhstpercentage' WHERE prefname='hstpercentage'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nrequestvat' WHERE prefname='requestvat'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nrequestabn' WHERE prefname='requestabn'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nvatorigincountry' WHERE prefname='vatorigincountry'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$nshippingtax' WHERE prefname='shippingtax'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$ndisplaywithtax' WHERE prefname='displaywithtax'");
		@mysqli_query($db, "UPDATE preferences SET prefvalue='$ndisplaywswithtax' WHERE prefname='displaywswithtax'");
	}
}

if (!$changeconfig || $addcountry) {
	echo "</div></div></section>$footer";
} else {
	@mysqli_close($db);
	if ($update) header("Location: configure.php?param=payment");
	else if ($updatetaxes) header("Location: configure.php?param=taxes");
	else header("Location: settings.php$passworderrorstring");
}
?>