<?php
// AShop
// Copyright 2018 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "admin/config.inc.php";
include "admin/ashopfunc.inc.php";
include "admin/ashopconstants.inc.php";

// Check for GD...
$checkgd = TRUE;
if (empty($recaptchakey)) include "includes/captcha.inc.php";

// If GD is available generate random code for security check...
if ($gdversion == 2) {
	$activatesecuritycheck = TRUE;
	// Generate new random code...
	mt_srand ((double)microtime()*1000000);
	$maxrandom = 1000000;
	$random = mt_rand(0, $maxrandom);
} else $activatesecuritycheck = FALSE;

// Apply selected theme...
$buttonpath = "";
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";
if ($usethemebuttons == "true") $buttonpath = "themes/$ashoptheme/";
if ($lang && is_array($themelanguages)) {
	if (!in_array("$lang",$themelanguages)) unset($lang);
}

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "language/$lang/signupform.inc.php";

// Get member template path if no theme is used...
if ($shop && $shop != "1" && $usethemetemplates != "true" && file_exists("$ashoppath/members/files/$ashopuser/catalogue.html")) $templatepath = "/members/files/$ashopuser";

// Check if a mobile device is being used...
$device = ashop_mobile();

// Check Facebook login, if activated...
$facebookactivated = FALSE;
if (!empty($facebookappid) && !empty($facebooksecret)) {
	include "includes/facebook/facebook.php";
	$facebook = new Facebook(array('appId'  => $facebookappid,'secret' => $facebooksecret));
	$accesstoken = $facebook->getAccessToken();
	$facebookactivated = TRUE;
	$facebookuser = get_facebook_user($accesstoken);
	$firstname = $facebookuser->first_name;
	if (!empty($firstname)) {
		header("Location: signup.php");
		exit;
	}
}

// Show header using template signup.html...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/signup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/signup-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/signup.html");

echo "<div class=\"span5\">
	<p>".SIGNUPMESSAGE."$ashopname...</p>
	  <p>".ALREADYSIGNEDUP." <a href=\"login.php";
if (!empty($shop) && $shop > 1) echo "?shop=$shop";
echo "\">".LOGINHERE."</a></p>
	</div><div class=\"span7\">\n<h4 class=\"title\"><span class=\"text\"><strong>".REGISTER."</strong> ".FORM."</span></h4>";
if ($facebookactivated) {
	if (empty($firstname)) echo "<p><input type=\"image\" src=\"http://developers.facebook.com/images/devsite/login-button.png\" onclick=\"fblogin();\" /></p>";
	echo "
	<div id=\"fb-root\"></div>
	<script language=\"JavaScript\" type=\"text/javascript\">

	function fblogin() {
		FB.login(function(response) {
			if (response.authResponse) {
				document.location.href='$ashopurl/signup.php';
			} 
		}, {scope:'email'});
	}

	window.fbAsyncInit = function() {
		FB.init({appId: '$facebookappid', status: true, cookie: true, xfbml: true, oauth : true});
	};

	(function(d){
		var js, id = 'facebook-jssdk'; if (d.getElementById(id)) {return;}
		js = d.createElement('script'); js.id = id; js.async = true;
		js.src = \"//connect.facebook.net/en_US/all.js\";
		d.getElementsByTagName('head')[0].appendChild(js);
	}(document));

    </script>";
}
echo "<form action=\"signup.php\" method=\"post\" name=\"orderform\">
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".FIRSTNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"firstname\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".LASTNAME.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"lastname\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".EMAIL.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"email\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".PASSWORD.":</label>
                  <div class=\"controls\"> 
                    <input type=\"password\" name=\"password\" class=\"input-xlarge\">
                  </div>
              </div>
              <div class=\"control-group\"> 
                  <label class=\"control-label\">".CONFIRMPASSWORD.":</label>
                  <div class=\"controls\"> 
                    <input type=\"password\" name=\"confirmpassword\" class=\"input-xlarge\">
                  </div>
              </div>";
if ($activatesecuritycheck) {
	echo "<div class=\"control-group\"> 
                  <label class=\"control-label\">".SECURITYCODE.":</label>\n<div class=\"controls\"><img src=\"includes/captcha.inc.php?action=generatecode&amp;random=$random\" style=\"border: 1px solid #000;\" alt=\"Security Code\" title=\"Security Code\" /></div>
              </div>\n<div class=\"control-group\"><label class=\"control-label\">".TYPESECURITYCODE.":</label><div class=\"controls\"><input type=\"text\" name=\"securitycheck\" class=\"input-medium\"><input type=\"hidden\" name=\"random\" value=\"$random\" /></div>
              </div>";
} else if (!empty($recaptchakey)) {
    echo "
          <div class=\"g-recaptcha\" data-sitekey=\"$recaptchakey\"></div>";
}
echo "<p><input type=\"checkbox\" name=\"allowemail\"> ".YESEMAILME."</p>
	  <p><button class=\"btn btn-inverse\">".SUBMIT."</button></p>
";
if (!empty($shop) && $shop > 1) echo "<input type=\"hidden\" name=\"shop\" value=\"$shop\" />";
echo "
            </form>
    </div>";

// Show footer using template signup.html...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/signup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/signup-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/signup.html");
?>