<?php
// AShop
// Copyright 2002-2019 - All Rights Reserved Worldwide
// http://www.ashopsoftware.com
// This software is licensed per individual site.
// By installing or using this software, you agree to the licensing terms,
// which are located at http://www.ashopsoftware.com/license.htm
// Unauthorized use or distribution of this software 
// is a violation U.S. and international copyright laws.

$shop = 1;
include "../admin/checklicense.inc.php";

// Deactivate shopping mall, if requested...
if (!$enablemall) {
	header("Location: $ashopurl");
	exit;
}

// Check for GD...
$checkgd = TRUE;
if (empty($recaptchakey)) include "../includes/captcha.inc.php";

// If GD is available generate random code for security check...
if (function_exists('imagecreatefromjpeg') && function_exists('imagecreatefromgif') && function_exists('imagecreatetruecolor') && $gdversion == 2) {
	$activatesecuritycheck = TRUE;
	if ($action == "generatecode") {
		$checkcode = generatecode($random);
		$image = ImageCreateFromJPEG("$ashoppath/admin/images/codebg.jpg");
		$text_color = ImageColorAllocate($image, 80, 80, 80);
		Header("Content-type: image/jpeg");
		ImageString ($image, 5, 12, 2, $checkcode, $text_color);
		ImageJPEG($image, NULL, 75);
		ImageDestroy($image);
		exit;
	}
} else $activatesecuritycheck = FALSE;

// Validate input variables...
//if (!ashop_is_name($firstname)) $firstname = "";
//if (!ashop_is_name($lastname)) $lastname = "";
//if (!ashop_is_businessname($shopname)) $shopname = "";
if (!ashop_is_email(strtolower($email))) $email = "";
//if (!ashop_is_address($address)) $address = "";
//if (!ashop_is_state($state)) $state = "";
//if (!ashop_is_state($province)) $province = "";
//if (!ashop_is_zip($zip)) $zip = "";
//if (!ashop_is_address($city)) $city = "";
//if (!ashop_is_country($country)) $country = "";
//if (!ashop_is_phonenumber($phone)) $phone = "";
if (substr($url,0,7) != "http://" && substr($url,0,8) != "https://") $url = "http://".$url;
if (!ashop_is_url($url)) $url = "";
if (!ashop_is_captchacode($securitycheck)) $securitycheck = "";
if ($businesstype != "soleproprietor" && $businesstype != "corporation" && $businesstype != "nonprofit") $businesstype = "";

// Check for spam injection...
$shopuser = ashop_mailsafe($shopuser);
$shopuser = ashop_cleanfield($shopuser);
if (strlen($shopuser) < 2) $shopuser = "";
$shopname = ashop_mailsafe($shopname);
$shopname = ashop_cleanfield($shopname);
if (strlen($shopname) < 2) $shopname = "";
$businesstype = ashop_mailsafe($businesstype);
$businesstype = ashop_cleanfield($businesstype);
if (strlen($businesstype) < 2) $businesstype = "";
$firstname = ashop_mailsafe($firstname);
$firstname = ashop_cleanfield($firstname);
if (strlen($firstname) < 2) $firstname = "";
$lastname = ashop_mailsafe($lastname);
$lastname = ashop_cleanfield($lastname);
if (strlen($lastname) < 2) $lastname = "";
$email = ashop_mailsafe($email);
$email = ashop_cleanfield($email);
if (strlen($email) < 2) $email = "";
$address = ashop_mailsafe($address);
$address = ashop_cleanfield($address);
if (strlen($address) < 2) $address = "";
$state = ashop_mailsafe($state);
$state = ashop_cleanfield($state);
if (strlen($state) < 2) $state = "";
$province = ashop_mailsafe($province);
$province = ashop_cleanfield($province);
if (strlen($province) < 2) $province = "";
if (empty($state) && !empty($province)) $state = $province;
$zip = ashop_mailsafe($zip);
$zip = ashop_cleanfield($zip);
if (strlen($zip) < 2) $zip = "";
$city = ashop_mailsafe($city);
$city = ashop_cleanfield($city);
if (strlen($city) < 2) $city = "";
$country = ashop_mailsafe($country);
$country = ashop_cleanfield($country);
if (strlen($country) < 2) $country = "";
$phone = ashop_mailsafe($phone);
$phone = ashop_cleanfield($phone);
if (strlen($phone) < 2) $phone = "";

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none" && file_exists("$ashoppath/themes/$ashoptheme/theme.cfg.php")) include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/dm_signup.inc.php";

// Check if all fields were filled in...
if (($shopuser=="") || ($shopname=="") || ($businesstype=="") || ($firstname=="") || ($lastname=="") || ($email=="") || ($address=="") || ($state=="") || $state == "none" || ($zip=="") || ($city=="") || ($country=="") || $country == "none" || ($phone=="")) {
	if ($shopuser == "") $missingfield = USERNAME;
	else if ($shopname=="") $missingfield = NAMEOFSHOP;
	else if ($businesstype=="") $missingfield = BUSINESSTYPE;
	else if ($firstname=="") $missingfield = FIRSTNAME;
	else if ($lastname=="") $missingfield = LASTNAME;
	else if ($email=="") $missingfield = EMAIL;
	else if ($address=="") $missingfield = ADDRESS;
	else if ($state=="" || $state == "none") $missingfield = STATE;
	else if ($zip=="") $missingfield = ZIP;
	else if ($city=="") $missingfield = CITY;
	else if ($country=="" || $country == "none") $missingfield = COUNTRY;
	else if ($phone=="") $missingfield = PHONE;
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/membersignup.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
	<p class=\"text-center\">".YOUFORGOT." {$missingfield}.</p>
	<form id=\"tryagainform\" action=\"index.php\" method=\"post\"><p class=\"text-center\">\n";
	foreach ($_POST as $key=>$value) echo "<input type=\"hidden\" name=\"$key\" value=\"$value\" />\n";
	echo "<a href=\"javascript: return false;\" onclick=\"document.getElementById('tryagainform').submit();\">".TRYAGAIN."</a></p></form><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/membersignup.html");
    exit;
}

// Check if the username contains forbidden characters...
if (strstr($shopuser, chr(32)) || strstr($shopuser, chr(33)) || strstr($shopuser, chr(44)) || strstr($shopuser, chr(46)) || strstr($shopuser, chr(63)) || (strlen($shopuser) > 25)) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/membersignup.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
	<p class=\"text-center\">".THEUSERNAME."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/membersignup.html");
    exit;
}

// Check if the right security check code has been provided...
if (empty($recaptchakey) && $activatesecuritycheck && (!$securitycheck || $securitycheck != generatecode($random))) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/membersignup.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
	<p class=\"text-center\">".INCORRECTSECURITYCODE."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/membersignup.html");
    exit;
}

// Check if a correct ReCaptcha has been provided...
if (!empty($recaptchakey) && !ashop_recaptcha($_POST["g-recaptcha-response"])) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/membersignup.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
	<p class=\"text-center\">".INCORRECTSECURITYCODE."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/membersignup.html");
    exit;
}

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Initiate password hashing...
include "$ashoppath/includes/PasswordHash.php";
$passhasher = new PasswordHash(8, FALSE);

// Check member data...
$sql="SELECT username FROM user WHERE username='$shopuser'";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result) != 0) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/membersignup.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".SORRY."</h4>
	<p class=\"text-center\">".ALREADYINUSE."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/membersignup.html");
    exit;
}

$sql="SELECT email FROM user WHERE email='$email'";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result) != 0) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/membersignup.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".SORRY."</h4>
	<p class=\"text-center\">".ALREADYINUSE2."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/membersignup-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/membersignup.html");
    exit;
}

// Function for generating unique passwords...
function makePassword() {
	$alphaNum = array('2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z');
	srand ((double) microtime() * 1000000);
	$pwLength = "7"; // this sets the limit on how long the password is.
	for($j = 1; $j <=$pwLength; $j++) {
		$newPass .= $alphaNum[(rand(0,31))];
	}
	return ($newPass);
}

// Generate a password if needed...
if ($autoapprovemembers) {
	$password = makePassword();
	$passhash = $passhasher->HashPassword($password);
	$unique = 0;
	while (!$unique) {
		$sql="SELECT password FROM user WHERE password='$passhash'";
		$result2 = @mysqli_query($db, "$sql");
		if (@mysqli_num_rows($result2) == 0) $unique = 1;
		else {
			$password = makePassword();
			$passhash = $passhasher->HashPassword($password);
		}
	}
} else $password = "";

// Store shop user data...
$result = @mysqli_query($db, "INSERT INTO user (username, password, firstname, lastname, email, address, state, zip, city, country, phone, shopname, shopdescription, url, businesstype, paymentdetails, theme) VALUES ('$shopuser', '$passhash', '$firstname', '$lastname', '$email', '$address', '$state', '$zip', '$city', '$country', '$phone', '$shopname', '$description', '$url', '$businesstype', '$paymentdetails', 'default')");
$shopid = @mysqli_insert_id($db);
$date = date("d.m.Y");
@mysqli_query($db, "INSERT INTO visitcounter VALUES ('$shopid', '0', '$date', '$shopuser', '300', '-', '0', '0', '$date')");

// Store selected shop categories...
if (is_array($shopcategories)) foreach ($shopcategories as $key => $value) @mysqli_query($db, "INSERT INTO membercategory (userid, categoryid) VALUES ('$shopid', '$value')");

// Check for subscription fees...
$feesresult = @mysqli_query($db, "SELECT productid,price,recurringprice FROM product WHERE prodtype='mallfee'");
if (@mysqli_num_rows($feesresult)) {
	$feesrow = @mysqli_fetch_array($feesresult);
	$setupfee = $feesrow["price"];
	$monthlyfee = $feesrow["recurringprice"];
	$feesid = $feesrow["productid"];
	$idparamresult = @mysqli_query($db, "SELECT parameterid FROM parameters WHERE productid='$feesid'");
	$idparam = @mysqli_result($idparamresult,0,"parameterid");
	$autoapprovemembers = 0;
} else {
	$setupfee = "";
	$monthlyfee = "";
	$idparam = "";
}

// Close database...
@mysqli_close($db);

// Create new member shop redirector...
@mkdir("$ashoppath/members/files/$shopuser");
@chmod("$ashoppath/members/files/$shopuser", 0777);
$fp = @fopen ("$ashoppath/members/files/$shopuser/index.html", "w");

@fwrite($fp, "<html>\n");
@fwrite($fp, "<head>\n");
@fwrite($fp, "<title>Redirect</title>\n");
@fwrite($fp, "<meta http-equiv=\"Refresh\" content=\"0; URL=../../../index.php?shop=$shopid\">\n");
@fwrite($fp, "</head>\n");
@fwrite($fp, "\n");
@fwrite($fp, "<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
@fwrite($fp, "<center>\n");
@fwrite($fp, "  <p>&nbsp;</p>\n");
@fwrite($fp, "  <p><font face=\"Arial, Helvetica, sans-serif\"><b>If this page does not redirect...</b></font></p>");
@fwrite($fp, "  <p><b><font face=\"Arial, Helvetica, sans-serif\">click <a href=\"../../../index.php?shop=$shopid\">HERE</a></font></b></p>\n");
@fwrite($fp, "</center>\n");
@fwrite($fp, "</body></html>\n");
@fclose ($fp);

// Create new member products directory for ftp uploads...
@mkdir("$ashopspath/products/$shopuser");
@chmod("$ashopspath/products/$shopuser", 0777);

// Send message to inform webmaster about the new member...
$message="<html><head><title>Shopping Mall Seller Account Application</title></head><body><font face=\"$font\"><b>$shopuser</b> has applied for a shopping mall seller account.</font></body></html>";
$headers = "From: ".un_html($ashopname)."<$ashopemail>\nX-Sender: <$ashopemail>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$ashopemail>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";

@ashop_mail("$ashopemail","Shopping Mall Seller Account Application","$message","$headers");

// Send application confirmation to member...
if ($autoapprovemembers) {
	if (file_exists("$ashoppath/templates/messages/membersignupapproved-$lang.html")) $messagefile = "$ashoppath/templates/messages/membersignupapproved-$lang.html";
	else $messagefile = "$ashoppath/templates/messages/membersignupapproved.html";
} else {
	if (file_exists("$ashoppath/templates/messages/membersignupmessage-$lang.html")) $messagefile = "$ashoppath/templates/messages/membersignupmessage-$lang.html";
	else $messagefile = "$ashoppath/templates/messages/membersignupmessage.html";
}
$fp = fopen ("$messagefile","r");
if ($fp) {
	while (!feof ($fp)) $messagetemplate .= fgets($fp, 4096);
	fclose($fp);
} else {
	if ($autoapprovemembers) {
		$messagetemplate="<html><head><title>".THANKYOUFORJOINING." $ashopname!</title></head><body><font face=\"$font\"><p>".THANKYOUFORJOINING." $ashopname!</p><p>".YOURUSERNAMEIS." <b>$shopuser</b>".YOURPASSWORDIS." <b>$password</b>.<br>".YOUCANLOGIN." <a href=\"$ashopurl/admin/login.php\">$ashopurl/admin/login.php</a>.";
		if ($membershops) $messagetemplate .= "<br>".YOUSHOPISLOCATED." <a href=\"$ashopurl/index.php?shop=$userid\">$ashopurl/index.php?shop=$userid</a>";
		$messagetemplate .= "</p></font></body></html>";
	} else {
		$messagetemplate="<html><head><title>".THANKYOUFORJOINING." $ashopname!</title></head><body><font face=\"$font\"><p>".THANKYOUFORJOINING." $ashopname!</p><p>".YOURUSERNAMEIS." <b>$shopuser</b>".YOURPASSWORD."</p></font></body></html>";
	}
}
$message = str_replace("%ashopname%",$ashopname,$messagetemplate);
$message = str_replace("%ashopurl%",$ashopurl,$message);
$message = str_replace("%username%",$shopuser,$message);
$message = str_replace("%password%",$password,$message);
$message = str_replace("%shopname%",$shopname,$message);
$message = str_replace("%description%","$description",$message);
$message = str_replace("%firstname%",$firstname,$message);
$message = str_replace("%lastname%",$lastname,$message);
$message = str_replace("%email%",$email,$message);
$message = str_replace("%address%",$address,$message);
$message = str_replace("%state%",$state,$message);
$message = str_replace("%zip%",$zip,$message);
$message = str_replace("%city%",$city,$message);
$message = str_replace("%country%",$country,$message);
$message = str_replace("%phone%",$phone,$message);
$message = str_replace("%url%",$url,$message);
// Get current date and time...
$date = date("Y-m-d H:i:s", time()+$timezoneoffset);
$message = str_replace("%date%",$date,$message);

$headers = "From: ".un_html($ashopname)."<$ashopemail>\nX-Sender: <$ashopemail>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$ashopemail>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";
@ashop_mail("$email",un_html($ashopname)." ".SHOPPINGMALLAPPLICATION,"$message","$headers");

// If setup fee or monthly fee should be charged, redirect to payment...
if (!empty($setupfee) || !empty($monthlyfee)) {
	header("Location: ../buy.php?item=$feesid&quantity=1&attribute$idparam=$shopid&redirect=checkout.php");
	exit;
}

// Show header using template signup.html...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/membersignup-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/membersignup.html");

echo "<div class=\"span12\"><h4 class=\"text-center\">".YOURAPPLICATION." $ashopname ".HASBEENRECEIVED."</h4>";
if ($autoapprovemembers) echo "<p class=\"text-center\">".ACCOUNTISACTIVE."</p>";
else echo "<p class=\"text-center\">".WILLBEREVIEWED."</p>";
echo "
<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";

// Show footer using template signup.html...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/membersignup-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/membersignup-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/membersignup.html");
?>