<?php
// AShop
// Copyright 2016 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.
// --------------------------------------------------------------------
// Module: category.inc.php
// Description: displays the name of the current product category
// Input variables: cat = category ID

if (!$databaseserver || !$databaseuser) include "admin/config.inc.php";
if (!function_exists('ashop_mailsafe')) include "admin/ashopfunc.inc.php";

// Open database...
if (!is_resource($db) || get_resource_type($db) !== 'mysql link') {
	$errorcheck = ashop_opendatabase();
	if ($errorcheck) $error = $errorcheck;
}

	// Validate variables...
	if ($cat && !is_numeric($cat)) {
		$cat = stripslashes($cat);
		$cat = @mysqli_real_escape_string($db, $cat);
		$cat = strtolower($cat);
		$cat = str_replace("\'","",$cat);
		$cat = str_replace("\"","",$cat);
		$cat = str_replace("/","",$cat);
		$cat = str_replace("\n","",$cat);
		$cat = str_replace(";","",$cat);
		$cat = str_replace("select","",$cat);
		$cat = str_replace("insert","",$cat);
		$cat = str_replace("update","",$cat);
		$cat = str_replace("delete","",$cat);
		$cat = str_replace("create","",$cat);
		$cat = str_replace("modify","",$cat);
		$cat = str_replace("password","",$cat);
		$cat = str_replace("user","",$cat);
		$cat = str_replace("concat","",$cat);
		$cat = str_replace("from","",$cat);
		$cat = str_replace("username","",$cat);
		$cat = str_replace("<","",$cat);
		$cat = str_replace(">","",$cat);
		$findcatbyname = TRUE;
	} else $findcatbyname = FALSE;
	$checkexp = str_replace("|","",$exp);
	if (!is_numeric($checkexp)) unset($exp);

	// Select shop...
	if ((isset($_GET["shop"]) || isset($_POST["shop"]))) {
		if ($_GET["shop"]) $newshop = $_GET["shop"];
		if ($_POST["shop"]) $newshop = $_POST["shop"];
		unset($shop);
		$shop = $newshop;
	}
	if (!$shop) {
		$shop = "1";
		$shopurlstring = "";
	} else $shopurlstring = "&shop=$shop";

	if (!$membershops) $shopsearch = "%";
	else $shopsearch = $shop;

	// Apply selected theme...
	$buttonpath = "";
	$templatepath = "/templates";
	if ($ashoptheme && $ashoptheme != "none" && file_exists("$ashoppath/themes/$ashoptheme/theme.cfg.php")) include "themes/$ashoptheme/theme.cfg.php";
	if ($usethemebuttons == "true") $buttonpath = "themes/$ashoptheme/";
	if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";
	if ($lang && is_array($themelanguages)) {
		if (!in_array("$lang",$themelanguages)) unset($lang);
	}

	// Include language file...
	if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
	if (empty($searchstring)) include "language/$lang/catalogue.inc.php";
	else include "language/$lang/search.inc.php";

	// Get member template path if no theme is used...
	if ($shop && $shop != "1" && $usethemetemplates != "true" && file_exists("$ashoppath/members/$ashopuser/catalogue.html")) $templatepath = "/members/$ashopuser";

	// Search for category by name...
	if ($findcatbyname) {
		$result = @mysqli_query($db, "SELECT categoryid FROM category WHERE upper(name) LIKE '%".strtoupper($cat)."%'");
		if (@mysqli_num_rows($result)) {
			$cat = @mysqli_result($result,0,"categoryid");
		}
	}

	// Set the page title...
	if (!empty($cat) && is_numeric($cat)) {
		$sql="SELECT name, description FROM category WHERE categoryid = '$cat' AND (userid LIKE '$shop' OR memberclone='1')";
		$catresult = @mysqli_query($db, $sql);
		$categoryname = @mysqli_result($catresult, 0, "name");
		$categorydescr = @mysqli_result($catresult, 0, "description");
	}

if ($cat) {
	echo "<section class=\"header_text sub\">\n";
	if (file_exists("$ashoppath/catimg/$cat.png")) echo "<img class=\"pageBanner\" src=\"catimg/$cat.png\" alt=\"$categoryname\" >\n";
	echo "<h4><span>$categoryname</span></h4>\n</section>\n";

	//echo "<form name=\"sortbyform\" method=\"post\" action=\"\" style=\"margin-bottom: 0px;\"><select name=\"sortby\" class=\"ashopsortorderselector\" onchange=\"sortbyform.submit()\"><option value=\"default\">".SORTBY.":</option><option value=\"lowprice\""; if ($sortby == "lowprice") echo " selected"; echo ">".LOWESTPRICE."</option><option value=\"highprice\""; if ($sortby == "highprice") echo " selected"; echo ">".HIGHESTPRICE."</option><option value=\"name\""; if ($sortby == "name") echo " selected"; echo ">".NAME."</option></select></form></td></tr></table>";
} else if (!empty($searchstring)) {
	echo "<section class=\"header_text sub\">\n<h4><span>";
	if (isset($m) && $m == "1") echo $searchstring;
	else echo SEARCHRESULT;
	echo "</span></h4>\n</section>\n";
} else {
	echo "<section class=\"header_text sub\">\n";
	if (file_exists("$ashoppath/catimg/$cat.png")) echo "<img class=\"pageBanner\" src=\"catimg/$cat.png\" alt=\"$categoryname\" >\n";
	echo "<h4><span>$categoryname</span></h4>\n</section>\n";
}


// Close database...
if ($dbOpenedLocally) {
	@mysqli_close($db);
	$databaseserver = "";
	$databaseuser = "";
}
?>