<?php
// AShop
// Copyright 2014 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

if (!$databaseserver || !$databaseuser) include "admin/config.inc.php";
if (!function_exists('ashop_mailsafe')) include "admin/ashopfunc.inc.php";

// Open database...
if (!is_resource($db) || get_resource_type($db) !== 'mysql link') {
	$errorcheck = ashop_opendatabase();
	if ($errorcheck) $error = $errorcheck;
}

if (!isset($cat)) $cat = 0;
if ($cat && !is_numeric($cat)) $cat = 0;

$carouseldiv = "";
$result = @mysqli_query($db, "SELECT productid, name FROM product WHERE featured != '' AND featured IS NOT NULL order by featured");
$featurenumber = 0;
while ($row = @mysqli_fetch_array($result)) {
	$productid = $row["productid"];
	$name = $row["name"];
	$name = strip_tags($name);
	// Get product image info...
	$productimage = ashop_productimages($productid);
	if ($productimage["thumbnail"]) {
		$imagesize = getimagesize("$ashoppath/prodimg/$productid/{$productimage["thumbnail"]}");
        $imagepaddingv = 0;
        $imagepaddingh = 0;
		if ($imagesize[1] < $imagesize[0]) {
            $imagepaddingpixels = floor(($imagesize[0] - $imagesize[1])/2);
            $imagepaddingpercent = ($imagepaddingpixels/$imagesize[0])*100;
            $imagepaddingv = floor($imagepaddingpercent);
        } else if ($imagesize[0] < $imagesize[1]) {
            $imagepaddingpixels = floor(($imagesize[1] - $imagesize[0])/2);
            $imagepaddingpercent = ($imagepaddingpixels/$imagesize[1])*100;
            $imagepaddingh = floor($imagepaddingpercent);
        }
		if (empty($carouseldiv)) $carouseldiv = "<div id=\"myCarousel\" class=\"myCarousel carousel slide\"><div class=\"carousel-inner\"><div class=\"active item\"><ul class=\"thumbnails\">";
        else if ($featurenumber > 3) {
            $carouseldiv .= "</ul></div><div class=\"item\"><ul class=\"thumbnails\">";
            $featurenumber = 0;
        }
		$carouseldiv .= "
		<li class=\"span3\"><div class=\"product-box\"><p>";
        if ($imagepaddingv) $carouseldiv .= "<div style=\"padding-top: {$imagepaddingv}%; padding-bottom: {$imagepaddingv}%;\">";
        else if ($imagepaddingh) $carouseldiv .= "<div style=\"padding-left: {$imagepaddingh}%; padding-right: {$imagepaddingh}%;\">";
        $carouseldiv .= "<a href=\"index.php?product=$productid\"><img src=\"prodimg/$productid/{$productimage["thumbnail"]}\" alt=\"{$productid}\"></a>";
        if ($imagepaddingv || $imagepaddingh) $carouseldiv .= "</div>";
        $carouseldiv .= "</p><p><a href=\"index.php?product=$productid\">$name</a></p></div></li>";
        $featurenumber++;
	}
}
if (!empty($carouseldiv)) $carouseldiv .= "
</ul></div></div></div>";

echo $carouseldiv;
?>