<?php
// AShop
// Copyright 2016 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";
include "checklogin.inc.php";
include "../admin/ashopconstants.inc.php";

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_orderhistory.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get affiliate information from database...
$sql="SELECT * FROM affiliate WHERE sessionid='$affiliatesesid'";
$result = @mysqli_query($db, "$sql");

// Store affiliate information in variables...
$firstname = @mysqli_result($result, 0, "firstname");
$lastname = @mysqli_result($result, 0, "lastname");
$affiliateid = @mysqli_result($result, 0, "affiliateid");

// Get statistics from database...
$selectorderids = "	<p><table class=\"table table-striped\"><thead>
	<tr><th>".REFERENCE."</th><th>".DATETIME."</th><th>".AMOUNT."</th></tr></thead><tbody>";

$totalprovision = 0;
$totalourdebt = 0;
$sql="SELECT orders.date, orders.orderid, orders.invoiceid, orders.wholesale, orderaffiliate.* FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND orderaffiliate.orderid=orders.orderid AND orders.paid != '0' AND orders.paid != '' AND orders.paid IS NOT NULL ORDER BY orderaffiliate.orderid DESC";
$result = @mysqli_query($db, "$sql");
$order = @mysqli_num_rows($result);
if (@mysqli_num_rows($result) != 0) {
  for ($i = 0; $i < @mysqli_num_rows($result);$i++) {
	  $orderdate = @mysqli_result($result, $i, "date");
	  $orderid = @mysqli_result($result, $i, "orderid");
	  $invoiceid = @mysqli_result($result, $i, "invoiceid");
	  if (empty($invoiceid)) $invoiceid = $orderid;
	  $wholesale = @mysqli_result($result, $i, "wholesale");
	  $paid = @mysqli_result($result, $i, "paid");
	  $paymethod = @mysqli_result($result, $i, "paymethod");
	  $provision = @mysqli_result($result, $i, "commission");
	  $secondtier = @mysqli_result($result, $i, "secondtier");
	  $tierlevel = $secondtier+1;
	  if (!$paid) $ourdebt += $provision;

	  $selectorderids .= "<tr><td>";
	  if ($provision < 0) $selectorderids .= "Chargeback ";
	  $selectorderids .= "Order ID: $invoiceid";
	  if ($wholesale) $selectorderids .= " W";
	  if ($secondtier) $selectorderids .= ", ".TIER2." $tierlevel";
	  $selectorderids .= "</td><td>$orderdate</td><td>";
	  if ($provision < 0) $selectorderids .= "<font color=\"red\">- ".$currencysymbols[$ashopcurrency]["pre"].number_format(-$provision,2,'.','')." ".$currencysymbols[$ashopcurrency]["post"];
	  else $selectorderids .= $currencysymbols[$ashopcurrency]["pre"].number_format($provision,2,'.','')." ".$currencysymbols[$ashopcurrency]["post"];
	  if ($provision < 0) $selectorderids .= "</font>";
	  $selectorderids .= "</td></tr>";

	  if ($paid && $provision > 0) {
		  $chargebackresult = @mysqli_query($db, "SELECT orderid FROM orderaffiliate WHERE orderid='$orderid' AND commission<0 AND paid>0 AND paid IS NOT NULL");
		  if (!@mysqli_num_rows($chargebackresult)) {
			  $selectorderids .= "<tr><td>".PAIDBY." $paymethod</td><td>$paid</td><td>- ".$currencysymbols[$ashopcurrency]["pre"].number_format($provision,2,'.','')." ".$currencysymbols[$ashopcurrency]["post"]."</td></tr>";
		  }
	  }
  }
}
$selectorderids .= "<tr><td colspan=\"2\">".TOTALUNPAID.":</td><td>".$currencysymbols[$ashopcurrency]["pre"].number_format($ourdebt,2,'.','')." ".$currencysymbols[$ashopcurrency]["post"]."</td></tr></tbody></table>";

// Get number of unread PMs...
$sql="SELECT * FROM affiliatepm WHERE toaffiliateid='$affiliateid' AND (hasbeenread='' OR hasbeenread='0' OR hasbeenread IS NULL)";
$unreadresult = @mysqli_query($db, "$sql");
$unreadcount = @mysqli_num_rows($unreadresult);

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");

echo "<div class=\"span3 sidebar\">
<ul class=\"nav nav-sidebar\">
<li><a href=\"affiliate.php\">".STATISTICS."</a></li>
<li><a href=\"changeprofile.php\">".VIEWPROFILE."</a></li>
<li><a href=\"changepassword.php\">".CHANGEPASS."</a></li>";
if (file_exists("$ashoppath/customerparties.php") && $enablepartyplanner == "1") echo "<li><a href=\"parties.php\">".PARTIES."</a></li>";
echo "<li><a href=\"linkcodes.php\">".LINKCODES."</a></li>
<li class=\"active\"><a href=\"#\">".ORDERHISTORY."</a></li>
<li><a href=\"downline.php\">".DOWNLINE."</a></li>";
if ($activateleads) echo "<li><a href=\"leads.php\">".LEADS."</a></li>";
echo "<li><a href=\"inbox.php\">".INBOX;
if ($unreadcount) echo " ($unreadcount)";
echo "</a></li>
<li><a href=\"login.php?logout\">".LOGOUT."</a></li>
</ul></div>

<div class=\"span9\"><h4>".COMMISSIONHISTORY."</h4>$selectorderids\n</div>\n";

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");

// Close database...
@mysqli_close($db);
?>