<?php
// AShop
// Copyright 2016 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

@set_time_limit(0);
include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";
include "checklogin.inc.php";

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_downline.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get affiliate information from database...
$sql="SELECT * FROM affiliate WHERE sessionid='$affiliatesesid'";
$result = @mysqli_query($db, "$sql");

// Get the correct password for this affiliate...
$correctpasswd = @mysqli_result($result, 0, "password");

// Store affiliate information in variables...
$firstname = @mysqli_result($result, 0, "firstname");
$lastname = @mysqli_result($result, 0, "lastname");
$affiliateid = @mysqli_result($result, 0, "affiliateid");
$referredby = @mysqli_result($result, 0, "referedby");

// Get number of unread PMs...
$sql="SELECT * FROM affiliatepm WHERE toaffiliateid='$affiliateid' AND (hasbeenread='' OR hasbeenread='0' OR hasbeenread IS NULL)";
$unreadresult = @mysqli_query($db, "$sql");
$unreadcount = @mysqli_num_rows($unreadresult);

// Set current date and time...
$date = date("Y-m-d H:i:s", time()+$timezoneoffset);

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");

echo "<div class=\"span3 sidebar\">
<ul class=\"nav nav-sidebar\">
<li><a href=\"affiliate.php\">".STATISTICS."</a></li>
<li><a href=\"changeprofile.php\">".VIEWPROFILE."</a></li>
<li><a href=\"changepassword.php\">".CHANGEPASS."</a></li>";
if (file_exists("$ashoppath/customerparties.php") && $enablepartyplanner == "1") echo "<li><a href=\"parties.php\">".PARTIES."</a></li>";
echo "<li><a href=\"linkcodes.php\">".LINKCODES."</a></li>
<li><a href=\"orderhistory.php\">".ORDERHISTORY."</a></li>
<li class=\"active\"><a href=\"#\">".DOWNLINE."</a></li>";
if ($activateleads) echo "<li><a href=\"leads.php\">".LEADS."</a></li>";
echo "<li><a href=\"inbox.php\">".INBOX;
if ($unreadcount) echo " ($unreadcount)";
echo "</a></li>
<li><a href=\"login.php?logout\">".LOGOUT."</a></li>
</ul></div>
<div class=\"span9\">";

if (!empty($sendpmto) && !empty($pmsubject) && !empty($pmtext)) echo "<p>".MESSAGESENT."</p>";

if ($referredby) {
	// Get sponsor details..
	$sponsorresult = @mysqli_query($db, "SELECT * FROM affiliate WHERE affiliateid='$referredby'");
	$sponsorfirstname = @mysqli_result($sponsorresult,0,"firstname");
	$sponsorlastname = @mysqli_result($sponsorresult,0,"lastname");
	echo "<p>".SPONSOR.": $sponsorfirstname $sponsorlastname</p>";
	if (!empty($sendpmto) && $sendpmto == "sponsor" && !empty($pmsubject) && !empty($pmtext)) @mysqli_query($db, "INSERT INTO affiliatepm (toaffiliateid, fromaffiliateid, sentdate, subject, message) VALUES ('$referredby', '$affiliateid', '$date', '$pmsubject', '$pmtext')");
}
echo "<form action=\"downline.php\" method=\"post\">";
if ($referredby) echo "<div class=\"control-group\"> 
                  <label class=\"control-label\">".PMYOUR.":</label>
                  <div class=\"controls\"> 
                    <select name=\"sendpmto\" class=\"input-xlarge\"><option value=\"sponsor\">".PMSPONSOR."</option><option value=\"downline\">".DOWNLINE."</option></select></div>
              </div>";
else echo "<h4>".PMYOUR." ".DOWNLINE."<h4><input type=\"hidden\" name=\"sendpmto\" value=\"downline\">
";
echo "<div class=\"control-group\"> 
                  <label class=\"control-label\">".SUBJECT.":</label>
                  <div class=\"controls\"> 
                    <input type=\"text\" name=\"pmsubject\" class=\"input-xlarge\"></div>
              </div>
<div class=\"control-group\"> 
                  <label class=\"control-label\">".MESSAGE.":</label>
                  <div class=\"controls\"> 
                    <textarea name=\"pmtext\" rows=\"6\" class=\"input-xxlarge\"></textarea></div>
              </div>
<p><button class=\"btn btn-inverse\">".SENDPM."</button></p><br>
	";

// Get referral statistics...
function generatedownline($affiliateid,$tier=1) {
	global $db, $tier1referrals, $tier2referrals, $date;
	$tierresult = @mysqli_query($db, "SELECT * FROM affiliate WHERE referedby='$affiliateid' ORDER BY signedup DESC");
	$tierreferrals = @mysqli_num_rows($tierresult);
	if ($tier == 1) $tier1referrals += $tierreferrals;
	else if ($tier == 2) $tier2referrals += $tierreferrals;
	while ($tierrow = @mysqli_fetch_array($tierresult)) {
		$sql="SELECT orderid FROM orderaffiliate WHERE affiliateid='{$tierrow["affiliateid"]}' AND (secondtier='0' OR secondtier IS NULL)";
		$tierordersresult = @mysqli_query($db, "$sql");
		$tierorders = @mysqli_num_rows($tierordersresult);
		$tiersigneduparray = explode(" ",$tierrow["signedup"]);
		$tiersignedup = $tiersigneduparray[0];
		$tierlastdatearray = explode(" ",$tierrow["lastdate"]);
		$tierlastdate = $tierlastdatearray[0];
		$tieraffiliateid = $tierrow["affiliateid"];
		$displaytier = $tier+1;
		echo "<tr><td align=\"center\"><input type=\"checkbox\" name=\"affiliate$tieraffiliateid\"></td><td align=\"center\"><span class=\"ashopaffiliatetext3\">$displaytier</span></td><td><span class=\"ashopaffiliatetext3\">{$tierrow["firstname"]} {$tierrow["lastname"]}</span></td><td align=\"center\"><span class=\"ashopaffiliatetext3\">$tierorders</span></td><td><span class=\"ashopaffiliatetext3\">$tiersignedup</span></td><td><span class=\"ashopaffiliatetext3\">$tierlastdate</span></td></tr>";
		if (!empty($_POST["sendpmto"]) && $_POST["sendpmto"] == "downline" && !empty($_POST["pmsubject"]) && !empty($_POST["pmtext"]) && $_POST["affiliate$tieraffiliateid"] == "on") @mysqli_query($db, "INSERT INTO affiliatepm (toaffiliateid, fromaffiliateid, sentdate, subject, message) VALUES ('$tieraffiliateid', '$affiliateid', '$date', '{$_POST["pmsubject"]}', '{$_POST["pmtext"]}')");
		generatedownline($tieraffiliateid,$tier+1);
	}
}

echo "<h4>".DOWNLINE."</h4>
<p><table class=\"table table-striped\"><thead><tr><th>&nbsp;</th><th>".REFERRALLEVEL."</th><th>".NAME."</th><th>".ORDERS."</th><th>".REGISTRATIONDATE."</th><th>".ACTIVITY."</th></tr></thead><tbody>";

generatedownline($affiliateid);

echo "</tbody></table></form></div>";

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");

// Close database...
@mysqli_close($db);
?>