<?php
// AShop
// Copyright 2017 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";
include "ashopconstants.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/editproduct.inc.php";

// Get context help for this page...
$contexthelppage = "makehtml";
include "help.inc.php";
include "../language/$defaultlanguage/catalogue.inc.php";

// Check if this user should be allowed to access the page...
if ($userid != "1" && !$advancedmallmode) {
	header("Location: editcatalogue.php");
	exit;
}

// Get the productid...
if ($add) $productid = $add;

// Connect to database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Check if the page should be locked...
$lockcheck = @mysqli_query($db, "SELECT * FROM user WHERE userid='1' AND htmllock='1'");
if ($userid != "1" && @mysqli_num_rows($lockcheck)) {
	echo "$header
    <section class=\"content-header\"><h1>".PRODUCTDETAILS."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
              <div class=\"alert alert-danger alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".PAGEGENERATORINUSE."
              </div>
		</div>
        </section>$footer";
		exit;
}

// Only one product...
if ($productid) {
	// Get product details...
	$result = @mysqli_query($db, "SELECT * FROM product WHERE productid='$productid'");
	$row = @mysqli_fetch_array($result);
	$productname = $row["name"];
	$productdetailsurl = $row["detailsurl"];
	if (!$productdetailsurl && $seourls != "1") $productdetailsurl = "$ashopurl/index.php?product=$productid";
	$productmanufacturer = $row["manufacturer"];
	$copyof = $row["copyof"];
	$productlongdescription = $row["longdescription"];
	//if (!$productlongdescription) $productlongdescription = $row["description"];
	$productmetakeywords = $row["metakeywords"];
	$productmetadescription = $row["metadescription"];
	$productactivatereviews = $row["activatereviews"];
	if (!isset($productactivatereviews)) $productactivatereviews = 1;
	$productactivatesocnet = $row["activatesocialnetworking"];
	if (!isset($productactivatesocnet)) $productactivatesocnet = 1;
	$productactivaterecommended = $row["activaterecommended"];
	if (!isset($productactivaterecommended)) $productactivaterecommended = 1;
	$checkreviews = @mysqli_query($db, "SELECT * FROM reviews WHERE productid='$productid'");
	$numberofreviews = @mysqli_num_rows($checkreviews);
	if (!$generate && !$skip) {
		echo "$header";
	  if (is_dir("$ashoppath/admin/ckeditor") && file_exists("$ashoppath/admin/ckeditor/ckeditor.js")) {
		  echo "
<script type=\"text/javascript\" src=\"ckeditor/ckeditor.js\"></script>
";
	  }
	  echo "
    <section class=\"content-header\"><h1>".PRODUCTDETAILS."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"pagegenerator.php\" method=\"post\" name=\"productform\">
			    <div class=\"box-header with-border\">
				    <h3 class=\"box-title\"><a href=\"editcatalogue.php?pid=$productid&cat=$cat\">$productname</a></h3>
			    </div>";
		if ($msg) echo "
              <div class=\"alert alert-danger alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ERROR.": $msg
              </div>";
		if ($umsg) echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                $umsg
              </div>";
		if ($seourls == "1") echo "
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => SEOFRIENDLYFILENAME, "name" => "htmlfilename", "value" => "%productname%", "helpnumber" => 2, "helptext" => $tip2))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ORURL, "name" => "detailsurl", "value" => $productdetailsurl, "helpnumber" => 1, "helptext" => $tip1))."</div>";
		else {
			if ($add) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => DETAILSURL, "name" => "detailsurl", "value" => $productdetailsurl, "helpnumber" => 1, "helptext" => $tip1, "explanation" => OPTIONALURL))."</div>";
			else echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => DETAILSURL, "name" => "detailsurl", "value" => $productdetailsurl, "helpnumber" => 1, "helptext" => $tip1))."</div>";
		}
		echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => MANUFACTURER, "name" => "manufacturer", "value" => $productmanufacturer, "explanation" => OPTIONAL))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => EXTENDEDPRODUCTINFO, "name" => "longdescription", "value" => $productlongdescription, "helpnumber" => 6, "helptext" => $tip6, "WYSIWYG" => TRUE))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => METAKEYWORDS, "name" => "metakeywords", "value" => $productmetakeywords, "helpnumber" => 7, "helptext" => $tip11))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => METADESCRIPTION, "name" => "metadescription", "value" => $productmetadescription, "helpnumber" => 8, "helptext" => $tip12))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => ACTIVATEREVIEWS, "name" => "activatereviews", "checked" => $productactivatereviews != 0?TRUE:FALSE));
        if ($numberofreviews) echo " <a href=\"editreviews.php?productid=$productid&cat=$cat&resultpage=$resultpage&pid=$pid&search=$search\"><button type=\"button\" class=\"btn btn-primary\">".EDITREVIEWS."</button></a>";
        echo "</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => ACTIVATESOCNET, "name" => "activatesocnet", "checked" => $productactivatesocnet != 0?TRUE:FALSE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => ACTIVATERECOMMENDED, "name" => "activaterecommended", "checked" => $productactivaterecommended != 0?TRUE:FALSE))."</div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"skip\" value=\"".SKIP."\">".SKIP."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"generate\" value=\"".UPDATE."\">".UPDATE."</button>
				</div>
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
                <input type=\"hidden\" name=\"";
		if ($add) echo "add";
		else echo "productid";
		echo "\" value=\"$productid\">
             </form></div></div></section>
        ";
		echo $footer;
	} else {
		if (!$skip) {
			// Lock page generator if the user is admin...
			if ($userid == "1") @mysqli_query($db, "UPDATE user SET htmllock='1' WHERE userid='$userid'");

			// Generate filename...
			$thisfilename = str_replace("%productid%","$productid",$htmlfilename.".html");
			$safeproductname = str_replace(" ","_",$productname);
			$safeproductname = str_replace("!","",$safeproductname);
			$safeproductname = str_replace("#","",$safeproductname);
			$safeproductname = str_replace("?","",$safeproductname);
			$safeproductname = str_replace("&","",$safeproductname);
			$safeproductname = str_replace(":","",$safeproductname);
			$safeproductname = str_replace(";","",$safeproductname);
			$safeproductname = str_replace(",","",$safeproductname);
			$safeproductname = str_replace(".","",$safeproductname);
			$safeproductname = str_replace("/","",$safeproductname);
			$safeproductname = str_replace("\\","",$safeproductname);
			$safeproductname = str_replace("\"","",$safeproductname);
			$safeproductname = str_replace("'","",$safeproductname);
			$safeproductname = str_replace("+","",$safeproductname);
			$safeproductname = str_replace("-","",$safeproductname);
			$safeproductname = str_replace("(","",$safeproductname);
			$safeproductname = str_replace(")","",$safeproductname);
			$safeproductname = str_replace("%","",$safeproductname);
			$safeproductname = str_replace("__","_",$safeproductname);
			$safeproductname = str_replace("__","_",$safeproductname);
			$safeproductname = str_replace("","a",$safeproductname);
			$safeproductname = str_replace("","a",$safeproductname);
			$safeproductname = str_replace("","o",$safeproductname);
			$safeproductname = str_replace("","A",$safeproductname);
			$safeproductname = str_replace("","A",$safeproductname);
			$safeproductname = str_replace("","O",$safeproductname);
			$thisfilename = str_replace("%productname%","$safeproductname",$thisfilename);

			// Check that this filename has not already been used...
			if ($seourls == "1") {
				$newdetailsurl = "$ashopurl/catalog/$thisfilename";
				$newdetailsurl = str_replace("%","",$newdetailsurl);
				$newdetailsurl = str_replace(" ","",$newdetailsurl);
				$newdetailsurl = str_replace("&","",$newdetailsurl);
				$newdetailsurl = str_replace("?","",$newdetailsurl);
			}
			else $newdetailsurl = "$ashopurl/product.php?product=$productid";
			if (empty($detailsurl) || $detailsurl == "http://") {
				if (!empty($copyof) && is_numeric($copyof)) $productidcheckstring = "AND productid!='$copyof' AND (copyof!='$copyof' OR copyof IS NULL)";
				else $productidcheckstring = "AND productid!='$productid' AND (copyof!='$productid' OR copyof IS NULL)";
				$checkurlresult = @mysqli_query($db, "SELECT * FROM product WHERE detailsurl='$newdetailsurl' $productidcheckstring");
				$pagenumber = 1;
				while (@mysqli_num_rows($checkurlresult)) {
					$thisfilename = str_replace(".html","",$thisfilename);
					$newfilename = $thisfilename."_{$pagenumber}.html";
					$newdetailsurl = "$ashopurl/catalog/$newfilename";
					$newdetailsurl = str_replace("%","",$newdetailsurl);
					$newdetailsurl = str_replace(" ","",$newdetailsurl);
					$newdetailsurl = str_replace("&","",$newdetailsurl);
					$newdetailsurl = str_replace("?","",$newdetailsurl);
					$pagenumber++;
					$checkurlresult = @mysqli_query($db, "SELECT * FROM product WHERE detailsurl='$newdetailsurl' $productidcheckstring");
				}
			} else $newdetailsurl = $detailsurl;
			if (empty($add) && empty($detailsurl) && empty($htmlfilename)) $newdetailsurl = "";

			if ($activatereviews == "on") $activatereviews = 1;
			else $activatereviews = 0;
			if ($activatesocnet == "on") $activatesocnet = 1;
			else $activatesocnet = 0;
			if ($activaterecommended == "on") $activaterecommended = 1;
			else $activaterecommended = 0;

			// Avoid unwanted characters in the URL...
			$newdetailsurl = str_replace("","a",$newdetailsurl);
			$newdetailsurl = str_replace("","a",$newdetailsurl);
			$newdetailsurl = str_replace("","o",$newdetailsurl);
			$newdetailsurl = str_replace("","A",$newdetailsurl);
			$newdetailsurl = str_replace("","A",$newdetailsurl);
			$newdetailsurl = str_replace("","O",$newdetailsurl);
			$newdetailsurl = str_replace(" ","_",$newdetailsurl);

			@mysqli_query($db, "UPDATE product SET detailsurl='$newdetailsurl',manufacturer='$manufacturer',longdescription='$longdescription',metakeywords='$metakeywords',metadescription='$metadescription',activatereviews='$activatereviews',activatesocialnetworking='$activatesocnet',activaterecommended='$activaterecommended' WHERE productid='$productid'");

			// Unlock page generator if the user is admin...
			if ($userid == "1") @mysqli_query($db, "UPDATE user SET htmllock='0' WHERE userid='$userid'");
			
			if ($add) header("Location: editfiles.php?add=$productid&cat=$cat&resultpage=$resultpage&search=$search");
			else header("Location: editcatalogue.php?msg=htmldone&cat=$cat&pid=$pid&resultpage=$resultpage&search=$search");
			exit;
		} else {
			if ($add) header("Location: editfiles.php?add=$productid&cat=$cat&resultpage=$resultpage&search=$search");
			else header("Location: editcatalogue.php?cat=$cat&pid=$pid&resultpage=$resultpage&search=$search");
			exit;
		}
	}

// A whole category....
} else if ($categoryid) {
	// Check for Digital Mall...
	$result = @mysqli_query($db, "SELECT * FROM user");
	if (file_exists("$ashoppath/members/index.php") && @mysqli_num_rows($result)>1) $digitalmall = 1;
	else $digitalmall = 0;
	// Get category details...
	$result = @mysqli_query($db, "SELECT * FROM category WHERE categoryid='$categoryid'");
	$row = @mysqli_fetch_array($result);
	$categoryname = $row["name"];
	if (!$generate) {
		echo "$header
    <section class=\"content-header\"><h1>".GENERATESITEMAP.": <a href=\"editcatalogue.php?pid=$productid&cat=$cat\">$productname</a></h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"pagegenerator.php\" method=\"post\" name=\"productform\">
			    <div class=\"box-header with-border\">
				    <h3 class=\"box-title\">$categoryname</h3>
			    </div>
                <div class=\"box-body\">";
		if ($digitalmall) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => ONLYPRODUCTSFORMEMBER, "name" => "mallmember", "value" => 0, "helpnumber" => 6, "helptext" => $tip10, "small" => TRUE, "explanation" => LEAVEBLANKTOINCLUDEALLMEMBERS))."</div>";
		if ($seourls == "1") echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => FILENAME, "name" => "htmlfilename", "value" => "%productname%", "helpnumber" => 2, "helptext" => $tip8))."</div>";
		echo "
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"generate\" value=\"".MAKEPAGES."\">".MAKEPAGES."</button>
				</div>
                <input type=\"hidden\" name=\"categoryid\" value=\"$categoryid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
            </form>
		</div>
        </section>
        $footer";
	} else {
		// Lock page generator if the user is admin...
		if ($userid == "1") @mysqli_query($db, "UPDATE user SET htmllock='1' WHERE userid='$userid'");

		// Create directory and XML sitemap file...
		$safecategoryname = str_replace(" ","_",$categoryname);
		$safecategoryname = str_replace("!","",$safecategoryname);
		$safecategoryname = str_replace("#","",$safecategoryname);
		$safecategoryname = str_replace("?","",$safecategoryname);
		$safecategoryname = str_replace("&","",$safecategoryname);
		$safecategoryname = str_replace(":","",$safecategoryname);
		$safecategoryname = str_replace(";","",$safecategoryname);
		$safecategoryname = str_replace("/","",$safecategoryname);
		$safecategoryname = str_replace("\\","",$safecategoryname);
		$safecategoryname = str_replace("\"","",$safecategoryname);
		$safecategoryname = str_replace("'","",$safecategoryname);
		$safecategoryname = str_replace("(","",$safecategoryname);
		$safecategoryname = str_replace(")","",$safecategoryname);
		$safecategoryname = str_replace("%","",$safecategoryname);
		$safecategoryname = str_replace("__","_",$safecategoryname);
		$safecategoryname = str_replace("","a",$safecategoryname);
		$safecategoryname = str_replace("","a",$safecategoryname);
		$safecategoryname = str_replace("","o",$safecategoryname);
		$safecategoryname = str_replace("","A",$safecategoryname);
		$safecategoryname = str_replace("","A",$safecategoryname);
		$safecategoryname = str_replace("","O",$safecategoryname);
		@mkdir("$ashoppath/catalog/$safecategoryname");
		@chmod("$ashoppath/catalog/$safecategoryname", 0777);
		$sitemapfp = @fopen("$ashoppath/catalog/$safecategoryname/sitemap.xml","w");
		if ($sitemapfp) {
			fwrite($sitemapfp, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			fwrite($sitemapfp, "\n<urlset xmlns=\"http://www.google.com/schemas/sitemap/0.84\">");
		}
		$result = @mysqli_query($db, "SELECT productid FROM productcategory WHERE categoryid='$categoryid'");
		while ($row = @mysqli_fetch_array($result)) {
			$productid = $row["productid"];
			$copyof = $row["copyof"];
			// Get product details...
			$prodresult = @mysqli_query($db, "SELECT * FROM product WHERE productid='$productid' AND (prodtype!='content' OR prodtype IS NULL)");
			$prodrow = @mysqli_fetch_array($prodresult);
			$productowner = $prodrow["userid"];
			$productname = $prodrow["name"];

			if ($productname && (!$mallmember || $productowner == $mallmember)) {
				
				// Generate filename...
				$thisfilename = str_replace("%productid%","$productid",$htmlfilename.".html");
				$safeproductname = str_replace(" ","_",$productname);
				$safeproductname = str_replace(" ","_",$safeproductname);
				$safeproductname = str_replace("!","",$safeproductname);
				$safeproductname = str_replace("#","",$safeproductname);
				$safeproductname = str_replace("?","",$safeproductname);
				$safeproductname = str_replace("&","",$safeproductname);
				$safeproductname = str_replace(":","",$safeproductname);
				$safeproductname = str_replace(";","",$safeproductname);
				$safeproductname = str_replace(",","",$safeproductname);
				$safeproductname = str_replace(".","",$safeproductname);
				$safeproductname = str_replace("/","",$safeproductname);
				$safeproductname = str_replace("\\","",$safeproductname);
				$safeproductname = str_replace("\"","",$safeproductname);
				$safeproductname = str_replace("'","",$safeproductname);
				$safeproductname = str_replace("+","",$safeproductname);
				$safeproductname = str_replace("-","",$safeproductname);
				$safeproductname = str_replace("(","",$safeproductname);
				$safeproductname = str_replace("%","",$safeproductname);
				$safeproductname = str_replace(")","",$safeproductname);
				$safeproductname = str_replace("__","_",$safeproductname);
				$safeproductname = str_replace("__","_",$safeproductname);
				$safeproductname = str_replace("","a",$safeproductname);
				$safeproductname = str_replace("","a",$safeproductname);
				$safeproductname = str_replace("","o",$safeproductname);
				$safeproductname = str_replace("","A",$safeproductname);
				$safeproductname = str_replace("","A",$safeproductname);
				$safeproductname = str_replace("","O",$safeproductname);
				$thisfilename = str_replace("%productname%","$safeproductname",$thisfilename);

				// Check that this filename has not already been used...
				if ($seourls == "1") {
					$newdetailsurl = "$ashopurl/catalog/$thisfilename";
					$newdetailsurl = str_replace("%","",$newdetailsurl);
					$newdetailsurl = str_replace(" ","",$newdetailsurl);
					$newdetailsurl = str_replace("&","",$newdetailsurl);
					$newdetailsurl = str_replace("?","",$newdetailsurl);
				} else $newdetailsurl = "$ashopurl/product.php?product=$productid";
				if (!empty($copyof) && is_numeric($copyof)) $productidcheckstring = "AND productid!='$copyof' AND (copyof!='$copyof' OR copyof IS NULL)";
				else $productidcheckstring = "AND productid!='$productid' AND (copyof!='$productid' OR copyof IS NULL)";
				$checkurlresult = @mysqli_query($db, "SELECT * FROM product WHERE detailsurl='$newdetailsurl' $productidcheckstring");
				$pagenumber = 1;
				while (@mysqli_num_rows($checkurlresult)) {
					$thisfilename = str_replace(".html","",$thisfilename);
					$newfilename = $thisfilename."_{$pagenumber}.html";
					$newdetailsurl = "$ashopurl/catalog/$newfilename";
					$newdetailsurl = str_replace("%","",$newdetailsurl);
					$newdetailsurl = str_replace(" ","",$newdetailsurl);
					$newdetailsurl = str_replace("&","",$newdetailsurl);
					$newdetailsurl = str_replace("?","",$newdetailsurl);
					$pagenumber++;
					$checkurlresult = @mysqli_query($db, "SELECT * FROM product WHERE detailsurl='$newdetailsurl' $productidcheckstring");
				}		

				@mysqli_query($db, "UPDATE product SET detailsurl='$newdetailsurl', activatereviews='1',activatesocialnetworking='1' WHERE productid='$productid'");

				// Add to sitemap file...
				if ($sitemapfp) {
					fwrite($sitemapfp, "\n\t<url>");
					fwrite($sitemapfp, "\n\t\t<loc>$newdetailsurl</loc>");
					fwrite($sitemapfp, "\n\t</url>");
				}
			}
		}
		// Write end of sitemap file...
		if ($sitemapfp) {
			fwrite($sitemapfp, "\n</urlset>");
			fclose($sitemapfp);
			@chmod("$ashoppath/catalog/$safecategoryname/sitemap.xml", 0777);
		}

		// Index all category sitemaps...
		$sitemapindexfp = @fopen("$ashoppath/catalog/sitemap_index.xml","w");
		if ($sitemapindexfp) {
			fwrite($sitemapindexfp, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			fwrite($sitemapindexfp, "\n<sitemapindex xmlns=\"http://www.google.com/schemas/sitemap/0.84\">");
			$findfile = opendir("$ashoppath/catalog");
			while ($foundfile = readdir($findfile)) {
				if($foundfile && is_dir("$ashoppath/catalog/$foundfile") && $foundfile != "." && $foundfile != ".." && !strstr($foundfile, "CVS") && substr($foundfile1, 0, 1) != "_") {
					fwrite($sitemapindexfp, "\n\t<sitemap>");
					fwrite($sitemapindexfp, "\n\t\t<loc>$ashopurl/catalog/$foundfile/sitemap.xml</loc>");
					fwrite($sitemapindexfp, "\n\t</sitemap>");
				}
			}
			fwrite($sitemapindexfp, "\n</sitemapindex>");
			fclose($sitemapindexfp);
			@chmod("$ashoppath/catalog/$safecategoryname/sitemap_index.xml", 0777);
		}

		// Unlock page generator if the user is admin...
		if ($userid == "1") @mysqli_query($db, "UPDATE user SET htmllock='0' WHERE userid='$userid'");

		header("Location: editcatalogue.php?msg=htmldone&cat=$categoryid");
		exit;
	}
}
?>