<?php
// AShop
// Copyright 2002-2017 - All Rights Reserved Worldwide
// http://www.ashopsoftware.com
// This software is licensed per individual site.
// By installing or using this software, you agree to the licensing terms,
// which are located at http://www.ashopsoftware.com/license.htm
// Unauthorized use or distribution of this software 
// is a violation U.S. and international copyright laws.

include "checklicense.inc.php";
include "ashopconstants.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/members.inc.php";
// Get context help for this page...
$contexthelppage = "memberstats";
include "help.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

echo "$header
    <section class=\"content-header\"><h1>".STATISTICSANDPAYMENT." <a href=\"$help1\" target=\"_blank\"><img src=\"images/icon_helpsm.gif\" width=\"15\" height=\"15\" border=\"0\"></a></h1></section>
    <section class=\"content\">
		<div class=\"row\">
        <div class=\"col-xs-12\">
          <div class=\"box\">
            <div class=\"box-body\">
            <div class=\"row\">
                <form class=\"form-horizontal\" action=\"memberstats.php?resultpage=$resultpage&admindisplayitems=$admindisplayitems\" method=\"post\" name=\"memberfilterform\">                     <div class=\"col-md-4\">
                        <div class=\"form-group\">
                            <label for=\"namefilter\" class=\"col-sm-4 control-label\">".FILTERBYNAME."</label>
                            <div class=\"col-sm-8\"><input class=\"form-control\" type=\"text\" name=\"namefilter\" value=\"$namefilter\" size=\"10\"></div>
                        </div>
                   </div>
                   <div class=\"col-md-2\">
                        <button type=\"submit\" class=\"btn btn-primary\" value=\"".FILTER."\">".FILTER."</button>
                   </div>
                </form>
            </div>
              <table id=\"affiliates\" class=\"table table-bordered\">
                <thead><tr>
                    <th>".IDSHOP."</th><th>".ORDERS."</th><th>".EARNED."</th><th>".UNPAID."</th><th>".ACTION."</th></tr>
                </thead>
                <tbody>";

// Reset statistics...
$totalclicks = 0;
$totalorders = 0;
$totalprovision = 0;
$totalourdebt = 0;

// Get member information from database...
$sql="SELECT * FROM user WHERE shopname IS NOT NULL AND username != 'ashopadmin' AND email IS NOT NULL";
if ($namefilter) $sql .= " AND shopname  LIKE '%$namefilter%'";
$sql .=" ORDER BY userid";
$result = @mysqli_query($db, "$sql");
$numberofrows = intval(@mysqli_num_rows($result));
if (!$admindisplayitems) {
	if ($c_admindisplayitems) $admindisplayitems = $c_admindisplayitems;
	else $admindisplayitems = 10;
}
$numberofpages = ceil($numberofrows/$admindisplayitems);
if ($resultpage > 1) $startrow = (intval($resultpage)-1) * $admindisplayitems;
else {
	$resultpage = 1;
	$startrow = 0;
}
$startpage = $resultpage - 9;
if ($numberofpages - $resultpage < 10) {
	$pagesleft = $numberofpages - $resultpage;
	$startpage = $startpage - (10 - $pagesleft);
}
if ($startpage < 1) $startpage = 1;
$stoprow = $startrow + $admindisplayitems;
@mysqli_data_seek($result, $startrow);
$thisrow = $startrow;
while (($row = @mysqli_fetch_array($result)) && ($thisrow < $stoprow)) {
	$thisrow++;
	$commission = 0;
	$provision = 0;
	$ourdebt = 0;
	$totalcommission = 0;
    $shopname = $row["shopname"];
	$commissionlevel = $row["commissionlevel"];
	if (!$commissionlevel) $commissionlevel = $memberpercent;
	$email = $row["email"];
    $memberid = $row["userid"];
	$ordersresult = @mysqli_query($db, "SELECT * FROM memberorders WHERE userid='$memberid' AND date!='' AND paid!=''");
	$orders = @mysqli_num_rows($ordersresult);
	$totalorders += $orders;
	if (@mysqli_num_rows($ordersresult) != 0) {
		for ($j = 0; $j < @mysqli_num_rows($ordersresult);$j++) {
			$price = @mysqli_result($ordersresult, $j, "price");
			$paidtoshop = @mysqli_result($ordersresult, $j, "paidtoshop");
			//$affiliatecommission = @mysqli_result($ordersresult, $j, "affiliatecommission");
			$baseprice = $price; // - $affiliatecommission;
			$commission = $baseprice * ($commissionlevel/100);
			$commission += $shipping + $tax + $gst + $pst;
			$provision += $commission;
			if (!$paidtoshop) $ourdebt += $commission;
		}
	}
	echo "<tr><td>$memberid, <a href=\"editmember.php?memberid=$memberid&fromstats=True\">$shopname</a></td><td>$orders</td><td>".$currencysymbols[$ashopcurrency]["pre"].number_format($provision,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</td><td>";
	if ($ourdebt) echo $currencysymbols[$ashopcurrency]["pre"].number_format($ourdebt,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"];
	echo "</td><td>";
	if ($ourdebt) echo "<a href=\"paymember.php?memberid=$memberid\"><img src=\"images/icon_pay.gif\" alt=\"".PAYMEMBER." $memberid.\" title=\"".PAYMEMBER." $memberid.\" border=\"0\"></a>&nbsp;";
	else echo "<img src=\"images/spacer.gif\" width=\"15\" border=\"0\"></a>&nbsp;";
	echo "<a href=\"editmember.php?memberid=$memberid\"><img src=\"images/icon_profile.gif\" alt=\"".PROFILEFOR." $memberid\" title=\"".PROFILEFOR." $memberid\" border=\"0\"></a>&nbsp;<a href=\"salesreport.php?memberid=$memberid&generate=true&reporttype=paid\"><img src=\"images/icon_history.gif\" alt=\"".SALESHISTORYFOR." $memberid\" title=\"".SALESHISTORYFOR." $memberid\" border=\"0\"></a>&nbsp;<a href=\"editmember.php?memberid=$memberid&remove=True&fromstats=True\"><img src=\"images/icon_trash.gif\" alt=\"".DELETEMEMBER." $memberid ".FROMDB."\" title=\"".DELETEMEMBER." $memberid ".FROMDB."\" border=\"0\"></a></td></tr>";
	$totalprovision += $provision;
	$totalourdebt += $ourdebt;
}

echo "<tr><th>".TOTALS." </th><th>$totalorders</th><th> ".$currencysymbols[$ashopcurrency]["pre"].number_format($totalprovision,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th> ".$currencysymbols[$ashopcurrency]["pre"].number_format($totalourdebt,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;</th></tr></tbody></table></div></div>";

if ($numberofrows > 5) {
	echo "
        <div class=\"row\">
        <div class=\"col-md-4\"></div>
        <div class=\"col-md-4\">
        <nav aria-label=\"".PAGE."\">
            <ul class=\"pagination text-center\">";
	if ($numberofpages > 1) {
		if ($resultpage > 1) {
			$previouspage = $resultpage-1;
			echo "<li class=\"page-item\"><a class=\"page-link\" href=\"memberstats.php?resultpage=$previouspage&admindisplayitems=$admindisplayitems&namefilter=$namefilter\">".PREVIOUS."</a></li>";
		}
		$page = 1;
		for ($i = $startpage; $i <= $numberofpages; $i++) {
			if ($page > 20) break;
			if ($i != $resultpage) echo "<li class=\"page-item\"><a class=\"page-link\" href=\"memberstats.php?resultpage=$i&admindisplayitems=$admindisplayitems&namefilter=$namefilter\">";
			echo "$i";
			if ($i != $resultpage) echo "</a></li>";
			$page++;
		}
		if ($resultpage < $numberofpages) {
			$nextpage = $resultpage+1;
			echo "<li class=\"page-item\"><a class=\"page-link\" href=\"memberstats.php?resultpage=$nextpage&admindisplayitems=$admindisplayitems&namefilter=$namefilter\">".NEXTPAGE."</a></li>";
		}
	}
    echo "</ul>
    </nav>
    <div class=\"form-group\"><label for=\"admindisplayitems\" class=\"col-sm-2 control-label\">".DISPLAY.":</label><div class=\"col-sm-10\"><select name=\"admindisplayitems\" id=\"admindisplayitems\" class=\"form-control\" onChange=\"document.location.href='memberstats.php?resultpage=$resultpage&namefilter=$namefilter&admindisplayitems='+admindisplayitems.value;\"><option value=\"$numberofrows\">".SELECT."</option>
		<option value=\"5\"";
		if ($c_admindisplayitems == "5") echo " selected";
		echo ">5</option><option value=\"10\"";
		if ($c_admindisplayitems == "10") echo " selected";
		echo ">10</option><option value=\"20\"";
		if ($c_admindisplayitems == "20") echo " selected";
		echo ">20</option><option value=\"40\"";
		if ($c_admindisplayitems == "40") echo " selected";
		echo ">40</option><option value=\"$numberofrows\"";
		if ($c_admindisplayitems == "$numberofrows") echo " selected";
		echo ">".ALL."</option></select><p class=\"help-block\">".MEMBERS2."</p></div></div>
	";
}
echo "</div></div></section>$footer";
?>