<?php
// AShop
// Copyright 2017 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/customers.inc.php";
include "ashopconstants.inc.php";
include "customers.inc.php";

// Validate variables...
if (empty($customerid) || !is_numeric($customerid)) {
	header("Location: salesadmin.php");
	exit;
}

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Check if this is a wholesale customer...
$sql="SELECT * FROM customer WHERE customerid='$customerid'";
$result = @mysqli_query($db, "$sql");
$checkallowemail = @mysqli_result($result,0,"allowemail");
$level = @mysqli_result($result,0,"level");

// Check if the current user should have access to this profile...
if ($userid != "1") {
	if (!$dmshowcustomers) {
		header("Location: index.php");
		exit;
	}
	$result = @mysqli_query($db, "SELECT * FROM orders WHERE customerid='$customerid' AND userid LIKE '%|$userid|%'");
	if (!@mysqli_num_rows($result)) {
		header("Location: index.php");
		exit;
	}
}

if ($remove && $customerid) {
	if ($yes) {
		if ($userid != "1") {
			@mysqli_query($db, "DELETE FROM memberorders WHERE customerid='$customerid' AND userid='$userid'");
			$result = @mysqli_query($db, "SELECT * FROM memberorders WHERE customerid='$customerid'");
			if (!@mysqli_num_rows($result)) $removeall = true;
			else $removeall = false;
		}
		if ($userid == "1" || $removeall) {
			$sql="DELETE FROM customer WHERE customerid=$customerid";
			$result = @mysqli_query($db, $sql);
			$sql="SELECT * FROM orders WHERE customerid=$customerid";
			$result = @mysqli_query($db, $sql);
			for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
				$orderid = @mysqli_result($result,$i,"orderid");
				$sql="DELETE FROM orderaffiliate WHERE orderid='$orderid'";
				$result2 = @mysqli_query($db, $sql);
				$sql="DELETE FROM pendingorderaff WHERE orderid='$orderid'";
				$result2 = @mysqli_query($db, $sql);
			}
			$sql="DELETE FROM orders WHERE customerid=$customerid";
			$result = @mysqli_query($db, $sql);
			$sql="DELETE FROM memberorders WHERE customerid=$customerid";
			$result = @mysqli_query($db, $sql);
			$sql="DELETE FROM shipping WHERE customerid=$customerid";
			$result = @mysqli_query($db, $sql);
		}
		header("Location: salesadmin.php");
    }
	elseif ($no) header("Location: salesadmin.php");
	else {
		$sql="SELECT firstname, lastname FROM customer WHERE customerid=$customerid";
		$result = @mysqli_query($db, $sql);
		$firstname = @mysqli_result($result,0,"firstname");
		$lastname = @mysqli_result($result,0,"lastname");
		echo "$header
    <section class=\"content-header\"><h1>".REMOVECUSTOMER."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"editcustomer.php\" method=\"post\">
                <div class=\"box-body\">
                    <div class=\"alert alert-danger\">
                        <h4><i class=\"icon fa fa-ban\"></i> ".AREYOUSURE." $customerid, $firstname $lastname?</h4>
                    </div>
                </div>
				<div class=\"box-footer\">
					<button type=\"button\" class=\"btn btn-default\" name=\"no\" value=\"".NO."\" onClick=\"javascript:history.back()\">".NO."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"yes\" value=\"".YES."\">".YES."</button>
				</div>
                <input type=\"hidden\" name=\"customerid\" value=\"$customerid\">
                <input type=\"hidden\" name=\"remove\" value=\"True\">";

                if ($fromstats) echo "<input type=\"hidden\" name=\"fromstats\" value=\"True\">";

                echo "
             </form></div></div></div></section>$footer";
		exit;
	}
} 

// Store updated data...
if ($update || $newlevel) {
	// Avoid duplicate email addresses...
	$result = @mysqli_query($db, "SELECT * FROM customer WHERE email='$email' AND customerid!='$customerid'");
	if (@mysqli_num_rows($result)) $errormsg = EMAILINUSE;
	else {
		if ($allowemail == "on") $allowemail = 1;
		else $allowemail = 0;
		if ($affiliateid == "0") $affiliateid = "";

        if ($newlevel == "off") $newlevel = ", level='0'";
        else if ($newlevel == 1) $newlevel = ", level='1'";
        else $newlevel = "";

		// Convert money format...
		$virtualcash = str_replace($thousandchar,"",$virtualcash);
		$virtualcash = str_replace($decimalchar,".",$virtualcash);
		if (!empty($addvirtualcash)) {
			$addvirtualcash = str_replace($thousandchar,"",$addvirtualcash);
			$addvirtualcash = str_replace($decimalchar,".",$addvirtualcash);
			$virtualcash += $addvirtualcash;
		}
		// Encrypt password if encryption key is available...
		$password = trim($password);
		if (!empty($customerencryptionkey)) $password = ashop_encrypt($password, $customerencryptionkey);
		$sql="UPDATE customer SET username='$nusername', password='$password', businessname='$shippingbusiness', businesstype='$businesstype', url='$url', firstname='$firstname', lastname='$lastname', email='$email', address='$address', state='$state', zip='$zip', city='$city', country='$country', phone='$phone', allowemail='$allowemail', extrainfo='$extrainfo', affiliateid='$affiliateid'$newlevel, virtualcash='$virtualcash' WHERE customerid='$customerid'";
		$result = @mysqli_query($db, "$sql");

		$sql="UPDATE shipping SET shippingbusiness='$shippingbusiness', shippingfirstname='$shippingfirstname', shippinglastname='$shippinglastname', shippingaddress='$shippingaddress', shippingaddress2='$shippingaddress2', shippingzip='$shippingzip', shippingcity='$shippingcity', shippingstate='$shippingstate', shippingcountry='$shippingcountry', vat='$vat' WHERE customerid=$customerid";
		$result = mysqli_query($db, "$sql");

		if (!empty($auctionbids) && is_numeric($auctionbids) && $auctionbids > 0) {
			$sql="SELECT bidderid FROM pricebidder WHERE customerid='$customerid'";
			$result = @mysqli_query($db, "$sql");
			if (@mysqli_num_rows($result)) {
				$bidderid = @mysqli_result($result,0,"bidderid");
				@mysqli_query($db, "UPDATE pricebidder SET numberofbids='$auctionbids' WHERE bidderid='$bidderid'");
			} else @mysqli_query($db, "INSERT INTO pricebidder (numberofbids, customerid) VALUES ('$auctionbids', '$customerid')");
		}

		header("Location: salesadmin.php"); 
		exit;
	}
}

// Get customer information from database...
$sql="SELECT * FROM customer WHERE customerid='$customerid'";
$result = @mysqli_query($db, "$sql");
$nusername = @mysqli_result($result, 0, "username");
$password = @mysqli_result($result, 0, "password");
$shippingbusiness = @mysqli_result($result, 0, "businessname");
$businesstype = @mysqli_result($result, 0, "businesstype");
$firstname = @mysqli_result($result, 0, "firstname");
$lastname = @mysqli_result($result, 0, "lastname");
$email = @mysqli_result($result, 0, "email");
$allowemail = @mysqli_result($result, 0, "allowemail");
$address = @mysqli_result($result, 0, "address");
$state = @mysqli_result($result, 0, "state");
$zip = @mysqli_result($result, 0, "zip");
$city = @mysqli_result($result, 0, "city");
$country = @mysqli_result($result, 0, "country");
$phone = @mysqli_result($result, 0, "phone");
$url = @mysqli_result($result, 0, "url");
$extrainfo = @mysqli_result($result, 0, "extrainfo");
$affiliateid = @mysqli_result($result, 0, "affiliateid");
$level = @mysqli_result($result, 0, "level");
$virtualcash = @mysqli_result($result, 0, "virtualcash");

// Decrypt password if encryption key is available...
if (!empty($password) && !empty($customerencryptionkey)) $password = ashop_decrypt($password, $customerencryptionkey);

if ($affiliateid) {
	$result = @mysqli_query($db, "SELECT firstname, lastname FROM affiliate WHERE affiliateid='$affiliateid'");
	$affiliatefirstname = @mysqli_result($result,0,"firstname");
	$affiliatelastname = @mysqli_result($result,0,"lastname");
}

$sql="SELECT * FROM shipping WHERE customerid='$customerid'";
$result = @mysqli_query($db, "$sql");
if (empty($shippingbusiness)) $shippingbusiness = @mysqli_result($result, 0, "shippingbusiness");
$shippingfirstname = @mysqli_result($result, 0, "shippingfirstname");
$shippinglastname = @mysqli_result($result, 0, "shippinglastname");
$shippingaddress = @mysqli_result($result, 0, "shippingaddress");
$shippingaddress2 = @mysqli_result($result, 0, "shippingaddress2");
$shippingzip = @mysqli_result($result, 0, "shippingzip");
$shippingcity = @mysqli_result($result, 0, "shippingcity");
$shippingstate = @mysqli_result($result, 0, "shippingstate");
$vat = @mysqli_result($result, 0, "vat");
$shippingcountry = @mysqli_result($result, 0, "shippingcountry");
$shippingphone = @mysqli_result($result, 0, "shippingphone");
if (empty($phone)) $phone = $shippingphone;

$sql="SELECT bidderid FROM pricebidder WHERE customerid='$customerid'";
$result = @mysqli_query($db, "$sql");
$activatebids = @mysqli_num_rows($result);

if ($activatebids) {
	$sql="SELECT numberofbids FROM pricebidder WHERE customerid='$customerid'";
	$result = @mysqli_query($db, "$sql");
	$auctionbids = @mysqli_result($result, 0, "numberofbids");
}

// Get last known IP number...
$sql="SELECT ip FROM orders WHERE customerid='$customerid' ORDER BY date DESC LIMIT 1";
$result = @mysqli_query($db, "$sql");
$ipnumber = @mysqli_result($result, 0, "ip");

// Check if credit card information is available...
$sql="SELECT paymentinfo.orderid FROM paymentinfo, orders WHERE paymentinfo.orderid=orders.orderid AND orders.customerid='$customerid' ORDER BY paymentinfo.orderid DESC";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result) && $userid == "1") {
	$processlink = "<tr><td align=\"right\"><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">".CREDITCARD.":</font></td><td align=\"left\"><font size=\"2\" face=\"Arial, Helvetica, sans-serif\"><a href=\"selectcard.php?customerid=$customerid\">".ACCESSCREDITCARDONFILE."</a></font></td></tr>";
}

// Close database...
@mysqli_close($db);


// Show customer page in browser...
	if (strpos($header, "title") != 0) {
	    $newheader = substr($header,1,strpos($header, "title")+5);
	    $newheader .= CUSTOMERDATAFOR.": $firstname $lastname - ".substr($header,strpos($header, "title")+6,strlen($header));
    } else {
		$newheader = substr($header,1,strpos($header, "TITLE")+5);
		$newheader .= CUSTOMERDATAFOR.": $firstname $lastname - ".substr($header,strpos($header, "TITLE")+6,strlen($header));
	}

echo "$newheader
    <section class=\"content-header\"><h1>".PROFILEOF." $firstname $lastname, "; if ($level > 0) echo WHOLESALECUSTOMER; else echo CUSTOMERID; echo " $customerid <a href=\"salesreport.php?customerid=$customerid&generate=true\"><img src=\"images/icon_history.gif\" alt=\"".SALESHISTORYFOR." $customerid\" title=\"".SALESHISTORYFOR." $customerid\" border=\"0\"></a> <a href=\"editstorediscounts.php?customerid=$customerid\"><img src=\"images/icon_discount.gif\" alt=\"".PERSONALDISCOUNTSFOR." $customerid\" title=\"".PERSONALDISCOUNTSFOR." $customerid\" border=\"0\"></a>";
if (file_exists("$ashoppath/emerchant/quote.php") && $userid == 1) echo " <a href=\"../emerchant/history.php?customer=$customerid\" target=\"_blank\"><img src=\"images/icon_emerchant.gif\" alt=\"".SALESOFFICEHISTORY." $customerid\" title=\"".SALESOFFICEHISTORY." $customerid\" border=\"0\"></a>";
if ($userid == "1") echo "&nbsp;<a href=\"editcustomer.php?customerid=$customerid&remove=True\"><img src=\"images/icon_trash.gif\" alt=\"".DELETECUSTOMER." $customerid ".FROMDB."\" title=\"".DELETECUSTOMER." $customerid ".FROMDB."\" border=\"0\"></a>";
echo "</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">";
if ($userid == "1") echo "<form action=\"editcustomer.php\" method=\"post\">";
if ($errormsg) echo "
              <div class=\"alert alert-danger alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                $errormsg
              </div>";
if ($activate == "true") echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ORDERACTIVATIONCOMPLETED."
              </div";
echo "
                <div class=\"box-body\">
                    $processlink
                    <div class=\"form-group\">".admin_inputfield(array("label" => USERNAME, "name" => "nusername", "value" => $nusername, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PASSWORD, "name" => "password", "value" => $password, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => REFERREDBY, "name" => "affiliateid", "value" => $affiliateid, "small" => TRUE, "explanation" => "<a href=\"editaffiliate.php?affiliateid=$affiliateid\">$affiliatefirstname $affiliatelastname</a>"))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => VIRTUALCASH, "name" => "virtualcash", "value" => number_format($virtualcash,$showdecimals,$decimalchar,$thousandchar), "small" => TRUE, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ADD, "name" => "addvirtualcash", "small" => TRUE, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>";
if ($activatebids) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => AUCTIONBIDS, "name" => "auctionbids", "value" => $auctionbids, "small" => TRUE))."</div>";
if ($level > 0) {
    echo "
                    <div class=\"form-group\"><label for=\"level\">".PRICELEVEL."</label>
                        <select class=\"form-control\" name=\"level\"><option value=\"1\""; if ($level == "1") echo " selected"; echo ">".DEFAULTLEVEL."</option>";
	if ($pricelevels > 1) {
		for ($thislevel = 2; $thislevel <= $pricelevels; $thislevel++) {
			echo "<option value=\"$thislevel\"";
			if ($level == $thislevel) echo " selected";
			echo ">$thislevel</option>";
		}
	}
	echo "
	</select></div>";
}
if ($level > 0) {
    echo "
					<button type=\"submit\" class=\"btn btn-primary\" name=\"newlevel\" value=\"off\">".REVERTTORETAIL."</button>
                    <div class=\"form-group\"><label for=\"businesstype\">".BUSINESSTYPE."</label>
                        <select class=\"form-control\" name=\"businesstype\"><option value=\"none\""; 
	if ($businesstype == "none") echo " selected";
	echo ">".SELECTONE."</option><option value=\"soleproprietor\"";
	if ($businesstype == "soleproprietor") echo " selected";
	echo ">".SOLEPROPRIETOR."</option><option value=\"corporation\"";
	if ($businesstype == "corporation") echo " selected";
	echo ">".CORPORATION."</option><option value=\"nonprofit\"";
	if ($businesstype == "nonprofit") echo " selected";
	echo ">".NONPROFIT."</option></select></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => WEBSITEURL, "name" => "url", "value" => $url))."</div>";
} else echo "
					<button type=\"submit\" class=\"btn btn-primary\" name=\"newlevel\" value=\"1\">".UPGRADETOWHOLESALE."</button>";
echo "
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".BILLINGINFO."</h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => BUSINESSNAME, "name" => "shippingbusiness", "value" => $shippingbusiness))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => FIRSTNAME, "name" => "firstname", "value" => $firstname))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LASTNAME, "name" => "lastname", "value" => $lastname))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => EMAIL, "name" => "email", "value" => $email))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ADDRESS, "name" => "address", "value" => $address))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => CITY, "name" => "city", "value" => $city))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => STATEPROVINCE, "name" => "state", "value" => $state))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ZIP, "name" => "zip", "value" => $zip, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => COUNTRY, "name" => "country", "value" => $country))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PHONE, "name" => "phone", "value" => $phone))."</div>";
	if ($requestabn) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => ABN." ".NUMBER, "name" => "vat", "value" => $vat))."</div>";
	else echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => VAT." ".NUMBER, "name" => "vat", "value" => $vat))."</div>";
    echo "
                    <div class=\"form-group\">".admin_textbox(array("label" => ADDITIONAL." ".INFORMATION, "name" => "extrainfo", "value" => $extrainfo))."</div>
                </div>
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".SHIPPINGINFO."</h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => FIRSTNAME, "name" => "shippingfirstname", "value" => $shippingfirstname))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LASTNAME, "name" => "shippinglastname", "value" => $shippinglastname))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ADDRESS, "name" => "shippingaddress", "value" => $shippingaddress))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ADDRESS2, "name" => "shippingaddress2", "value" => $shippingaddress2))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => CITY, "name" => "shippingcity", "value" => $shippingcity))."</div>
                    <div class=\"form-group\">
                        <label for=\"shippingstate\">".STATEPROVINCE."</label>
                        <select class=\"form-control\" name=\"shippingstate\"><option value=none>".CHOOSESTATE;
		foreach ($americanstates as $longstate => $shortstate) {
			echo "<option value=$shortstate";
			if ($shortstate == $shippingstate) echo " selected";
			echo ">$longstate\n";
		}
 
echo "</select></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ZIP, "name" => "shippingzip", "value" => $shippingzip, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => COUNTRY, "name" => "shippingcountry", "value" => $shippingcountry))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SENDINGEMAILALLOWED, "name" => "allowemail", "checked" => $allowemail == "1"?TRUE:FALSE))."</div>
                </div>
                <div class=\"form-group\"><label>".LASTKNOWNIP.":</label> $ipnumber</div>";
if ($userid == "1") echo "
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"update\" value=\"".UPDATE."\">".UPDATE."</button>
				</div>
                <input type=\"hidden\" name=\"customerid\" value=\"$customerid\">
            </form>";
echo "</div></div></div></section>$footer";
?>