<?php
// AShop
// Copyright 2002-2017 - All Rights Reserved Worldwide
// http://www.ashopsoftware.com
// This software is licensed per individual site.
// By installing or using this software, you agree to the licensing terms,
// which are located at http://www.ashopsoftware.com/license.htm
// Unauthorized use or distribution of this software 
// is a violation U.S. and international copyright laws.

include "checklicense.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/salesoffice.inc.php";
include "ashopconstants.inc.php";

// Get context help for this page...
$contexthelppage = "editbilling";
include "help.inc.php";

echo "$header
    <section class=\"content-header\"><h1>".BILLINGTEMPLATES."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"editbilling.php\" method=\"post\" name=\"billingtemplateform$i\">
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\"><a href=\"$help1\" class=\"helpnav\" target=\"_blank\">".ADDNEWBILLINGTEMPLATE."</a></h3>
                </div>
	            <div class=\"box-body\">
                    <div class=\"form-group\">
                        <label for=\"billtemplatetype\">".BILLTEMPLATETYPE."</label>
                        <select class=\"form-control\" name=\"billtemplatetype\"><option value=\"authnetarb\">".AUTHNETARB."<option value=\"autobill\">".AUTOBILL."</select>
                    </div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ENTERANAME, "name" => "billtemplatename"))."</div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"add\" value=\"".ADD."\">".ADD."</button>
				</div>
                <input type=\"hidden\" name=\"updatebilltemplate\" value=\"new\">
            </form>
        </div>";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Update selected bill template...
if ($updatebilltemplate && !$delete) {
	if ($updatebilltemplate == "new") {
		if ($billtemplatetype == "autobill") {
			$remindermessage = DEFAULTREMINDERMSG."$ashopurl/payment.php?invoice=%orderid%";
			$pastduemessage = DEFAULTPASTDUEMSG."$ashopurl/payment.php?invoice=%orderid%";
		}
		$sql="INSERT INTO emerchant_billtemplates (name, duedays, reminderdays, remindermessage, pastduedays, pastduemessage, recurring, recurringtimes, templatetype) VALUES ('$billtemplatename', '30', '3', '$remindermessage', '3', '$pastduemessage', '', '0', '$billtemplatetype')";
	} else $sql="UPDATE emerchant_billtemplates SET name='$nname', duedays='$nbilltemplateduedays', reminderdays='$nbilltemplatereminderdays', remindermessage='$nbilltemplateremindermessage', pastduedays='$nbilltemplatepastduedays', pastduemessage='$nbilltemplatepastduemessage', recurring='$nbilltemplaterecurring', recurringtimes='$nbilltemplaterecurringtimes', sendbilldays='$nbilltemplatesendbilldays' WHERE billtemplateid=$updatebilltemplate";
	$result = @mysqli_query($db, "$sql");
} else if ($updatebilltemplate && $delete) {
	$sql="DELETE FROM emerchant_billtemplates WHERE billtemplateid=$updatebilltemplate";
	$result = @mysqli_query($db, "$sql");
}

// Display current bill templates...
$sql="SELECT * FROM emerchant_billtemplates ORDER BY billtemplateid DESC";
$result = @mysqli_query($db, "$sql");
for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
	$billtemplateid = @mysqli_result($result, $i, "billtemplateid");
	$billtemplatename = @mysqli_result($result, $i, "name");
	$thistemplatetype = @mysqli_result($result, $i, "templatetype");
	if ($thistemplatetype == "autobill") $billtemplatetype = "AutoBill";
	else if ($thistemplatetype == "authnetarb") $billtemplatetype = "Authorize.Net ARB";
	$billtemplateduedays = @mysqli_result($result, $i, "duedays");
	$billtemplatereminderdays = @mysqli_result($result, $i, "reminderdays");
	$billtemplateremindermessage = @mysqli_result($result, $i, "remindermessage");
	$billtemplatepastduedays = @mysqli_result($result, $i, "pastduedays");
	$billtemplatepastduemessage = @mysqli_result($result, $i, "pastduemessage");
	$billtemplaterecurring = @mysqli_result($result, $i, "recurring");
	$billtemplaterecurringtimes = @mysqli_result($result, $i, "recurringtimes");
	$billtemplatesendbilldays = @mysqli_result($result, $i, "sendbilldays");

	echo "
		<div class=\"box box-primary\">
            <form action=\"editbilling.php\" method=\"post\" name=\"billingtemplateform$i\">
                <div class=\"box-body\">
                    <div class=\"form-group\"><label>".BILLTEMPLATETYPE.": </label> $billtemplatetype</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => TEMPLATENAME, "name" => "nname", "value" => $billtemplatename))."</div>";
	if ($thistemplatetype == "autobill") echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => DUE, "name" => "nbilltemplateduedays", "value" => $billtemplateduedays, "suffix" => DAYSAFTERORDERDATE))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => REMIND.":", "name" => "reminder", "checked" => TRUE))
                    .admin_inputfield(array("label" => "", "name" => "nbilltemplatereminderdays", "value" => $billtemplatereminderdays, "suffix" => DAYSBEFOREDUEIFNOTPAID))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => REMINDERMESSAGE, "name" => "nbilltemplateremindermessage", "value" => $billtemplateremindermessage))."</div>
                    <div class=\"form-group\">".admin_checkbox(array("label" => SENDPASTDUEMESSAGE.":", "name" => "pastdue", "checked" => TRUE))
                    .admin_inputfield(array("label" => "", "name" => "nbilltemplatepastduedays", "value" => $billtemplatepastduedays, "suffix" => DAYSAFTERDUEIFNOTPAID))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => PASTDUEMESSAGE, "name" => "nbilltemplatepastduemessage", "value" => $billtemplatepastduemessage))."</div>";
	else echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => START, "name" => "nbilltemplateduedays", "value" => $billtemplateduedays, "suffix" => DAYSAFTERORDERDATE))."</div>
                    <input type=\"hidden\" name=\"nbilltemplatepastduedays\" value=\"0\">
                    <input type=\"hidden\" name=\"nbilltemplatereminderdays\" value=\"0\">
                    <input type=\"hidden\" name=\"nbilltemplatesendbilldays\" value=\"0\">";
	echo "
                    <div class=\"form-group\"><label for=\"nbilltemplaterecurring\">".RECURRING."</label><select class=\"form-control\" name=\"nbilltemplaterecurring\">";
	if ($thistemplatetype == "autobill") echo "<option value=\"none\">".NONE;
	echo "<option value=\"weekly\""; if ($billtemplaterecurring == "weekly") echo " selected"; echo ">".WEEKLY."<option value=\"monthly\""; if ($billtemplaterecurring == "monthly") echo " selected"; echo ">".MONTHLY."<option value=\"quarterly\""; if ($billtemplaterecurring == "quarterly") echo " selected"; echo ">".QUARTERLY."<option value=\"semiannually\""; if ($billtemplaterecurring == "semiannually") echo " selected"; echo ">".SEMIANNUALLY."<option value=\"annually\""; if ($billtemplaterecurring == "annually") echo " selected"; echo ">".ANNUALLY."</select></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => REPEAT, "name" => "nbilltemplaterecurringtimes", "value" => $billtemplaterecurringtimes, "suffix" => NUMBEROFTIMES, "explanation" => ZEROINDEFINITELY))."</div>";
if ($thistemplatetype == "autobill") echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => SENDNEXTBILLATLEAST, "name" => "nbilltemplatesendbilldays", "value" => $billtemplatesendbilldays, "suffix" => DAYSBEFOREDUEDATE))."</div>";
	echo "
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"delete\" value=\"".THEWORDDELETE."\">".THEWORDDELETE."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"update\" value=\"".UPDATE."\">".UPDATE."</button>
				</div>
                <input type=\"hidden\" name=\"updatebilltemplate\" value=\"$billtemplateid\">
            </form>
        </div>";
}

// Close database...
@mysqli_close($db);

echo "</div></div></section>$footer";
?>