<?php
// Define currency symbols...
$currencysymbols = array (
"usd" => array("pre" => "$",
			   "post" => ""),
"cad" => array("pre" => "$",
			   "post" => ""),
"mxn" => array("pre" => "$",
			   "post" => ""),
"aud" => array("pre" => "$",
			   "post" => ""),
"btc" => array("pre" => "",
			   "post" => "BTC"),
"gbp" => array("pre" => "&pound;",
			   "post" => ""),
"eur" => array("pre" => "&euro;",
			   "post" => ""),
"sgd" => array("pre" => "$",
			   "post" => ""),
"sek" => array("pre" => "",
			   "post" => "&nbsp;kr"),
"nok" => array("pre" => "",
			   "post" => "&nbsp;kr"),
"dkk" => array("pre" => "",
			   "post" => "&nbsp;kr"),
"huf" => array("pre" => "",
			   "post" => "&nbsp;Ft"),
"nzd" => array("pre" => "$",
			   "post" => ""),
"cny" => array("pre" => "&yen;",
			   "post" => ""),
"jpy" => array("pre" => "&yen;",
			   "post" => ""),
"hkd" => array("pre" => "$",
			   "post" => ""),
"inr" => array("pre" => "Rs.",
			   "post" => ""),
"krw" => array("pre" => "&#8361;",
			   "post" => ""),
"myr" => array("pre" => "",
			   "post" => "&nbsp;RM"),
"ltl" => array("pre" => "Lt.",
			   "post" => ""),
"lvl" => array("pre" => "Ls",
			   "post" => ""),
"bgn" => array("pre" => "",
			   "post" => "&nbsp;lev"),
"pln" => array("pre" => "",
			   "post" => "&nbsp;pln"),
"ron" => array("pre" => "L.",
			   "post" => ""),
"chf" => array("pre" => "Fr.",
			   "post" => ""),
"hrk" => array("pre" => "",
			   "post" => "&nbsp;HRK"),
"rub" => array("pre" => "p.",
			   "post" => ""),
"rub" => array("pre" => "",
			   "post" => "&nbsp;YTL"),
"brl" => array("pre" => "R$",
			   "post" => ""),
"idr" => array("pre" => "Rp.",
			   "post" => ""),
"ils" => array("pre" => "&#8362;",
			   "post" => ""),
"php" => array("pre" => "Ph.",
			   "post" => ""),
"thb" => array("pre" => "&#3647;",
			   "post" => ""),
"zar" => array("pre" => "R",
			   "post" => ""),
"twd" => array("pre" => "NT$",
			   "post" => ""),
"tec" => array("pre" => "",
			   "post" => "&nbsp;credits")
);

// Define currency names...
$currencynames = array (
"usd" => "US Dollars",
"cad" => "Canadian Dollars",
"mxn" => "Mexican Peso",
"aud" => "Australian Dollars",
"btc" => "Bitcoins",
"gbp" => "Pounds Sterling",
"eur" => "Euro",
"sgd" => "Singapore Dollars",
"sek" => "Svenska Kronor",
"huf" => "Hungarian Forint",
"nzd" => "New Zealand Dollars",
"tec" => "TE Credits",
"nok" => "Norske Kroner",
"jpy" => "Japanese Yen",
"bgn" => "Bulgarian Lev",
"czk" => "Czech Koruna",
"dkk" => "Danske Kroner",
"eek" => "Estonian Kroon",
"ltl" => "Lithuanian Litas",
"lvl" => "Latvian Lats",
"pln" => "Polish Zloty",
"ron" => "Romanian Leu",
"chf" => "Swiss Franc",
"hrk" => "Croatian Kuna",
"rub" => "Russian Ruble",
"try" => "New Turkish Lira",
"brl" => "Brazilian Real",
"cny" => "Chinese Yuan",
"hkd" => "Hong Kong Dollars",
"idr" => "Indonesian Rupiah",
"inr" => "Indian Rupee",
"krw" => "Korean Won",
"php" => "Philippine Peso",
"thb" => "Thai Baht",
"zar" => "South African Rand",
"myr" => "Malaysian Ringgit"
);

// Define Twitter messages...
if (empty($ashopname)) $ashopname = "";
$twittermessages = array (
"new" => "Now available from $ashopname: %shorturl%",
"update" => "%productname% has been updated: %shorturl%",
"discount" => "Get a discount on %productname%! Enter this code: %discountcode% at %shorturl%"
);

// Define mobile devices...
$devices = array (
"mobile" =>	array (
		"itemsperrow" => 1,
		"displayitems" => 10,
		"name" => "mobile"
		),
"iPhone" => array (
		"itemsperrow" => 1,
		"displayitems" => 10,
		"name" => "mobile"
		),
"Android" => array (
		"itemsperrow" => 1,
		"displayitems" => 10,
		"name" => "mobile"
		),
"AndroidTablet" => array (
		"itemsperrow" => 3,
		"displayitems" => 10,
		"name" => "mobile"
		),
"webOS" => array (
		"itemsperrow" => 1,
		"displayitems" => 10,
		"name" => "mobile"
		),
"iPod" => array (
		"itemsperrow" => 1,
		"displayitems" => 10,
		"name" => "mobile"
		),
"iPad" => array (
		"itemsperrow" => 3,
		"displayitems" => 10,
		"name" => "mobile"
		),
"BlackBerry" => array (
		"itemsperrow" => 1,
		"displayitems" => 10,
		"name" => "mobile"
		),
"RIM Tablet" => array (
		"itemsperrow" => 1,
		"displayitems" => 10,
		"name" => "mobile"
		)
);

// Define payout options for Digital Mall members...
$memberpayoutoptions = array (
"1" => "PayPal\\nMy PayPal ID is: ",
"2" => "Wire Transfer\\nBank Name & Address: \\nRouting no: \\nAccount no: \\n",
"3" => "IBAN\\nBank Name & Address: \\nAccount no: \\nBIC/SWIFT: \\nBankleitzahl (optional): ",
"4" => "Specify payment details: "
);

if (defined('PAYPAL')) $memberpayoutnames = array (
"1" => 'PAYPAL',
"2" => 'WIRETRANSFER',
"3" => 'IBAN',
"4" => 'OTHER'
);

// Define the default CSV import characters...
$defaultdelimiter = ",";
$defaultenclosure = "&quot;";

// Define countries and US states as variables to be used by other scripts...
$countries = array (
"AF" => "Afghanistan",
"AX" => "Aland Islands",
"AL" => "Albania",
"DZ" => "Algeria",
"AS" => "American Samoa",
"AD" => "Andorra",
"AO" => "Angola",
"AI" => "Anguilla",
"AQ" => "Antarctica",
"AG" => "Antigua and Barbuda",
"AR" => "Argentina",
"AM" => "Armenia",
"AW" => "Aruba",
"AU" => "Australia",
"AT" => "Austria",
"AZ" => "Azerbaijan",
"BS" => "Bahamas",
"BH" => "Bahrain",
"BD" => "Bangladesh",
"BB" => "Barbados",
"BY" => "Belarus",
"BE" => "Belgium",
"BZ" => "Belize",
"BJ" => "Benin",
"BM" => "Bermuda",
"BT" => "Bhutan",
"BO" => "Bolivia",
"BA" => "Bosnia and Herzegovina",
"BW" => "Botswana",
"BV" => "Bouvet Island",
"BR" => "Brazil",
"IO" => "British Indian Ocean Territory",
"VG" => "British Virgin Islands",
"BN" => "Brunei Darussalam",
"BG" => "Bulgaria",
"BF" => "Burkina Faso",
"BI" => "Burundi",
"KH" => "Cambodia",
"CM" => "Cameroon",
"CA" => "Canada",
"CV" => "Cape Verde",
"KY" => "Cayman Islands",
"CF" => "Central African Republic",
"TD" => "Chad",
"CL" => "Chile",
"CN" => "China",
"CX" => "Christmas Island",
"CC" => "Cocos (Keeling) Islands",
"CO" => "Colombia",
"KM" => "Comoros",
"CG" => "Congo",
"CK" => "Cook Islands",
"CR" => "Costa Rica",
"CI" => "Cote D'ivoire",
"HR" => "Croatia",
"CU" => "Cuba",
"CY" => "Cyprus",
"CZ" => "Czech Republic",
"CD" => "Democratic Republic of the Congo",
"DK" => "Denmark",
"DJ" => "Djibouti",
"DM" => "Dominica",
"DO" => "Dominican Republic",
"EC" => "Ecuador",
"EG" => "Egypt",
"SV" => "El Salvador",
"GQ" => "Equatorial Guinea",
"ER" => "Eritrea",
"EE" => "Estonia",
"ET" => "Ethiopia",
"FK" => "Falkland Islands (Malvinas)",
"FO" => "Faroe Islands",
"FJ" => "Fiji",
"FI" => "Finland",
"FR" => "France",
"GF" => "French Guiana",
"PF" => "French Polynesia",
"TF" => "French Southern Territories",
"GA" => "Gabon",
"GM" => "Gambia",
"GE" => "Georgia",
"DE" => "Germany",
"GH" => "Ghana",
"GI" => "Gibraltar",
"GR" => "Greece",
"GL" => "Greenland",
"GD" => "Grenada",
"GP" => "Guadeloupe",
"GU" => "Guam",
"GT" => "Guatemala",
"GG" => "Guernsey",
"GN" => "Guinea",
"GW" => "Guinea-Bissau",
"GY" => "Guyana",
"HT" => "Haiti",
"HM" => "Heard and McDonald Islands",
"HN" => "Honduras",
"HK" => "Hong Kong",
"HU" => "Hungary",
"IS" => "Iceland",
"IN" => "India",
"ID" => "Indonesia",
"IQ" => "Iraq",
"IE" => "Ireland",
"IR" => "Islamic Republic of Iran",
"IM" => "Isle of Man",
"IL" => "Israel",
"IT" => "Italy",
"JM" => "Jamaica",
"JP" => "Japan",
"JE" => "Jersey",
"JO" => "Jordan",
"KZ" => "Kazakhstan",
"KE" => "Kenya",
"KI" => "Kiribati",
"KP" => "Korea",
"KR" => "Korea, Republic of",
"KW" => "Kuwait",
"KG" => "Kyrgyzstan",
"LA" => "Laos",
"LV" => "Latvia",
"LB" => "Lebanon",
"LS" => "Lesotho",
"LR" => "Liberia",
"LY" => "Libyan Arab Jamahiriya",
"LI" => "Liechtenstein",
"LT" => "Lithuania",
"LU" => "Luxembourg",
"MO" => "Macau",
"MK" => "Macedonia",
"MG" => "Madagascar",
"MW" => "Malawi",
"MY" => "Malaysia",
"MV" => "Maldives",
"ML" => "Mali",
"MT" => "Malta",
"MH" => "Marshall Islands",
"MQ" => "Martinique",
"MR" => "Mauritania",
"MU" => "Mauritius",
"YT" => "Mayotte",
"MX" => "Mexico",
"FM" => "Micronesia",
"MD" => "Moldova, Republic of",
"MC" => "Monaco",
"MN" => "Mongolia",
"ME" => "Montenegro",
"MS" => "Montserrat",
"MA" => "Morocco",
"MZ" => "Mozambique",
"MM" => "Myanmar",
"NA" => "Namibia",
"NR" => "Nauru",
"NP" => "Nepal",
"NL" => "Netherlands",
"AN" => "Netherlands Antilles",
"NC" => "New Caledonia",
"NZ" => "New Zealand",
"NI" => "Nicaragua",
"NE" => "Niger",
"NG" => "Nigeria",
"NU" => "Niue",
"NF" => "Norfolk Island",
"MP" => "Northern Mariana Islands",
"NO" => "Norway",
"OM" => "Oman",
"PK" => "Pakistan",
"PW" => "Palau",
"PS" => "Palestinian Territory",
"PA" => "Panama",
"PG" => "Papua New Guinea",
"PY" => "Paraguay",
"PE" => "Peru",
"PH" => "Philippines",
"PN" => "Pitcairn",
"PL" => "Poland",
"PT" => "Portugal",
"PR" => "Puerto Rico",
"QA" => "Qatar",
"RE" => "Reunion",
"RO" => "Romania",
"RU" => "Russian Federation",
"RW" => "Rwanda",
"WS" => "Samoa",
"SM" => "San Marino",
"ST" => "Sao Tome and Principe",
"SA" => "Saudi Arabia",
"SN" => "Senegal",
"RS" => "Serbia",
"SC" => "Seychelles",
"SL" => "Sierra Leone",
"SG" => "Singapore",
"SK" => "Slovakia",
"SI" => "Slovenia",
"SB" => "Solomon Islands",
"SO" => "Somalia",
"ZA" => "South Africa",
"GS" => "South Georgia and the South Sandwich Islands",
"ES" => "Spain",
"LK" => "Sri Lanka",
"BL" => "St. Barthelemy",
"SH" => "St. Helena",
"KN" => "St. Kitts and Nevis",
"LC" => "St. Lucia",
"MF" => "St. Martin",
"PM" => "St. Pierre and Miquelon",
"VC" => "St. Vincent and the Grenadines",
"SD" => "Sudan",
"SR" => "Suriname",
"SJ" => "Svalbard and Jan Mayen Islands",
"SZ" => "Swaziland",
"SE" => "Sweden",
"CH" => "Switzerland",
"SY" => "Syrian Arab Republic",
"TW" => "Taiwan",
"TJ" => "Tajikistan",
"TZ" => "Tanzania, United Republic of",
"TH" => "Thailand",
"TL" => "Timor-Leste",
"TG" => "Togo",
"TK" => "Tokelau",
"TO" => "Tonga",
"TT" => "Trinidad and Tobago",
"TN" => "Tunisia",
"TR" => "Turkey",
"TM" => "Turkmenistan",
"TC" => "Turks and Caicos Islands",
"TV" => "Tuvalu",
"UG" => "Uganda",
"UA" => "Ukraine",
"AE" => "United Arab Emirates",
"GB" => "United Kingdom",
"US" => "United States",
"UM" => "United States Minor Outlying Islands",
"VI" => "United States Virgin Islands",
"UY" => "Uruguay",
"UZ" => "Uzbekistan",
"VU" => "Vanuatu",
"VA" => "Vatican City State",
"VE" => "Venezuela",
"VN" => "Vietnam",
"WF" => "Wallis And Futuna Islands",
"EH" => "Western Sahara",
"YE" => "Yemen",
"ZM" => "Zambia",
"ZW" => "Zimbabwe"
);

// Define 3-digit country codes...
$threedigitcountries = array (
"AF" => "AFG",
"AX" => "ALA",
"AL" => "ALB",
"DZ" => "DZA",
"AS" => "ASM",
"AD" => "AND",
"AO" => "AGO",
"AI" => "AIA",
"AQ" => "ATA",
"AG" => "ATG",
"AR" => "ARG",
"AM" => "ARM",
"AW" => "ABW",
"AU" => "AUS",
"AT" => "AUT",
"AZ" => "AZE",
"BS" => "BHS",
"BH" => "BHR",
"BD" => "BGD",
"BB" => "BRB",
"BY" => "BLR",
"BE" => "BEL",
"BZ" => "BLZ",
"BJ" => "BEN",
"BM" => "BMU",
"BT" => "BTN",
"BO" => "BOL",
"BQ" => "BES",
"BA" => "BIH",
"BW" => "BWA",
"BV" => "BVT",
"BR" => "BRA",
"IO" => "IOT",
"BN" => "BRN",
"BG" => "BGR",
"BF" => "BFA",
"BI" => "BDI",
"KH" => "KHM",
"CM" => "CMR",
"CA" => "CAN",
"CV" => "CPV",
"KY" => "CYM",
"CF" => "CAF",
"TD" => "TCD",
"CL" => "CHL",
"CN" => "CHN",
"CX" => "CXR",
"CC" => "CCK",
"CO" => "COL",
"KM" => "COM",
"CG" => "COG",
"CD" => "COD",
"CK" => "COK",
"CR" => "CRI",
"CI" => "CIV",
"HR" => "HRV",
"CU" => "CUB",
"CW" => "CUW",
"CY" => "CYP",
"CZ" => "CZE",
"DK" => "DNK",
"DJ" => "DJI",
"DM" => "DMA",
"DO" => "DOM",
"EC" => "ECU",
"EG" => "EGY",
"SV" => "SLV",
"GQ" => "GNQ",
"ER" => "ERI",
"EE" => "EST",
"ET" => "ETH",
"FK" => "FLK",
"FO" => "534",
"FJ" => "FJI",
"FI" => "FIN",
"FR" => "FRA",
"GF" => "GUF",
"PF" => "PYF",
"TF" => "ATF",
"GA" => "GAB",
"GM" => "GMB",
"GE" => "GEO",
"DE" => "DEU",
"GH" => "GHA",
"GI" => "GIB",
"GR" => "GRC",
"GL" => "GRL",
"GD" => "GRD",
"GP" => "GLP",
"GU" => "GUM",
"GT" => "GTM",
"GG" => "GGY",
"GN" => "GIN",
"GW" => "GNB",
"GY" => "GUY",
"HT" => "HTI",
"HM" => "HMD",
"VA" => "VAT",
"HN" => "HND",
"HK" => "HKG",
"HU" => "HUN",
"IS" => "ISL",
"IN" => "IND",
"ID" => "IDN",
"IR" => "IRN",
"IQ" => "IRQ",
"IE" => "IRL",
"IM" => "IMN",
"IL" => "ISR",
"IT" => "ITA",
"JM" => "JAM",
"JP" => "JPN",
"JE" => "JEY",
"JO" => "JOR",
"KZ" => "KAZ",
"KE" => "KEN",
"KI" => "KIR",
"KP" => "PRK",
"KR" => "KOR",
"KW" => "KWT",
"KG" => "KGZ",
"LA" => "LAO",
"LV" => "LVA",
"LB" => "LBN",
"LS" => "LSO",
"LR" => "LBR",
"LY" => "LBY",
"LI" => "LIE",
"LT" => "LTU",
"LU" => "LUX",
"MO" => "MAC",
"MK" => "MKD",
"MG" => "MDG",
"MW" => "MWI",
"MY" => "MYS",
"MV" => "MDV",
"ML" => "MLI",
"MT" => "MLT",
"MH" => "MHL",
"MQ" => "MTQ",
"MR" => "MRT",
"MU" => "MUS",
"YT" => "MYT",
"MX" => "MEX",
"FM" => "FSM",
"MD" => "MDA",
"MC" => "MCO",
"MN" => "MNG",
"ME" => "MNE",
"MS" => "MSR",
"MA" => "MAR",
"MZ" => "MOZ",
"MM" => "MMR",
"NA" => "NAM",
"NR" => "NRU",
"NP" => "NPL",
"NL" => "NLD",
"NC" => "NCL",
"NZ" => "NZL",
"NI" => "NIC",
"NE" => "NER",
"NG" => "NGA",
"NU" => "NIU",
"NF" => "NFK",
"MP" => "MNP",
"NO" => "NOR",
"PS" => "PSE",
"OM" => "OMN",
"PK" => "PAK",
"PW" => "PLW",
"PA" => "PAN",
"PG" => "PNG",
"PY" => "PRY",
"PE" => "PER",
"PH" => "PHL",
"PN" => "PCN",
"PL" => "POL",
"PT" => "PRT",
"PR" => "PRI",
"QA" => "QAT",
"RE" => "REU",
"RO" => "ROU",
"RU" => "RUS",
"RW" => "RWA",
"BL" => "534",
"SH" => "SHN",
"KN" => "KNA",
"LC" => "LCA",
"MF" => "MAF",
"PM" => "SPM",
"VC" => "VCT",
"WS" => "WSM",
"SM" => "SMR",
"ST" => "STP",
"SA" => "SAU",
"SN" => "SEN",
"RS" => "SRB",
"SC" => "SYC",
"SL" => "SLE",
"SG" => "SGP",
"SX" => "SXM",
"SK" => "SVK",
"SI" => "SVN",
"SB" => "SLB",
"SO" => "SOM",
"ZA" => "ZAF",
"GS" => "SGS",
"SS" => "SSD",
"ES" => "ESP",
"LK" => "LKA",
"SD" => "SDN",
"SR" => "SUR",
"SJ" => "534",
"SZ" => "SWZ",
"SE" => "SWE",
"CH" => "CHE",
"SY" => "SYR",
"TW" => "TWN",
"TJ" => "TJK",
"TZ" => "TZA",
"TH" => "THA",
"TL" => "TLS",
"TG" => "TGO",
"TK" => "TKL",
"TO" => "TON",
"TT" => "TTO",
"TN" => "TUN",
"TR" => "TUR",
"TM" => "TKM",
"TC" => "TCA",
"TV" => "TUV",
"UG" => "UGA",
"UA" => "UKR",
"AE" => "ARE",
"GB" => "GBR",
"US" => "USA",
"UM" => "UMI",
"UY" => "URY",
"UZ" => "UZB",
"VU" => "VUT",
"VE" => "VEN",
"VN" => "VNM",
"VG" => "VGB",
"VI" => "VIR",
"WF" => "WLF",
"EH" => "ESH",
"YE" => "YEM",
"ZM" => "ZMB",
"ZW" => "ZWE"
);


$countrieswithstates = array (
"US",
"CA",
"AU",
"AT",
"BE",
"DE",
"ES",
"FR",
"GB",
"IT",
"LU",
"NL",
"USA",
"United States",
"Canada",
"Australia",
"Austria",
"Belgium",
"Germany",
"Spain",
"France",
"United Kingdom",
"Italy",
"Netherlands"
);

$longcountrieswithstates = array (
"United States",
"Canada",
"Australia",
"Austria",
"Belgium",
"Germany",
"Spain",
"France",
"United Kingdom",
"Italy",
"Luxembourg",
"Netherlands"
);

$canprovinces = array (
		   "Alberta"       => "AB",
		   "British Columbia" => "BC",
		   "Manitoba"      => "MB",
		   "New Brunswick" => "NB",
		   "Newfoundland and Labrador" => "NL",
		   "Northwest Territories"  => "NT",
		   "Nova Scotia"   => "NS",
		   "Nunavut"       => "NU",
		   "Ontario"       => "ON",
		   "Prince Edward Island" => "PE",
		   "Quebec"        => "QC",
		   "Saskatchewan"  => "SK",
		   "Yukon Territory" => "YT"
		 );

$americanstates = array (
		   "Alabama"       => "AL",
		   "Alaska"        => "AK",
		   "Arizona"       => "AZ",
		   "Arkansas"      => "AR",
		   "California"    => "CA",
		   "Colorado"      => "CO",
		   "Connecticut"   => "CT",
		   "Delaware"      => "DE",
		   "Florida"       => "FL",
		   "Georgia"       => "GA",
		   "Hawaii"        => "HI",
		   "Idaho"         => "ID",
		   "Illinois"      => "IL",
		   "Indiana"       => "IN",
		   "Iowa"          => "IA",
		   "Kansas"        => "KS",
		   "Kentucky"      => "KY",
		   "Louisiana"     => "LA",
		   "Maine"         => "ME",
		   "Maryland"      => "MD",
		   "Massachusetts" => "MA",
		   "Michigan"      => "MI",
		   "Minnesota"     => "MN",
		   "Mississippi"   => "MS",
		   "Missouri"      => "MO",
		   "Montana"       => "MT",
		   "Nebraska"      => "NE",
		   "Nevada"        => "NV",
		   "New Hampshire" => "NH",
		   "New Jersey"    => "NJ",
		   "New Mexico"    => "NM",
		   "New York"      => "NY",
		   "North Carolina"=> "NC",
		   "North Dakota"  => "ND",
		   "Ohio"          => "OH",
		   "Oklahoma"      => "OK",
		   "Oregon"        => "OR",
		   "Pennsylvania"  => "PA",
		   "Puerto Rico"   => "PR",
		   "Rhode Island"  => "RI",
		   "South Carolina"=> "SC",
		   "South Dakota"  => "SD",
		   "Tennessee"     => "TN",
		   "Texas"         => "TX",
		   "Utah"          => "UT",
		   "Vermont"       => "VT",
		   "Virginia"      => "VA",
		   "Washington"    => "WA",
		   "Washington D.C."=> "DC",
		   "West Virginia" => "WV",
		   "Wisconsin"     => "WI",
		   "Wyoming"       => "WY",
		   "Army Europe"   => "AE",
		   "Army Pacific"  => "AP",
		   "Army America"  => "AA"
		);

$uscanstates = array (
		   "Alabama"       => "AL",
		   "Alaska"        => "AK",
		   "Alberta"       => "AB",
		   "Arizona"       => "AZ",
		   "Arkansas"      => "AR",
		   "Australian Capital Territory" => "ACT",
		   "British Columbia" => "BC",
		   "California"    => "CA",
		   "Colorado"      => "CO",
		   "Connecticut"   => "CT",
		   "Delaware"      => "DE",
		   "Florida"       => "FL",
		   "Georgia"       => "GA",
		   "Hawaii"        => "HI",
		   "Idaho"         => "ID",
		   "Illinois"      => "IL",
		   "Indiana"       => "IN",
		   "Iowa"          => "IA",
		   "Kansas"        => "KS",
		   "Kentucky"      => "KY",
		   "Louisiana"     => "LA",
		   "Maine"         => "ME",
		   "Manitoba"      => "MB",
		   "Maryland"      => "MD",
		   "Massachusetts" => "MA",
		   "Michigan"      => "MI",
		   "Minnesota"     => "MN",
		   "Mississippi"   => "MS",
		   "Missouri"      => "MO",
		   "Montana"       => "MT",
		   "Nebraska"      => "NE",
		   "Nevada"        => "NV",
		   "New Brunswick" => "NB",
		   "Newfoundland and Labrador" => "NL",
		   "New Hampshire" => "NH",
		   "New Jersey"    => "NJ",
		   "New Mexico"    => "NM",
		   "New South Wales"  => "NSW",
		   "New York"      => "NY",
		   "North Carolina"=> "NC",
		   "North Dakota"  => "ND",
		   "Northern Territory" => "NT",	
		   "Northwest Territories" => "NT",
		   "Nova Scotia"   => "NS",
		   "Nunavut"       => "NU",
		   "Ohio"          => "OH",
		   "Oklahoma"      => "OK",
		   "Ontario"       => "ON",
		   "Oregon"        => "OR",
		   "Pennsylvania"  => "PA",
		   "Prince Edward Island" => "PE",
		   "Puerto Rico"   => "PR",		   
		   "Quebec"        => "QC",
		   "Queensland"    => "QLD",
		   "Rhode Island"  => "RI",
		   "Saskatchewan"  => "SK",
		   "South Australia" => "SA",
		   "South Carolina"=> "SC",
		   "South Dakota"  => "SD",
		   "Tasmania"      => "TAS",
		   "Tennessee"     => "TN",
		   "Texas"         => "TX",
		   "Utah"          => "UT",
		   "Vermont"       => "VT",
		   "Victoria"      => "VIC",
		   "Virginia"      => "VA",
		   "Washington"    => "WA",
		   "Washington D.C."=> "DC",
		   "West Virginia" => "WV",
		   "Western Australia"=> "WA",	
		   "Wisconsin"     => "WI",
		   "Wyoming"       => "WY",
		   "Yukon Territory" => "YT",
		   "Army Europe"   => "AE",
		   "Army Pacific"  => "AP",
		   "Army America"  => "AA"
		);

$australianstates = array (
		   "Queensland"       => "QLD",
		   "New South Wales"  => "NSW",
		   "Australian Capital Territory" => "ACT",
		   "Victoria"         => "VIC",
		   "South Australia"  => "SA",
		   "Western Australia"=> "WA",		   
		   "Northern Territory" => "NT",	
		   "Tasmania"         => "TAS"
		);

$austriastates = array (
		   "Burgenland"       => "Burgenland",
		   "Krnten"		  => "Krnten",
		   "Niedersterreich" => "Niedersterreich",
		   "Obersterreich"   => "Obersterreich",
		   "Salzburg"		  => "Salzburg",
		   "Steiermark"		  => "Steiermark",		   
		   "Tirol"			  => "Tirol",	
		   "Vorarlberg"       => "Vorarlberg",
		   "Wien"		      => "Wien"
		);

$belgiumstates = array (
		   "Antwerpen"	      => "ANT",
		   "Brabant Wallon"	  => "WBR",
		   "Brussel - Bruxelles" => "BRU",
		   "Hainaut"		  => "HAI",
		   "Lige"			  => "LIE",
		   "Limburg"		  => "LIM",		   
		   "Luxembourg"		  => "LUX",	
		   "Namur"			  => "NAM",
		   "Oost-Vlaanderen"  => "OVL",
		   "Vlaams-Brabant"   => "VBR",
		   "West-Vlaanderen"   => "WVL"
		);

$germanystates = array (
		   "Baden-Wrttemberg"	=> "BW",
		   "Bayern"				=> "BY",
		   "Berlin"				=> "BE",
		   "Brandenburg"		=> "BR",
		   "Bremen"				=> "HB",
		   "Hamburg"			=> "HH",		   
		   "Hessen"				=> "HE",	
		   "Mecklenburg-Vorpommern"	=> "MV",
		   "Niedersachsen"		=> "NI",
		   "Nordrhein-Westfalen" => "NW",
		   "Rheinland-Pfalz"	=> "RP",		   
		   "Saarland"			=> "SL",	
		   "Sachsen"			=> "SN",
		   "Sachsen-Anhalt"		=> "ST",
		   "Schleswig-Holstein" => "SH",
		   "Thringen"			=> "TH"
		);

$spainstates = array (
		   "A Corua"	=> "LC",
		   "Alava"	=> "AL",
		   "Albacete"	=> "AB",
		   "Alicante"	=> "AA",
		   "Almeria"	=> "AM",
		   "Asturias"	=> "AS",
		   "Avila"	=> "AV",
		   "Badajoz"	=> "BA",
		   "Barcelona"	=> "BC",
		   "Bizkaia"	=> "VI",
		   "Burgos"	=> "BU",
		   "Caceres"	=> "CC",
		   "Cadiz"	=> "CD",
		   "Cantabria"	=> "CT",
		   "Castellon"	=> "CS",
		   "Ceuta"	=> "CE",
		   "Ciudad Real"	=> "CR",
		   "Cordoba"	=> "CO",
		   "Cuenca"	=> "CU",
		   "Gerona"	=> "GI",
		   "Gipuzkoa"	=> "GP",
		   "Granada"	=> "GR",
		   "Guadalajara"	=> "GU",
		   "Huelva"	=> "HU",
		   "Huesca"	=> "HS",
		   "Illes Balears"	=> "IB",
		   "Jaen"	=> "JA",
		   "La Rioja"	=> "LR",
		   "Las Palmas"	=> "LP",
		   "Leon"	=> "LE",
		   "Lerida"	=> "LD",
		   "Lugo"	=> "LU",
		   "Madrid"	=> "MD",
		   "Malaga"	=> "MA",
		   "Melilla"	=> "ME",
		   "Murcia"	=> "MU",
		   "Navarra"	=> "NA",
		   "Ourense"	=> "OR",
		   "Palencia"	=> "PA",
		   "Pontevedra"	=> "PO",
		   "Salamanca"	=> "SA",
		   "Segovia"	=> "SG",
		   "Sevilla"	=> "SE",
		   "Soria"	=> "SO",
		   "Tarragona"	=> "TA",
		   "Tenerife"	=> "TF",
		   "Teruel"	=> "TE",
		   "Toledo"	=> "TO",
		   "Valencia"	=> "VC",
		   "Valladolid"	=> "VD",
		   "Zamora"	=> "ZM",
		   "Zaragoza"	=> "ZA"
		);

$francestates = array (
		   "Ain"	=> "Ain",
		   "Aisne"	=> "Aisne",
		   "Allier"	=> "Allier",
		   "Alpes-de-Haute-Provence"	=> "Alpes-de-Haute-Provence",
		   "Alpes-Maritimes"	=> "Alpes-Maritimes",
		   "Ardche"	=> "Ardche",
		   "Ardennes"	=> "Ardennes",
		   "Arige"	=> "Arige",
		   "Aube"	=> "Aube",
		   "Aude"	=> "Aude",
		   "Aveyron"	=> "Aveyron",
		   "Bas-Rhin"	=> "Bas-Rhin",
		   "Bouches-du-Rhne"	=> "Bouches-du-Rhne",
		   "Calvados"	=> "Calvados",
		   "Cantal"	=> "Cantal",
		   "Charente"	=> "Charente",
		   "Charente-Maritime"	=> "Charente-Maritime",
		   "Cher"	=> "Cher",
		   "Corrze"	=> "Corrze",
		   "Corsu-du-Sud"	=> "Corsu-du-Sud",
		   "Cte-d'Or"	=> "Cte-d'Or",
		   "Ctes-d'Armor"	=> "Ctes-d'Armor",
		   "Creuse"	=> "Creuse",
		   "Deux-Sevres"	=> "Deux-Sevres",
		   "Dordogne"	=> "Dordogne",
		   "Doubs"	=> "Doubs",
		   "Drme"	=> "Drme",
		   "Essonne"	=> "Essonne",
		   "Eure"	=> "Eure",
		   "Eure-et-Loir"	=> "Eure-et-Loir",
		   "Finistre"	=> "Finistre",
		   "Gard"	=> "Gard",
		   "Gers"	=> "Gers",
		   "Gironde"	=> "Gironde",
		   "Haut-Rhin"	=> "Haut-Rhin",
		   "Haute-Corse"	=> "Haute-Corse",
		   "Haute-Garonne"	=> "Haute-Garonne",
		   "Haute-Loire"	=> "Haute-Loire",
		   "Haute-Marne"	=> "Haute-Marne",
		   "Haute-Sane"	=> "Haute-Sane",
		   "Haute-Savoie"	=> "Haute-Savoie",
		   "Haute-Vienne"	=> "Haute-Vienne",
		   "Hautes-Alpes"	=> "Hautes-Alpes",
		   "Hautes-Pyrnes"	=> "Hautes-Pyrnes",
		   "Hauts-de-Seine"	=> "Hauts-de-Seine",
		   "Hrault"	=> "Hrault",
		   "Ille-et-Vilaine"	=> "Ille-et-Vilaine",
		   "Indre"	=> "Indre",
		   "Indre-et-Loire"	=> "Indre-et-Loire",
		   "Isre"	=> "Isre",
		   "Jura"	=> "Jura",
		   "Landes"	=> "Landes",
		   "Loir-et-Cher"	=> "Loir-et-Cher",
		   "Loire"	=> "Loire",
		   "Loire-Atlantique"	=> "Loire-Atlantique",
		   "Loiret"	=> "Loiret",
		   "Lot"	=> "Lot",
		   "Lot-et-Garonne"	=> "Lot-et-Garonne",
		   "Lozre"	=> "Lozre",
		   "Maine-et-Loire"	=> "Maine-et-Loire",
		   "Manche"	=> "Manche",
		   "Marne"	=> "Marne",
		   "Mayenne"	=> "Mayenne",
		   "Meurthe-et-Moselle"	=> "Meurthe-et-Moselle",
		   "Morbihan"	=> "Morbihan",
		   "Moselle"	=> "Moselle",
		   "Nivre"	=> "Nivre",
		   "Nord"	=> "Nord",
		   "Oise"	=> "Oise",
		   "Orne"	=> "Orne",
		   "Paris"	=> "Paris",
		   "Pas-de-Calais"	=> "Pas-de-Calais",
		   "Puy-de-Dme"	=> "Puy-de-Dme",
		   "Pyrnees-Atlantiques"	=> "Pyrnees-Atlantiques",
		   "Pyrnes-Orientales"	=> "Pyrnes-Orientales",
		   "Rhne"	=> "Rhne",
		   "Sane-et-Loire"	=> "Sane-et-Loire",
		   "Sarthe"	=> "Sarthe",
		   "Savoie"	=> "Savoie",
		   "Seine-et-Marne"	=> "Seine-et-Marne",
		   "Seine-Maritime"	=> "Seine-Maritime",
		   "Seine-Saint-Denis"	=> "Seine-Saint-Denis",
		   "Somme"	=> "Somme",
		   "Tarn"	=> "Tarn",
		   "Tarn-et-Garonne"	=> "Tarn-et-Garonne",
		   "Territoire-de-Belfort"	=> "Territoire-de-Belfort",
		   "Val-d'Oise"	=> "Val-d'Oise",
		   "Val-de-Marne"	=> "Val-de-Marne",
		   "Var"	=> "Var",
		   "Vaucluse"	=> "Vaucluse",
		   "Vende"	=> "Vende",
		   "Vienne"	=> "Vienne",
		   "Vosges"	=> "Vosges",
		   "Yonne"	=> "Yonne",
		   "Yvelines"	=> "Yvelines"
		);

$ukstates = array (
		   "Aberdeenshire" => "ABE",
		   "Anglesey" => "ANL",
		   "Angus" => "ANG",
		   "Argyllshire" => "ARG",
		   "Ayrshire" => "AYR",
		   "Banffshire" => "BAN",
		   "Bedfordshire"	=> "BDF",
		   "Berkshire"	=> "BER",
		   "Berwickshire"  => "BEW",
		   "Brecknockshire" => "BRE",
		   "Buckinghamshire"	=> "BKM",
		   "Buteshire" => "BUT",
		   "Caernarfonshire" => "CAE",
		   "Caithness" => "CAI",
		   "Cambridgeshire"	=> "CAM",
		   "Carmarthenshire" => "CAR",
		   "Cardiganshire" => "CAD",
		   "Cheshire"	=> "CHS",
		   "Clackmannanshire" => "CLA" ,
		   "Cornwall"	=> "CON",
		   "County Antrim"	=> "ANT",
		   "County Armagh"	=> "ARM",
		   "County Down"	=> "DOW",
		   "County Fermanagh"	=> "FER",
		   "County Londonderry"	=> "LDY",
		   "County Tyrone"	=> "TYR",
		   "Cromartyshire" => "CRO",
		   "Cumberland" => "CUM",
		   "Derbyshire"	=> "DBY",
		   "Denbighshire" => "DEN",
		   "Devon"	=> "DEV",
		   "Dorset"	=> "DOR",
		   "Dumfriesshire"	=> "DUM",
		   "Dunbartonshire"	=> "DUN",
		   "Durham" => "DUR",
		   "East Lothian" => "ELO",
		   "Essex"	=> "ESS",
		   "Fife"	=> "FIF",
		   "Flintshire" => "FLI",
		   "Glamorgan"	=> "GLM",
		   "Gloucestershire"	=> "GLS",
		   "Hampshire"	=> "HAM",
		   "Herefordshire"	=> "HEF",
		   "Hertfordshire"	=> "HRT",
		   "Huntingdonshire"	=> "HUN",
		   "Inverness-shire"  => "INV",
		   "Isle of Man" => "IOM",
		   "Kent"	=> "KEN",
		   "Kincardineshire" => "KIN",
		   "Kinross-shire" => "KIR",
		   "Kirkcudbrightshire" => "KIK",
		   "Lanarkshire" => "LAR",
		   "Lancashire"	=> "LAN",
		   "Leicestershire"	=> "LEC",
		   "Lincolnshire"	=> "LIN",
		   "London"	=> "GLN",
		   "Merioneth" => "MER",
		   "Middlesex"	=> "MIS",
		   "Midlothian"	=> "MID",
		   "Monmouthshire" => "MON",
		   "Montgomeryshire" => "MOG",
		   "Morayshire" => "MOR",
		   "Nairnshire"	=> "NAI",
		   "Norfolk"	=> "NFK",
		   "Northamptonshire"	=> "NTH",
		   "Northumberland"	=> "NBL",
		   "Nottinghamshire"	=> "NTT",
		   "Orkney" => "ORK",
		   "Oxfordshire"	=> "OXF",
		   "Peeblesshire" => "PEE",
		   "Perthshire"  => "PER",
		   "Pembrokeshire" => "PEM",
		   "Radnorshire"  => "RAD",
		   "Renfrewshire"  => "REN",
		   "Ross-shire"  => "ROS",
		   "Roxburghshire" => "ROX",
		   "Rutland"	=> "RUT",
		   "Selkirkshire"  => "SEL",
		   "Shetland" => "SHE",
		   "Shropshire"	=> "SHR",
		   "Somerset"	=> "SOM",
		   "Staffordshire"	=> "STS",
		   "Stirlingshire" => "STI",
		   "Suffolk"	=> "SFK",
		   "Surrey"	=> "SRY",
		   "Sussex" => "SUS",
		   "Sutherland" => "SUT",
		   "Warwickshire"	=> "WAR",
		   "West Lothian" => "WEL",
		   "Westmorland"	=> "WMO",
		   "West Midlands"	=> "WML",
		   "Wigtownshire" => "WTS",
		   "Wiltshire"	=> "WIL",
		   "Worcestershire"	=> "WOR",
		   "Yorkshire East Riding" => "YER",
		   "Yorkshire North" => "YON",
		   "Yorkshire South" => "YOS",
		   "Yorkshire West" => "YOW"
);

$italystates = array (
		   "Agrigento"	=> "AG",
		   "Alessandria"	=> "AL",
		   "Ancona"	=> "AN",
		   "Arezzo"	=> "AR",
		   "Ascoli Piceno"	=> "AP",
		   "Asti"	=> "AT",
		   "Avellino"	=> "AV",
		   "Bari"	=> "BA",
		   "Belluno"	=> "BL",
		   "Benevento"	=> "BN",
		   "Bergamo"	=> "BG",
		   "Biella"	=> "BI",
		   "Bologna"	=> "BO",
		   "Bolzano"	=> "BZ",
		   "Brescia"	=> "BS",
		   "Brindisi"	=> "BR",
		   "Cagliari"	=> "CA",
		   "Caltanissetta"	=> "CL",
		   "Campobasso"	=> "CB",
		   "Caserta"	=> "CE",
		   "Catania"	=> "CT",
		   "Catanzaro"	=> "CZ",
		   "Chieti"	=> "CH",
		   "Como"	=> "CO",
		   "Cosenza"	=> "CS",
		   "Cremona"	=> "CR",
		   "Crotone"	=> "KR",
		   "Cuneo"	=> "CN",
		   "Enna"	=> "EN",
		   "Ferrara"	=> "FE",
		   "Firenze"	=> "FI",
		   "Foggia"	=> "FG",
		   "Forl-Cesena"	=> "FC",
		   "Frosinone"	=> "FR",
		   "Genova"	=> "GE",
		   "Gorizia"	=> "GO",
		   "Grosseto"	=> "GR",
		   "Imperia"	=> "IM",
		   "Isernia"	=> "IS",
		   "L'Aquila"	=> "AQ",
		   "La Spezia"	=> "SP",
		   "Latina"	=> "LT",
		   "Lecce"	=> "LE",
		   "Lecco"	=> "LC",
		   "Livorno"	=> "LI",
		   "Lodi"	=> "LO",
		   "Lucca"	=> "LU",
		   "Macerata"	=> "MC",
		   "Mantova"	=> "MN",
		   "Massa-Carrara"	=> "MS",
		   "Matera"	=> "MT",
		   "Messina"	=> "ME",
		   "Milano"	=> "MI",
		   "Modena"	=> "MO",
		   "Napoli"	=> "NA",
		   "Novara"	=> "NO",
		   "Nuoro"	=> "NU",
		   "Oristano"	=> "OR",
		   "Padova"	=> "PD",
		   "Palermo"	=> "PA",
		   "Parma"	=> "PR",
		   "Pavia"	=> "PV",
		   "Perugia"	=> "PG",
		   "Pesaro e Urbino"	=> "PU",
		   "Pescara"	=> "PE",
		   "Piacenza"	=> "PC",
		   "Pisa"	=> "PI",
		   "Pistoia"	=> "PT",
		   "Pordenone"	=> "PN",
		   "Potenza"	=> "PZ",
		   "Prato"	=> "PO",
		   "Ragusa"	=> "RG",
		   "Ravenna"	=> "RA",
		   "Reggio Calabria"	=> "RC",
		   "Reggio Emilia"	=> "RE",
		   "Rieti"	=> "RI",
		   "Rimini"	=> "RN",
		   "Roma"	=> "RM",
		   "Rovigo"	=> "RO",
		   "Salerno"	=> "SA",
		   "Sassari"	=> "SS",
		   "Savona"	=> "SV",
		   "Siena"	=> "SI",
		   "Siracusa"	=> "SR",
		   "Sondrio"	=> "SO",
		   "Taranto"	=> "TA",
		   "Teramo"	=> "TE",
		   "Terni"	=> "TR",
		   "Torino"	=> "TO",
		   "Trapani"	=> "TP",
		   "Trento"	=> "TN",
		   "Treviso"	=> "TV",
		   "Trieste"	=> "TS",
		   "Udine"	=> "UD",
		   "Valle d'Aosta"	=> "AO",
		   "Varese"	=> "VA",
		   "Venezia"	=> "VE",
		   "Verbano-Cusio-Ossola"	=> "VB",
		   "Vercelli"	=> "VC",
		   "Verona"	=> "VR",
		   "Vibo Valentia"	=> "VV",
		   "Vicenza"	=> "VI",
		   "Viterbo"	=> "VT"
		);

$luxembourgstates = array (
		   "Diekirch"	=> "D",
		   "Grevenmacher"	=> "G",
		   "Luxemburg"	=> "L"
		);

$netherlandsstates = array (
		   "Drenthe"	=> "DRE",
		   "Flevoland"	=> "FLE",
		   "Friesland"	=> "FRI",
		   "Gelderland"	=> "GEL",
		   "Groningen"	=> "GRO",
		   "Limburg"	=> "LIM",
		   "Noord-Brabant"	=> "NBR",
		   "Noord-Holland"	=> "NHO",
		   "Overijssel"	=> "OVE",
		   "Utrecht"	=> "UTR",
		   "Zeeland"	=> "ZEE",
		   "Zuid-Holland"	=> "ZHO"
		);

$ecmembers = array (
"BE",
"DK",
"DE",
"GR",
"ES",
"FR",
"IE",
"IT",
"LU",
"NL",
"AT",
"PT",
"FI",
"SE",
"GB",
"CY",
"CZ",
"EE",
"HU",
"LV",
"LT",
"MT",
"PL",
"SK",
"SI",
"BG",
"RO"
);

$upspickuptypes = array (
"01" => "Daily Pickup",
"03" => "Customer Counter",
"06" => "One Time Pickup",
"07" => "On Call Air",
"11" => "Suggested Retail Rates",
"19" => "Letter Center",
"20" => "Air Service Center"
);

$upsdropofftypes = array (
"1" => "Pay shipping charges and ship my package.",
"2" => "Drop off my prepaid package(s).",
"3" => "Schedule pickup on: UPS.com/1-800-Pick-UPS",
"4" => "Give the package(s) to my UPS driver."
);

$upsservicesusa = array (
"03" => "UPS Ground",
"12" => "UPS 3 Day Select",
"02" => "UPS 2nd Day Air",
"59" => "UPS 2nd Day Air A.M.",
"13" => "UPS Next Day Air Saver",
"01" => "UPS Next Day Air",
"14" => "UPS Next Day Air Early A.M."
);

$upsservicescan = array (
"11" => "UPS Standard",
"02" => "UPS Expedited",
"13" => "UPS Express Saver",
"01" => "UPS Express",
"14" => "UPS Express Early A.M."
);

$upsservicesworld = array (
"08" => "UPS Worldwide Expedited",
"65" => "UPS Worldwide Saver"
);

$upsservicestocan = array (
"11" => "UPS Standard",
"08" => "UPS Worldwide Expedited",
"65" => "UPS Worldwide Saver"
);

$upsservicestousa = array (
"11" => "UPS Standard",
"12" => "UPS 3 Day Select",
"08" => "UPS Worldwide Expedited",
"65" => "UPS Express Saver",
"07" => "UPS Worldwide Express",
"54" => "UPS Worldwide Express Plus"
);

$upspackagetypes = array (
"01" => "UPS letter/ UPS Express Envelope",
"02" => "Package",
"03" => "UPS Tube",
"04" => "UPS Pak",
"21" => "UPS Express Box",
"24" => "UPS 25Kg Box",
"25" => "UPS 10Kg Box"
);

$uspsservicesusa = array (
"FIRST CLASS" => "First-Class",
"PRIORITY"    => "Priority Mail",
"EXPRESS"     => "Express Mail",
"PARCEL"      => "Parcel Post",
"MEDIA"       => "Media Mail",
"LIBRARY"     => "Library"
);

$uspsservicesworld = array (
"First-Class Mail International Parcel" => "First-Class",
"USPS GXG" => "Global Express Guaranteed",
"Priority Mail International"    => "Priority Mail International",
"Express Mail International"     => "Express Mail International"
);

$uspsservicesusa_num = array (
"01" => "First Class",
"02"    => "Priority Mail",
"03"     => "Express Mail",
"04"      => "Parcel Post",
"05"       => "Media Mail",
"06"     => "Library"
);

$uspsservicesworld_num = array (
"01" => "First Class",
"02" => "Global Express Guaranteed",
"03"    => "Priority Mail International",
"04"     => "Express Mail International"
);

$uspscontainers = array (
"VARIABLE"           => "Variable",
"FLAT RATE BOX"      => "Flat-Rate Box",
"FLAT RATE ENVELOPE" => "Flat-Rate Envelope",
"RECTANGULAR"        => "Rectangular",
"NONRECTANGULAR"     => "Non-rectangular"
);

$uspssizes = array (
"REGULAR"     => "Regular",
"LARGE"       => "Large",
"OVERSIZE"    => "Oversize"
);

$fedexservicesusa = array (
"FEDEX_GROUND" => "FedEx Ground Service",
"GROUND_HOME_DELIVERY" => "FedEx Home Delivery",
"FEDEX_EXPRESS_SAVER" => "FedEx Express Saver",
"FEDEX_2_DAY" => "FedEx 2day",
"STANDARD_OVERNIGHT" => "FedEx Standard Overnight",
"PRIORITY_OVERNIGHT" => "FedEx Priority",
"FIRST_OVERNIGHT" => "FedEx First Overnight",
"FEDEX_2_DAY_FREIGHT" => "FedEx 2day Freight"
);

$fedexservicesworld = array (
"FEDEX_GROUND" => "FedEx Ground Service",
"INTERNATIONAL_ECONOMY" => "FedEx International Economy",
"INTERNATIONAL_PRIORITY" => "FedEx International Priority",
"INTERNATIONAL_FIRST" => "FedEx International First",
"INTERNATIONAL_ECONOMY_FREIGHT" => "FedEx International Economy Freight",
"INTERNATIONAL_PRIORITY_FREIGHT" => "FedEx International Priority Freight"
);

$fedexpackagetypes = array (
"YOUR_PACKAGING" => "Customer packaging",
"FEDEX_PAK" => "FedEx Pak",
"FEDEX_BOX" => "FedEx Box",
"FEDEX_TUBE" => "FedEx Tube",
"FEDEX_ENVELOPE" => "FedEx Envelope",
"FEDEX_10KG_BOX" => "FedEx 10kg Box",
"FEDEX_25KG_BOX" => "FedEx 25kg Box"
);

$mimetypes = array (      
	"ai" 	=> "application/postscript",
    "aif"	=> "audio/x-aiff",
    "aifc"	=> "audio/x-aiff",
    "aiff"	=> "audio/x-aiff",
    "asc"	=> "text/plain",
    "au"	=> "audio/basic",
    "avi"	=> "video/x-msvideo",
	"bcpio"	=> "application/x-bcpio",
    "bin"	=> "application/octet-stream",
    "c"		=> "text/plain",
    "cc"	=> "text/plain",
    "ccad"	=> "application/clariscad",
    "cdf"	=> "application/x-netcdf",
	"class"	=> "application/octet-stream",
    "cpio"	=> "application/x-cpio",
    "cpt"	=> "application/mac-compactpro",
    "csh"	=> "application/x-csh",
    "css"	=> "text/css",
    "dcr"	=> "application/x-director",
    "dir"	=> "application/x-director",
    "dms"	=> "application/octet-stream",
    "doc"	=> "application/msword",
    "drw"	=> "application/drafting",
    "dvi"	=> "application/x-dvi",
    "dwg"	=> "application/acad",
    "dxf"	=> "application/dxf",
    "dxr"	=> "application/x-director",
    "eps"	=> "application/postscript",
	"etx"	=> "text/x-setext",
    "exe"	=> "application/octet-stream",
    "ez"	=> "application/andrew-inset",
    "f"		=> "text/plain",
    "f90"	=> "text/plain",
    "fli"	=> "video/x-fli",
	"flv"	=> "video/x-flv",
    "gif"	=> "image/gif",
    "gtar"	=> "application/x-gtar",
    "gz"	=> "application/x-gzip",
    "h"		=> "text/plain",
    "hdf"	=> "application/x-hdf",
    "hh"	=> "text/plain",
    "hqx"	=> "application/mac-binhex40",
    "htm"	=> "text/html",
    "html"	=> "text/html",
    "ice"	=> "x-conference/x-cooltalk",
    "ief"	=> "image/ief",
    "iges"	=> "model/iges",
    "igs"	=> "model/iges",
    "ips"	=> "application/x-ipscript",
    "ipx"	=> "application/x-ipix",
    "jpe"	=> "image/jpeg",
    "jpeg"	=> "image/jpeg",
    "jpg"	=> "image/jpeg",
    "js"	=> "application/x-javascript",
    "kar"	=> "audio/midi",
    "latex"	=> "application/x-latex",
    "lha"	=> "application/octet-stream",
    "lsp"	=> "application/x-lisp",
    "lzh"	=> "application/octet-stream",
    "m"		=> "text/plain",
    "man"	=> "application/x-troff-man",
    "me"	=> "application/x-troff-me",
    "mesh"	=> "model/mesh",
    "mid"	=> "audio/midi",
    "midi"	=> "audio/midi",
    "mif"	=> "application/vnd.mif",
    "mime"	=> "www/mime",
    "mov"	=> "video/quicktime",
    "movie"	=> "video/x-sgi-movie",
    "mp2"	=> "audio/mpeg",
    "mp3"	=> "audio/mpeg",
	"mp4"	=> "video/mp4",
    "mpe"	=> "video/mpeg",
    "mpeg"	=> "video/mpeg",
    "mpg"	=> "video/mpeg",
    "mpga"	=> "audio/mpeg",
    "ms"	=> "application/x-troff-ms",
    "msh"	=> "model/mesh",
    "nc"	=> "application/x-netcdf",
    "oda"	=> "application/oda",
    "pbm"	=> "image/x-portable-bitmap",
    "pdb"	=> "chemical/x-pdb",
    "pdf"	=> "application/pdf",
    "pgm"	=> "image/x-portable-graymap",
    "pgn"	=> "application/x-chess-pgn",
    "png"	=> "image/png",
    "pnm"	=> "image/x-portable-anymap",
    "pot"	=> "application/mspowerpoint",
    "ppm"	=> "image/x-portable-pixmap",
    "pps"	=> "application/mspowerpoint",
    "ppt"	=> "application/mspowerpoint",
    "ppz"	=> "application/mspowerpoint",
    "pre"	=> "application/x-freelance",
    "prt"	=> "application/pro_eng",
    "ps"	=> "application/postscript",
    "qt"	=> "video/quicktime",
    "ra"	=> "audio/x-realaudio",
    "ram"	=> "audio/x-pn-realaudio",
    "ras"	=> "image/cmu-raster",
    "rgb"	=> "image/x-rgb",
    "rm"	=> "audio/x-pn-realaudio",
    "roff"	=> "application/x-troff",
    "rpm"	=> "audio/x-pn-realaudio-plugin",
    "rtf"	=> "text/rtf",
    "rtx"	=> "text/richtext",
    "scm"	=> "application/x-lotusscreencam",
    "set"	=> "application/set",
    "sgm"	=> "text/sgml",
    "sgml"	=> "text/sgml",
    "sh"	=> "application/x-sh",
    "shar"	=> "application/x-shar",
    "silo"	=> "model/mesh",
    "sit"	=> "application/x-stuffit",
    "skd"	=> "application/x-koan",
    "skm"	=> "application/x-koan",
    "skp"	=> "application/x-koan",
    "skt"	=> "application/x-koan",
    "smi"	=> "application/smil",
    "smil"	=> "application/smil",
    "snd"	=> "audio/basic",
    "sol"	=> "application/solids",
    "spl"	=> "application/x-futuresplash",
    "src"	=> "application/x-wais-source",
    "step"	=> "application/STEP",
    "stl"	=> "application/SLA",
    "stp"	=> "application/STEP",
	"sv4cpio" => "application/x-sv4cpio",
    "sv4crc" => "application/x-sv4crc",
    "swf"	=> "application/x-shockwave-flash",
    "t"		=> "application/x-troff",
    "tar"	=> "application/x-tar",
    "tcl"	=> "application/x-tcl",
    "tex"	=> "application/x-tex",
    "texi"	=> "application/x-texinfo",
	"texinfo" => "application/x-texinfo",
    "tif"	=> "image/tiff",
    "tiff"	=> "image/tiff",
    "tr"	=> "application/x-troff",
    "tsi"	=> "audio/TSP-audio",
    "tsp"	=> "application/dsptype",
    "tsv"	=> "text/tab-separated-values",
    "txt"	=> "text/plain",
    "unv"	=> "application/i-deas",
    "ustar"	=> "application/x-ustar",
    "vcd"	=> "application/x-cdlink",
    "vda"	=> "application/vda",
    "viv"	=> "video/vnd.vivo",
    "vivo"	=> "video/vnd.vivo",
    "vrml"	=> "model/vrml",
    "wav"	=> "audio/x-wav",
	"wma"	=> "audio/x-ms-wma",
	"wmv"	=> "video/x-ms-wmv",
    "wrl"	=> "model/vrml",
    "xbm"	=> "image/x-xbitmap",
    "xlc"	=> "application/vnd.ms-excel",
    "xll"	=> "application/vnd.ms-excel",
    "xlm"	=> "application/vnd.ms-excel",
    "xls"	=> "application/vnd.ms-excel",
    "xlw"	=> "application/vnd.ms-excel",
    "xml"	=> "text/xml",
    "xpm"	=> "image/x-xpixmap",
    "xwd"	=> "image/x-xwindowdump",
    "xyz"	=> "chemical/x-pdb",
    "zip"	=> "application/zip"
);
?>